#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <iostream.h>
#include <typeinfo>

#include "strutil.h"
#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "ntuple.h"

#include "pawexecut.h"
#include "nobjmgr.h"
#include "servnobjm.h"
#include "pistdimgapp.h"

#ifdef SANS_EVOLPLANCK
#include "cvector.h"
#include "matrix.h"
#else
#include "tmatrix.h"
#include "tvector.h"
#endif

/* Reza + cmv  13/10/99 */

uint_4 PAWExecutor::autoc_counter_ = 0;

/* methode */
PAWExecutor::PAWExecutor(PIACmd *piac, PIStdImgApp* app)
: mApp(app)
{
string kw, usage;
string hgrp = "pawCmd";

kw = "reset";
usage = "Reset histograms vectors or matrix";
usage += "\n reset nameobj";
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "n/plot";
usage = "Plot NTuple variables a la paw";
usage += "\n n/plot nameobj.x_exp [cut] [w_exp] [loop] [gratt]";
usage += "\n n/plot nameobj.y_exp%x_exp [cut] [loop] [gratt]";
usage += "\n n/plot nameobj.z_exp%y_exp%x_exp [cut] [loop] [gratt]";
usage += "\n        for default use ! , loop=i1[:i2[:di]]";
usage += "\n  Related commands: plot2dw plot3d";  
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "n/proj";
usage = "Project NTuple in histogram (1D or 2D) a la paw";
usage += "\n n/proj nameproj nameobj.x_exp [cut] [w_exp] [loop] [gratt]";
usage += "\n n/proj nameproj nameobj.y_exp%x_exp [cut] [w_exp] [loop] [gratt]";
usage += "\n        for default use ! , loop=i1[:i2[:di]]";
usage += "\n  Related commands: projh1d projh2d projprof";  
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/integ";
usage = "Integrate a 1D histogram";
usage += "\n h/integ nameh1d [norm]";
usage += "\n  Related commands: h/deriv";
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/deriv";
usage = "Derivate a 1D histogram";
usage += "\n h/deriv nameh1d";
usage += "\n  Related commands: h/integ";
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/rebin";
usage = "Rebin a 1D histogram or profile";
usage += "\n h/rebin nameh1d nbin";
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/cadd";
usage = "Add a constant to an histogram";
usage += "\n h/cadd namehisto val";
usage += "\n  Related commands: h/cmult h/oper";  
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/cmult";
usage = "Multiply an histogram by a constant";
usage += "\n h/cmult namehisto val";
usage += "\n  Related commands: h/cadd h/oper";  
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/oper";
usage = "Operation on histograms";
usage += "\n h/oper @ h1 h2 hres";
usage += "\n        hres = h1 @ h2   with @ = (+,-,*,/)";
usage += "\n  Related commands: h/cadd h/cmult";  
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/plot/2d";
usage = "Specific plot for 2D histogrammes";
usage += "\n h/plot/2d nameh2d show        : infos on 2D histogramme";
usage += "\n h/plot/2d nameh2d h    [dopt] : plot 2D histogramme";
usage += "\n h/plot/2d nameh2d px   [dopt] : plot X projection";
usage += "\n h/plot/2d nameh2d py   [dopt] : plot Y projection";
usage += "\n h/plot/2d nameh2d bx n [dopt] : plot X band number n";
usage += "\n h/plot/2d nameh2d by n [dopt] : plot Y band number n";
usage += "\n h/plot/2d nameh2d sx n [dopt] : plot X slice number n";
usage += "\n h/plot/2d nameh2d sy n [dopt] : plot Y slice number n";
usage += "\n                      n < 0 means Show Info";
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/put_vec";
usage = "Put content of vector (matrix) into content of histogram 1D or 2D";
usage += "\n h/put_vec nameh1d namevector [cont,err2]";
usage += "\n h/put_vec nameh2d namematrix [cont,err2]";
usage += "\n     cont : put into histogramme content";
usage += "\n     err2 : put into histogramme error^2";
usage += "\n  Related commands: h/get_vec";  
piac->RegisterCommand(kw,usage,this,hgrp);

kw = "h/get_vec";
usage = "Get content of histogram 1D profile or 2D into vector (matrix)";
usage += "\n h/get_vec nameh1d namevector [cont,err2,absc] [proj]";
usage += "\n h/get_vec nameh2d namematrix [cont,err2,absc]";
usage += "\n   cont : get histogramme content";
usage += "\n   err2 : get histogramme error^2";
usage += "\n   absc : get histogramme low bin abscissa (1D only)";
usage += "\n     proj :";
usage += "\n            show  : show available projections for Histo2D";
usage += "\n            px    : get X projection";
usage += "\n            py    : get Y projection";
usage += "\n            bx n  : get X band number n";
usage += "\n            by n  : get Y band number n";
usage += "\n            sx n  : get X slice number n";
usage += "\n            sy n  : get Y slice number n";
usage += "\n  Related commands: h/put_vec";  
piac->RegisterCommand(kw,usage,this,hgrp);

}

/* methode */
PAWExecutor::~PAWExecutor()
{
}

/* methode */
int PAWExecutor::Execute(string& kw, vector<string>& tokens)
{
if(kw == "reset") {
  reset(tokens); return(0);
} else if(kw == "n/plot") {
  n_plot(tokens); return(0);
} else if(kw == "n/proj") {
  n_proj(tokens); return(0);
} else if(kw == "h/integ") {
  h_integ(tokens); return(0);
} else if(kw == "h/deriv") {
  h_deriv(tokens); return(0);
} else if(kw == "h/rebin") {
  h_rebin(tokens); return(0);
} else if(kw == "h/cadd") {
  h_cadd(tokens); return(0);
} else if(kw == "h/cmult") {
  h_cmult(tokens); return(0);
} else if(kw == "h/oper") {
  h_oper(tokens); return(0);
} else if(kw == "h/plot/2d") {
  h_plot_2d(tokens); return(0);
} else if(kw == "h/put_vec") {
  h_put_vec(tokens); return(0);
} else if(kw == "h/get_vec") {
  h_get_vec(tokens); return(0);
} else return(1); 
}

/* methode */
void PAWExecutor::reset(vector<string>& tokens)
// Reset d'histogrammes, vecteurs et matrices
{
if(tokens.size() < 1)
  {cout<<"Usage: reset nameobj"<<endl; return;}
NamedObjMgr omg;
AnyDataObj* mobj = omg.GetObj(tokens[0]);
if(mobj == NULL)
  {cout<<"PAWExecutor::reset Error , Pas d'objet de nom "<<tokens[0]<<endl;
   return;}
string ctyp = typeid(*mobj).name();

#ifdef SANS_EVOLPLANCK
if(typeid(*mobj)==typeid(Vector))       {Vector*  ob=(Vector*) mobj; ob->Zero();}
else if(typeid(*mobj)==typeid(Matrix))  {Matrix*  ob=(Matrix*) mobj; ob->Zero();}
#else
 if(typeid(*mobj)==typeid(Vector))       {Vector*  ob=(Vector*) mobj; (*ob) = 0.; }
// ob->DataBlock().Reset(0.);}
 else if(typeid(*mobj)==typeid(Matrix))   {Matrix*  ob=(Matrix*) mobj; (*ob) = 0.; }
//ob->DataBlock().Reset(0.);}
#endif
else if(typeid(*mobj)==typeid(Histo))   {Histo*   ob=(Histo*)  mobj; ob->Zero();}
else if(typeid(*mobj)==typeid(HProf))   {HProf*   ob=(HProf*)  mobj; ob->Zero();}
else if(typeid(*mobj)==typeid(Histo2D)) {Histo2D* ob=(Histo2D*)mobj; ob->Zero();}
else {
  cout<<"PAWExecutor::reset Error , No reset possible on "<<ctyp<<endl;
  return;
}

return;
}

/* methode */
void PAWExecutor::n_plot(vector<string>& tokens)
// Equivalent n/plot de paw
// Plot 1D
//   n/plot nameobj.x_exp [cut] [w_exp] [gratt]
// Plot 2D (plot2dw)
//   n/plot nameobj.y_exp%x_exp [cut] [w_exp] [gratt]
// Plot 3D (plot3d)
//   n/plot nameobj.z_exp%y_exp%x_exp [cut] [gratt]
{
if(tokens.size() < 1) {
  cout
  <<"Usage: n/plot nameobj.x_exp [cut] [w_exp] [loop] [gratt] [nomh1]"<<endl
  <<"       n/plot nameobj.y_exp%x_exp [cut] [loop] [gratt]"<<endl
  <<"       n/plot nameobj.z_exp%y_exp%x_exp [cut] [loop] [gratt]"<<endl
  <<"              for default use ! , loop=i1[:i2[:di]]"<<endl;
  return;
}
string nameobj,expx,expy,expz;
int nvar = decodepawstring(tokens[0],nameobj,expx,expy,expz);
string expcut = "1"; string expwt = "1."; string loop = "";
string dopt = ""; string nameproj="";
if(tokens.size()>=2) expcut = tokens[1]; if(expcut=="!") expcut="1";

NamedObjMgr omg;
Services2NObjMgr* srvo = omg.GetServiceObj();

if(nvar<=0) {
  cout<<"PAWExecutor::n_plot Error: bad coding "<<tokens[0]<<endl;
} else if(nvar==1) { // c'est un plot 1D
  if(tokens.size()>=3) expwt    = tokens[2]; if(expwt=="!") expwt="1.";
  if(tokens.size()>=4) loop     = tokens[3]; if(loop=="!") loop="";
  if(tokens.size()>=5) dopt     = tokens[4]; if(dopt=="!") dopt="";
  if(tokens.size()>=6) nameproj = tokens[5];
  if(nameproj.length()<=0 || nameproj=="!") {
    nameproj = "/autoc/paw_n_plot1D_";
    AnyDataObj* mobj = omg.GetObj(nameproj);
    if(mobj!=NULL) {
      char buff[16]; autoc_counter_++; sprintf(buff,"%d",autoc_counter_);
      nameproj += buff;
    }
  }
  srvo->ProjectH1(nameobj,expx,expwt,expcut,nameproj,dopt,loop);
} else if(nvar==2) { // c'est un plot 2D
  if(tokens.size()>=3) loop = tokens[2]; if(loop=="!") loop="";
  if(tokens.size()>=4) dopt = tokens[3];
  string err = "";
  srvo->DisplayPoints2D(nameobj,expx,expy,err,err,expcut,dopt,loop);
} else {             // c'est un plot 3D
  if(tokens.size()>=3) loop = tokens[2]; if(loop=="!") loop="";
  if(tokens.size()>=4) dopt = tokens[3];
  srvo->DisplayPoints3D(nameobj,expx,expy,expz,expcut,dopt,loop);
}

return;
}

/* methode */
void PAWExecutor::n_proj(vector<string>& tokens)
// Equivalent n/proj de paw
// Project NTuple in histogram a la paw
// Dans un Histo 1D
//   n/proj nameproj nameobj.x_exp [cut] [w_exp] [gratt]
// Dans un Histo 2D ou un HProf (dans ce cas nameproj doit etre cree).
//   n/proj nameproj nameobj.y_exp%x_exp [cut] [w_exp] [gratt]
{
if(tokens.size()<2)
  {cout<<"Usage: n/proj nameproj nameobj.[y_exp%]x_exp [cut] [w_exp] [loop] [gratt]"<<endl
       <<"              for default use ! , loop=i1[:i2[:di]]"<<endl; return;}
string nameproj = tokens[0];
string nameobj,expx,expy,expz;
int nvar = decodepawstring(tokens[1],nameobj,expx,expy,expz);
string expcut = "1"; string expwt = "1."; string loop = ""; string dopt = "";
if(tokens.size()>=3) expcut = tokens[2]; if(expcut=="!") expcut="1";
if(tokens.size()>=4) expwt  = tokens[3]; if(expwt=="!") expwt="1.";
if(tokens.size()>=5) loop   = tokens[4]; if(loop=="!") loop="";
if(tokens.size()>=6) dopt   = tokens[5];

NamedObjMgr omg;
Services2NObjMgr* srvo = omg.GetServiceObj();

if(nvar<=0) {
  cout<<"PAWExecutor::n_proj Error: bad coding "<<tokens[1]<<endl;
} else if(nvar==1) {
  // c'est une projection dans un histo 1D
  srvo->ProjectH1(nameobj,expx,expwt,expcut,nameproj,dopt,loop);
} else {
  // c'est une projection dans un histo2D
  // OU un HProf si nameproj est HProf un deja defini
  AnyDataObj* mobj = omg.GetObj(nameproj);
  if(mobj==NULL)
    srvo->ProjectH2(nameobj,expx,expy,expwt,expcut,nameproj,dopt,loop);
  else if(dynamic_cast<HProf*>(mobj))
    srvo->ProjectHProf(nameobj,expx,expy,expwt,expcut,nameproj,dopt,loop);
  else
    srvo->ProjectH2(nameobj,expx,expy,expwt,expcut,nameproj,dopt,loop);
}

return;
}

/* methode */
void PAWExecutor::h_integ(vector<string>& tokens)
// Pour remplacer le contenu d'un histo 1D par son integrale
{
if(tokens.size()<1)
  {cout<<"Usage: h/integ nameh1d [norm]"<<endl; return;}
NamedObjMgr omg;
AnyDataObj* mobj = omg.GetObj(tokens[0]);
if(mobj==NULL)
  {cout<<"PAWExecutor::h_integ Error: unknow object"<<tokens[0]<<endl;
  return;}
double norm = 1.;
if(tokens.size()>=2) norm = atof(tokens[1].c_str());
// attention: dynamic_cast<Histo*>(HProf)=Vrai!
Histo* h1 = dynamic_cast<Histo*>(mobj);
HProf* hp = dynamic_cast<HProf*>(mobj);
if(hp || !h1)
  {cout<<"PAWExecutor::h_integ Error: "<<tokens[0]<<" not an Histo"<<endl;
  return;}
h1->HInteg(norm);
}

/* methode */
void PAWExecutor::h_deriv(vector<string>& tokens)
// Pour remplacer le contenu d'un histo 1D par sa derivee
{
if(tokens.size()<1)
  {cout<<"Usage: h/deriv nameh1d"<<endl; return;}
NamedObjMgr omg;
AnyDataObj* mobj = omg.GetObj(tokens[0]);
if(mobj==NULL)
  {cout<<"PAWExecutor::h_deriv Error: unknow object"<<tokens[0]<<endl;
  return;}
// attention: dynamic_cast<Histo*>(HProf)=Vrai!
Histo* h1 = dynamic_cast<Histo*>(mobj);
HProf* hp = dynamic_cast<HProf*>(mobj);
if(hp || !h1)
  {cout<<"PAWExecutor::h_deriv Error: "<<tokens[0]<<" not an Histo"<<endl;
  return;}
h1->HDeriv();
}

/* methode */
void PAWExecutor::h_rebin(vector<string>& tokens)
// Pour re-binner un histogramme 1D
{
if(tokens.size()<2)
  {cout<<"Usage: h/rebin nameh1d nbin"<<endl; return;}
NamedObjMgr omg;
AnyDataObj* mobj = omg.GetObj(tokens[0]);
if(mobj==NULL)
  {cout<<"PAWExecutor::h_rebin Error: unknow object"<<tokens[0]<<endl;
  return;}
int nbin = atoi(tokens[1].c_str());
Histo* h1 = dynamic_cast<Histo*>(mobj);
// Ca marche aussi pour les HProf, HRebin a ete passe virtuel
//HProf* hp = dynamic_cast<HProf*>(mobj); if(hp || !h1)
if(!h1)
  {cout<<"PAWExecutor::h_rebin Error: "<<tokens[0]<<" not an Histo"<<endl;
  return;}
h1->HRebin(nbin);
}

/* methode */
void PAWExecutor::h_cadd(vector<string>& tokens)
// Additionne une constante a un histogramme
{
if(tokens.size()<2)
  {cout<<"Usage: h/cadd nameh1d val"<<endl; return;}
NamedObjMgr omg;
AnyDataObj* mobj = omg.GetObj(tokens[0]);
if(mobj==NULL)
  {cout<<"PAWExecutor::h_cadd Error: unknow object"<<tokens[0]<<endl;
  return;}
double val = atof(tokens[1].c_str());
Histo*   h1 = dynamic_cast<Histo*>(mobj);
HProf*   hp = dynamic_cast<HProf*>(mobj);
Histo2D* h2 = dynamic_cast<Histo2D*>(mobj);
if(h1 && !hp) *h1 += val;
else if(h2)   *h2 += val;
else cout<<"PAWExecutor::h_cadd Error: "<<tokens[0]<<" not an Histo/Histo2D"<<endl;
}

/* methode */
void PAWExecutor::h_cmult(vector<string>& tokens)
// Multiplie un histogramme par une constante
{
if(tokens.size()<2)
  {cout<<"Usage: h/cmult nameh1d val"<<endl; return;}
NamedObjMgr omg;
AnyDataObj* mobj = omg.GetObj(tokens[0]);
if(mobj==NULL)
  {cout<<"PAWExecutor::h_cmult Error: unknow object"<<tokens[0]<<endl;
  return;}
double val = atof(tokens[1].c_str());
Histo*   h1 = dynamic_cast<Histo*>(mobj);
HProf*   hp = dynamic_cast<HProf*>(mobj);
Histo2D* h2 = dynamic_cast<Histo2D*>(mobj);
if(h1 && !hp) *h1 *= val;
else if(h2)   *h2 *= val;
else cout<<"PAWExecutor::h_cmult Error: "<<tokens[0]
         <<" not an Histo/Histo2D"<<endl;
}

/* methode */
void PAWExecutor::h_oper(vector<string>& tokens)
// Equivalent h/oper/add sub,mul,div de paw
// Operation entre 2 histogrammes
// h/oper @ h1 h2 hres
// hres = h1 @ h2    with @ = (+,-,*,/)
{
if(tokens.size()<4)
  {cout<<"Usage: n/oper @ h1 h2 hres with @=(+,-,*,/)"<<endl;
   return;}

// Decode arguments
const char * oper = tokens[0].c_str();
if( oper[0]!='+' && oper[0]!='-' && oper[0]!='*' && oper[0]!='/' )
  {cout<<"PAWExecutor::h_oper Error: unknow operation "<<oper<<endl;
  return;}
string h1name = tokens[1];
string h2name = tokens[2];
string h3name = tokens[3];

// Get objects
NamedObjMgr omg;
AnyDataObj* mobjh1 = omg.GetObj(h1name);
AnyDataObj* mobjh2 = omg.GetObj(h2name);
if( mobjh1==NULL || mobjh2==NULL )
  {cout<<"PAWExecutor::h_oper Error: unknow object(s) "<<h1name<<" or "<<h2name<<endl;
  return;}
AnyDataObj* mobjh3 = omg.GetObj(h3name);

// Operations on HProf, only + is working
if( dynamic_cast<HProf*>(mobjh1) != NULL ) {
  if( oper[0]!='+' )
    { cout<<"PAWExecutor::h_oper Error: operation "<<oper
          <<" not implemented for HProf"<<endl; return;}
  if( dynamic_cast<HProf*>(mobjh2) == NULL )
    {cout<<"PAWExecutor::h_oper Error: type mismatch between h1 and h2\n"
         <<typeid(*mobjh1).name()<<" , "<<typeid(*mobjh2).name()<<endl;
    return;}
  HProf* h1 =(HProf*) mobjh1;
  HProf* h2 =(HProf*) mobjh2;
  if( h1->NBins() != h2->NBins() )
    {cout<<"PAWExecutor::h_oper Error: size mismatch between h1, h2 "
         <<h1->NBins()<<" "<<h2->NBins()<<endl; return;}
  HProf* h3 = NULL;
  if( mobjh3 == NULL ) {  // l'objet n'existe pas, on le cree
    h3 = new HProf(*h1); h3->Zero(); omg.AddObj(h3,h3name);
  } else {                // l'objet existe
    h3 = dynamic_cast<HProf*>(mobjh3);
    if(h3 == NULL)  // ce n'est pas un HProf
      {cout<<"PAWExecutor::h_oper Error: type mismatch between h1 and h3\n"
           <<typeid(*mobjh1).name()<<" , "<<typeid(*mobjh3).name()<<endl;
      return;}
    if(h1->NBins() != h3->NBins())
      {cout<<"PAWExecutor::h_oper Error: size mismatch between h1, h3 "
           <<h1->NBins()<<" "<<h3->NBins()<<endl; return;}
    *h3 = *h1 + *h2;
    h3->UpdateHisto();
  }

// Operations on Histo
} else if( dynamic_cast<Histo*>(mobjh1) != NULL ) {
  if( dynamic_cast<Histo*>(mobjh2) == NULL )
    {cout<<"PAWExecutor::h_oper Error: type mismatch between h1 and h2\n"
         <<typeid(*mobjh1).name()<<" , "<<typeid(*mobjh2).name()<<endl;
    return;}
  Histo* h1 =(Histo*) mobjh1;
  Histo* h2 =(Histo*) mobjh2;
  if( h1->NBins() != h2->NBins() )
    {cout<<"PAWExecutor::h_oper Error: size mismatch between h1, h2 "
         <<h1->NBins()<<" "<<h2->NBins()<<endl; return;}
  Histo* h3 = NULL;
  if( mobjh3 == NULL ) {  // l'objet n'existe pas, on le cree
    h3 = new Histo(*h1); h3->Zero(); omg.AddObj(h3,h3name);
  } else {                // l'objet existe
    h3 = dynamic_cast<Histo*>(mobjh3);
    if(h3 == NULL)  // ce n'est pas un Histo
      {cout<<"PAWExecutor::h_oper Error: type mismatch between h1 and h3\n"
           <<typeid(*mobjh1).name()<<" , "<<typeid(*mobjh3).name()<<endl;
      return;}
    if(h1->NBins() != h3->NBins())
      {cout<<"PAWExecutor::h_oper Error: size mismatch between h1, h3 "
           <<h1->NBins()<<" "<<h3->NBins()<<endl; return;}
    if( oper[0]=='+')      *h3 = *h1 + *h2;
    else if( oper[0]=='-') *h3 = *h1 - *h2;
    else if( oper[0]=='*') *h3 = *h1 * *h2;
    else if( oper[0]=='/') *h3 = *h1 / *h2;
  }

// Operations on Histo2D
} else if( dynamic_cast<Histo2D*>(mobjh1) != NULL ) {
  if( dynamic_cast<Histo2D*>(mobjh2) == NULL )
    {cout<<"PAWExecutor::h_oper Error: type mismatch between h1 and h2\n"
         <<typeid(*mobjh1).name()<<" , "<<typeid(*mobjh2).name()<<endl;
    return;}
  Histo2D* h1 =(Histo2D*) mobjh1;
  Histo2D* h2 =(Histo2D*) mobjh2;
  if( h1->NBinX() != h2->NBinX() || h1->NBinY() != h2->NBinY() )
    {cout<<"PAWExecutor::h_oper Error: size mismatch between h1, h2 "
         <<h1->NBinX()<<","<<h1->NBinY()<<"   "
         <<h2->NBinX()<<","<<h2->NBinY()<<endl; return;}
  Histo2D* h3 = NULL;
  if( mobjh3 == NULL ) {  // l'objet n'existe pas, on le cree
    h3 = new Histo2D(*h1); h3->Zero(); omg.AddObj(h3,h3name);
  } else {                // l'objet existe
    h3 = dynamic_cast<Histo2D*>(mobjh3);
    if(h3 == NULL)  // ce n'est pas un Histo2D
      {cout<<"PAWExecutor::h_oper Error: type mismatch between h1 and h3\n"
           <<typeid(*mobjh1).name()<<" , "<<typeid(*mobjh3).name()<<endl;
      return;}
    if( h1->NBinX() != h3->NBinX() || h1->NBinY() != h3->NBinY() )
      {cout<<"PAWExecutor::h_oper Error: size mismatch between h1, h3 "
           <<h1->NBinX()<<","<<h1->NBinY()<<"   "
           <<h3->NBinX()<<","<<h3->NBinY()<<endl; return;}
    if( oper[0]=='+')      *h3 = *h1 + *h2;
    else if( oper[0]=='-') *h3 = *h1 - *h2;
    else if( oper[0]=='*') *h3 = *h1 * *h2;
    else if( oper[0]=='/') *h3 = *h1 / *h2;
  }

// Doesn't work for other objects
} else {
  cout<<"PAWExecutor::h_oper Error: not implemented for "
      <<typeid(*mobjh1).name()<<endl;
  return;
}

return;
}

/* methode */
void PAWExecutor::h_plot_2d(vector<string>& tokens)
// plot for 2D histogramme: plot histo, bandx/y, slicex/y or projx/y
{
if(tokens.size()<1)
  {cout<<"Usage: h/plot/2d nameh2d to_plot [n/s] [dopt]"<<endl; return;}
string proj = "h"; if(tokens.size()>1) proj = tokens[1];
NamedObjMgr omg;
AnyDataObj* mobj = omg.GetObj(tokens[0]);
if(mobj==NULL)
  {cout<<"PAWExecutor::h_plot_2d Error: unknow object"<<tokens[0]<<endl;
  return;}
Histo2D* h2 = dynamic_cast<Histo2D*>(mobj);
if(!h2)
  {cout<<"PAWExecutor::h_plot_2d Error: "<<tokens[0]<<" not an Histo2D"<<endl;
  return;}

Histo* h1p = NULL; string nametoplot = "/autoc/h_plot_2d_h1";
//AnyDataObj* mobjh1 = omg.GetObj(nametoplot);

string dopt = ""; if(tokens.size()>=3) dopt = tokens[2];
if(proj == "show") {
  h2->ShowProj();
  h2->ShowBand(2);
  h2->ShowSli(2);
  return;
} else if(proj == "h") {
  nametoplot = tokens[0];
} else if(proj == "px") {  
  if((h1p=h2->HProjX())) {Histo* h1=new Histo(*h1p); omg.AddObj(h1,nametoplot);}
    else {h2->ShowProj(); return;}
} else if(proj == "py") {
  if((h1p=h2->HProjY())) {Histo* h1=new Histo(*h1p); omg.AddObj(h1,nametoplot);}
    else {h2->ShowProj(); return;}
} else {
  if(tokens.size()<3)
    {cout<<"Usage: h/plot/2d nameh2d bx/by/sx/sy n [dopt]"<<endl; return;}
  int n = atoi(tokens[2].c_str());
  dopt = ""; if(tokens.size()>=4) dopt = tokens[3];
  if(proj == "bx") {
    if((h1p=h2->HBandX(n))) {Histo* h1=new Histo(*h1p); omg.AddObj(h1,nametoplot);}
    else {h2->ShowBand(); return;}
  } else if(proj == "by") {
    if((h1p=h2->HBandY(n))) {Histo* h1=new Histo(*h1p); omg.AddObj(h1,nametoplot);}
    else {h2->ShowBand(); return;}
  } else if(proj == "sx") {
    if((h1p=h2->HSliX(n))) {Histo* h1=new Histo(*h1p); omg.AddObj(h1,nametoplot);}
    else {h2->ShowSli(); return;}
  } else if(proj == "sy") {
    if((h1p=h2->HSliY(n))) {Histo* h1=new Histo(*h1p); omg.AddObj(h1,nametoplot);}
    else {h2->ShowSli(); return;}
  }
}

omg.DisplayObj(nametoplot,dopt);
}

/* methode */
int PAWExecutor::decodepawstring(string tokens,string& nameobj
                                ,string& xexp,string& yexp,string& zexp)
// Decodage general de "nameobj.xexp"
//                     "nameobj.yexp%xexp"
//                     "nameobj.zexp%yexp%xexp"
// Return: nombre de variables trouvees, -1 si probleme
{
nameobj = ""; xexp= ""; yexp= ""; zexp= "";

int lt = (int) tokens.length();
if(lt<=0) return -1;

// decodage de la chaine de type PAW.
char *str = new char[lt+2];
strcpy(str,tokens.c_str()); strip(str,'B',' '); lt = strlen(str);
//cout<<"chaine1["<<lt<<"] :"<<str<<":"<<endl;
char *c[3] = {NULL,NULL,NULL};
int i, np=0; bool namefound = false;
for(i=0;i<lt;i++) {
  if(!namefound && str[i]=='.') {
    str[i]='\0';
    namefound=true;
    c[np] = str+i+1; np++;
  }
  if( namefound && str[i]=='%') {
    str[i]='\0';
    if(np<3) {c[np] = str+i+1; np++;}
  }
}
//cout<<"chaine2 :"; for(i=0;i<lt;i++) cout<<str[i]; cout<<":"<<endl;

// Remplissage du nom et des variables
nameobj = str;
if(np==1)  xexp=c[0];
if(np==2) {yexp=c[0]; xexp=c[1];}
if(np==3) {zexp=c[0]; yexp=c[1]; xexp=c[2];}
//cout<<"pawstring str,c[0-2] "<<str<<" "<<c[0]<<" "<<c[1]<<" "<<c[2]<<endl;
delete [] str;

// Comptage des variables
np = -1;
if(nameobj.length()>0) 
  {np = 0; if(xexp.length()>0)
             {np++; if(yexp.length()>0)
                      {np++; if(zexp.length()>0) np++;}}}
cout<<"pawstring["<<np<<"] name="<<nameobj
    <<" xexp="<<xexp<<" yexp="<<yexp<<" zexp="<<zexp<<endl;
return np;
}

/* methode */
void PAWExecutor::h_put_vec(vector<string>& tokens)
// Pour remplir un histo avec le contenu d'un vecteur ou d'une matrice
// L'histogramme doit deja exister. Le nombre de bins remplit
// depend des tailles respectives des 2 objets.
// tokens[2] = "cont" : on remplit les valeurs de l'histogramme (ou "!")
//           = "err2" : on remplit les erreurs de l'histogramme
{
if(tokens.size()<2)
  {cout<<"Usage: h/put_vec  namehisto namevector"<<endl;
   return;}
string toput = "cont"; if(tokens.size()>2) toput = tokens[2];
if(toput=="!") toput = "cont";
if(toput!="cont" && toput!="err2")
  {cout<<"PAWExecutor::h_put_vec Error: unknow filling "<<toput<<endl;
   return;}
string hname = tokens[0];
string vname = tokens[1];

// Get objects
NamedObjMgr omg;
AnyDataObj* mobjh = omg.GetObj(hname);
AnyDataObj* mobjv = omg.GetObj(vname);
if( mobjh==NULL || mobjv==NULL )
  {cout<<"PAWExecutor::h_put_vec Error: unknow object(s) "<<hname<<" or "<<vname<<endl;
  return;}

// Fill histo from vector
if(typeid(*mobjh) == typeid(Histo) && typeid(*mobjv) == typeid(Vector)) {
  Histo*  h = dynamic_cast<Histo*>(mobjh);
  Vector* v = dynamic_cast<Vector*>(mobjv);
  if(toput=="cont")      h->PutValue(*v);
  else if(toput=="err2") h->PutError2(*v);

} else if(typeid(*mobjh) == typeid(Histo2D) && typeid(*mobjv) == typeid(Matrix)) {
  Histo2D* h = dynamic_cast<Histo2D*>(mobjh);
  Matrix*  v = dynamic_cast<Matrix*>(mobjv);
  if(toput=="cont")      h->PutValue(*v);
  else if(toput=="err2") h->PutError2(*v);

} else {
  cout<<"PAWExecutor::h_put_vec Error: type mismatch between histogram and vector/matrix\n"
      <<typeid(*mobjh).name()<<" , "<<typeid(*mobjv).name()<<endl;
  return;
}

}

/* methode */
void PAWExecutor::h_get_vec(vector<string>& tokens)
// Pour copier un histo dans un vecteur ou une matrice
// Si le vecteur (matrice) n'existe pas, il est cree.
// Le vecteur ou la matrice est re-dimensionne correctement.
// tokens[2] = "cont" : on copie les valeurs de l'histogramme (ou "!")
//           = "err2" : on copie les erreurs de l'histogramme
//           = "absc" : on copie les erreurs de l'histogramme (1D only)
// tokens[3[,4]] = show : show available projections for Histo2D
//                 px   : get X projection
//                 py   : get Y projection
//                 bx n : get X band number n
//                 by n : get Y band number n
//                 sx n : get X slice number n
//                 sy n : get Y slice number n
{
if(tokens.size()<2)
  {cout<<"Usage: h/get_vec namehisto namevector"<<endl;
   return;}
string toget = "cont"; if(tokens.size()>2) toget = tokens[2];
if(toget=="!") toget = "cont";
if(toget!="cont" && toget!="err2" && toget!="absc")
  {cout<<"PAWExecutor::h_get_vec Error: unknow filling "<<toget<<endl;
   return;}
string proj = "h";  if(tokens.size()>3) proj = tokens[3];
int nproj = -1;     if(tokens.size()>4) nproj = atoi(tokens[4].c_str());
string hname = tokens[0];
string vname = tokens[1];

// Get objects
NamedObjMgr omg;
AnyDataObj* mobjh = omg.GetObj(hname);
AnyDataObj* mobjv = omg.GetObj(vname);
if( mobjh==NULL)
  {cout<<"PAWExecutor::h_put_vec Error: unknow object(s) "<<hname<<endl;
  return;}

// Fill histo from vector
Histo*   h  = dynamic_cast<Histo*>(mobjh);
Histo2D* h2 = dynamic_cast<Histo2D*>(mobjh);
if( h != NULL ) {  // Histo ou HProf
  HProf* hp  = dynamic_cast<HProf*>(mobjh);
  if(hp!=NULL) if(!(hp->IsOk())) hp->UpdateHisto();
  Vector* v = NULL;
  if(mobjv==NULL)   // le vecteur n'existe pas
    {v = new Vector(1); omg.AddObj(v,vname);}
  AnyDataObj* mobjv = omg.GetObj(vname);
  if(typeid(*mobjv) != typeid(Vector))
    {cout<<"PAWExecutor::h_get_vec Error: type mismatch between Histo/HProf and vector\n"
         <<typeid(*mobjv).name()<<endl; return;}
  v = dynamic_cast<Vector*>(mobjv);
  if(toget=="cont")      h->GetValue(*v);
  else if(toget=="err2") h->GetError2(*v);
  else if(toget=="absc") h->GetAbsc(*v);

} else if( h2 != NULL) {  // Histo2D

  if(proj == "h") {   // On veut les valeurs de l'histogramme 2D
    Matrix*  v = NULL;
    if(mobjv==NULL)   // la matrice n'existe pas
      {v = new Matrix(1,1); omg.AddObj(v,vname);}
    AnyDataObj* mobjv = omg.GetObj(vname);
    if(typeid(*mobjv) != typeid(Matrix))
      {cout<<"PAWExecutor::h_get_vec Error: type mismatch between Histo2D and matrix\n"
           <<typeid(*mobjv).name()<<endl; return;}
    v = dynamic_cast<Matrix*>(mobjv);
    if(toget=="cont")      h2->GetValue(*v);
    else if(toget=="err2") h2->GetError2(*v);
    else
      {cout<<"PAWExecutor::h_get_vec Error: option "<<toget<<" not valid for Histo2D"<<endl;
      return;}

  } else {   // On veut les valeurs d'une projection de l'histo 2D
    h = NULL;
    if(proj == "show") {h2->ShowProj(); h2->ShowBand(2); h2->ShowSli(2);}
    else if(proj == "px") h = h2->HProjX();
    else if(proj == "py") h = h2->HProjY();
    else if(proj == "bx") h = h2->HBandX(nproj);
    else if(proj == "by") h = h2->HBandY(nproj);
    else if(proj == "sx") h = h2->HSliX(nproj);
    else if(proj == "sy") h = h2->HSliY(nproj);
    if(h==NULL)
      {cout<<"PAWExecutor::h_get_vec Error: unknown projection "<<proj
           <<" number "<<nproj<<endl; return;}
    Vector* v = NULL;
    if(mobjv==NULL)   // le vecteur n'existe pas
      {v = new Vector(1); omg.AddObj(v,vname);}
    AnyDataObj* mobjv = omg.GetObj(vname);
    if(typeid(*mobjv) != typeid(Vector))
      {cout<<"PAWExecutor::h_get_vec Error: type mismatch between Histo2D "<<proj
       <<" and vector\n"<<typeid(*mobjv).name()<<endl; return;}
    v = dynamic_cast<Vector*>(mobjv);
    if(toget=="cont")      h->GetValue(*v);
    else if(toget=="err2") h->GetError2(*v);
    else if(toget=="absc") h->GetAbsc(*v);
  }

} else {
  cout<<"PAWExecutor::h_get_vec Error: type mismatch for histogram\n"
      <<typeid(*mobjh).name()<<endl;
  return;
}

}
