// Classe d'initialisation du module NTools

#include "machdefs.h"
#include "ntoolsinit.h"

#include "poly.h"
#include "generaldata.h"
#include "cimage.h"

#include "tabmath.h"
#include "dates.h"
#include "datime.h"

/*!
   \defgroup NTools NTools module
   This module contains various tools for Sophya.
*/

int NToolsInitiator::FgInit = 0;

/*!
  \class SOPHYA::NToolsInitiator
  \ingroup NTools
  Tools initiator
*/
NToolsInitiator::NToolsInitiator()
  : TArrayInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules Outils++
  
  //  PPRegister(OMatrix);
  //  PPRegister(OVector);

  PPRegister(ObjFileIO<Poly>);
  PPRegister(ObjFileIO<Poly2>);

  PPRegister(ObjFileIO<GeneralFitData>);
  DObjRegister(ObjFileIO<GeneralFitData>, GeneralFitData);

  PPRegister(RzImage);
  PPRegister(ImageU2);
  PPRegister(ImageI2);
  PPRegister(ImageI4);
  PPRegister(ImageR4);



//  TSidSetupLaSilla();    Old-Eros

  gTimeZone = new TimeZone;

  ptabFExp = new TabFExp;

}

NToolsInitiator::~NToolsInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static NToolsInitiator ntoolsinit;

