#include <stdio.h>
#include <string.h>

#include "ex_dessin.h"



/* --Methode-- */
ExBWdg::ExBWdg(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: PIBaseWdg(par, nom, sx, sy, px, py)

{
mmrk = mfnt = nc = 0;
strcpy(str, "Bonjour");
for(int i=strlen(str); i<20; i++) str[i] = ' ';
str[20] = '\0';

ActivateKeyboard();
ActivateButton(1);
ActivateButton(2);
ActivateButton(3);
}


/* --Methode-- */
ExBWdg::~ExBWdg()
{
}

 


/* --Methode-- */
void ExBWdg::Resize()
{

}


/* --Methode-- */
void ExBWdg::Draw(PIGraphicGen* g)
{
EraseWindow();
g->SelLine(PI_NormalLine);
g->DrawBox(10,10, XSize()-20, YSize()-20);

g->SelLine(PI_ThinLine);
g->DrawFBox(20, 20, 20, 20);
g->DrawCircle(30, 30, 15);

g->SelForeground(PI_Red);
g->DrawFCircle(70, 30, 15);

g->SelForeground(PI_Yellow);
g->DrawFBox(10, 60, 100, 15);

g->SelForeground(PI_Black);
g->DrawString(20, 90, str);

g->SelLine(PI_ThinLine);
g->DrawLine(10, 120, 40, 120);
g->SelLine(PI_NormalLine);
g->DrawLine(40, 120, 70, 120);
g->SelLine(PI_ThickLine);
g->DrawLine(70, 120, 100, 120);

g->SelForeground(PI_Magenta);
g->DrawFCircle(120, 30, 15);
g->SelForeground(PI_Grey);
g->DrawFCircle(120, 60, 15);

PIGrCoord x[5] = { 20, 35, 50, 65, 80 };
PIGrCoord y[5] = { 130, 130, 130, 130, 130 };

g->SelForeground(PI_Black);
g->DrawMarkers(x, y, 5);
return;
}




/* --Methode-- */
void ExBWdg::But1Press(int x, int y)
{
SelPointerShape(PI_CrossPointer);
return;
}

/* --Methode-- */
void ExBWdg::But1Release(int x, int y)
{
SelPointerShape(PI_ArrowPointer);
return;
}

/* --Methode-- */
void ExBWdg::But2Press(int x, int y)
{
PIFontAtt att[3] = { PI_RomanFont, PI_BoldFont, PI_ItalicFont};
PIMarker  pmk[9] = { PI_DotMarker , PI_PlusMarker, PI_CrossMarker,  
                 PI_CircleMarker, PI_FCircleMarker,
                 PI_BoxMarker, PI_FBoxMarker,
                 PI_TriangleMarker, PI_FTriangleMarker };

if (++mfnt > 2)  mfnt = 0;
if (++mmrk > 8)  mmrk = 0; 
mWGrC->SelFont(PI_NormalSizeFont, att[mfnt]);
mWGrC->SelMarker(8, pmk[mmrk]);
return;
}

/* --Methode-- */
void ExBWdg::But2Release(int x, int y)
{
Refresh();
return;
}

/* --Methode-- */
void ExBWdg::But3Press(int x, int y)
{
SelPointerShape(PI_HandPointer);
mWGrC->SelForeground(PI_Blue);
mWGrC->DrawFBox(0, 0, 8, 8);
return;
}

/* --Methode-- */
void ExBWdg::But3Release(int x, int y)
{
mWGrC->SelForeground(PI_White);
mWGrC->DrawFBox(0, 0, 8, 8);
mWGrC->SelForeground(PI_Black);
SelPointerShape(PI_ArrowPointer);
return;
}



/* --Methode-- */
void ExBWdg::Keyboard(int key, PIKeyModifier kmod)
{
char buf[4];
str[nc] = key;
if (++nc > 15)  nc = 0;
buf[0] = key;  buf[1] = '\0';

printf("ExBWdg::Keyboard: Key= %d (%c) , Mod= %d \n", key, (char)key, (int)kmod);
mWGrC->SelFont(PI_BigSizeFont, PI_BoldFont);
mWGrC->DrawString(20, 75, buf);

if ( (kmod == PIKM_Alt) && (key == 'c') ) {
  printf("ExBWdg::Keyboard: Test-Copy ... \n"); 
  ClaimSelection();
}
if ( (kmod == PIKM_Alt) && (key == 'v') ) {
  printf("ExBWdg::Keyboard: Test-Paste ... \n"); 
  RequestSelection();
}

return;
}


