#ifndef PICMAPMAC_H_SEEN
#define PICMAPMAC_H_SEEN

#include "picmapgen.h"
#include <Palettes.h>


class PIColorMapMac : public PIColorMapGen {
public:
  PIColorMapMac();
  PIColorMapMac(int id, int nc, string const& nom);  
  ~PIColorMapMac();
  
  virtual PIColor GetColor(int n);
  virtual bool AllocColor(PIColor const& col, int index);   // $CHECK$  Reza 01/12/97(Modif)
  virtual void FreeColors();

  virtual long  TotNbColors();
  virtual int   NbAllocColors();
  
  CTabHandle    GetCTab() {return mCTab;}
protected:
  void CopyFrom(PIColorMapGen*);
  
  CTabHandle    mCTab;
  PaletteHandle mPalette;

  friend class PIColorMapGen;
  friend class PIPixmapMac;
};

typedef PIColorMapMac PIColorMapNative;

#endif
