#ifndef PISTLIST_H
#define PISTLIST_H

#include "stlist.h"
#include "pidrawer.h"

class PIStarList : public PIDrawer {
public:
                     PIStarList(StarList* stl, bool ad, int ayud=kAxeDirUpDown);
  virtual           ~PIStarList();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  virtual void       UpdateSize();
  
  void               SetFluxLimits(float min=1., float max=-1., int nl=5, 
                                   int msz0=0, bool refr=false);
  void               SetXYLimits(float xmin=1., float xmax=-1., float ymin=1., float ymax=-1., 
                                 bool dfv=false, bool refr=false);              

  inline StarList*   StList()  { return(mStL); }  
  inline float       XMin()    { return(mXMin); }       
  inline float       XMax()    { return(mXMax); }       
  inline float       YMin()    { return(mYMin); }       
  inline float       YMax()    { return(mYMax); }       
  inline float       FluxMin() { return(mFmin); }       
  inline float       FluxMax() { return(mFmax); }
       
protected:
  StarList* mStL;
  bool mAdDO;
  float mFmin, mFmax;
  int mNLev, mMSz0;
  double mF0, mDLgF;
  float mXMin, mXMax;
  float mYMin, mYMax;
  bool mDspFV;
  int  mAYdir;

};

#endif
