#include <stdio.h>
#include "pihisto.h"

PIHisto::PIHisto(Histo* histo, bool ad)
: PIDrawer(), mHisto(histo)
{
  mAdDO = ad;     // Flag pour suppression automatique de mHisto
}

PIHisto::~PIHisto()
{
  if (mAdDO)
    delete mHisto;
}



void
PIHisto::UpdateSize()
{
  if (!mHisto)  return;  
  SetLimits(mHisto->XMin(), mHisto->XMax(), mHisto->VMin(), mHisto->VMax()*1.2);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


void
PIHisto::Draw(PIGraphicUC* g, float /*xmin*/, float /*ymin*/, float /*xmax*/, float /*ymax*/)
{
  if (!mHisto)  return;  
  for (int i=0; i<mHisto->NBins(); i++) {
		float left   = mHisto->BinLowEdge(i);
		float width  = mHisto->BinWidth();
		float bottom = 0;
		float height = (*mHisto)(i);
		g->DrawFBox(left,bottom,width,height);
		g->DrawLine(left, bottom, left, bottom + height); // Au moins une ligne...
	}
  DrawStats(g);
}

void
PIHisto::DrawStats(PIGraphicUC* g)
{
  if (!mHisto) return;
  float cellHeight = (YMax() - YMin()) * 0.05;
  float cellWidth  = (XMax() - XMin()) * 0.23;
  g->DrawLine(XMax() - cellWidth, YMax(),
                       XMax() - cellWidth, YMax() - cellHeight);
  g->DrawLine(XMax() - cellWidth, YMax() - cellHeight,
                       XMax()            , YMax() - cellHeight);
  char label[50];
  sprintf(label, "N = %.6g", mHisto->NData());
  g->SelFontSz((YMax() - YMin())/30);
  g->DrawString(XMax() - cellWidth*0.9, YMax() - cellHeight*0.8, label);
                       
}
