#include "pippwindowmac.h"


// ---------------------------------------------------------------------------
//		 PIPPWindowMac
// ---------------------------------------------------------------------------
//	Default Constructor

PIPPWindowMac::PIPPWindowMac()
{
  myPIWindow = NULL;
}


// ---------------------------------------------------------------------------
//		 PIPPWindowMac(SWindowInfo&)
// ---------------------------------------------------------------------------
//	Construct Window from the data in a struct

PIPPWindowMac::PIPPWindowMac(
	const SWindowInfo	&inWindowInfo)
:LWindow(inWindowInfo)
{
  myPIWindow = NULL;
}


// ---------------------------------------------------------------------------
//		 PIPPWindowMac(ResIDT, Uint32, LCommander*)
// ---------------------------------------------------------------------------
//	Construct a Window from a WIND Resource with the specified attributes
//	and SuperCommander

PIPPWindowMac::PIPPWindowMac(
	ResIDT		inWINDid,
	Uint32		inAttributes,
	LCommander	*inSuperCommander)
:LWindow(inWINDid, inAttributes, inSuperCommander)
{
  myPIWindow = NULL;
}


// ---------------------------------------------------------------------------
//		 PIPPWindowMac
// ---------------------------------------------------------------------------
//	Construct a Window from input parameters

PIPPWindowMac::PIPPWindowMac(
	LCommander		*inSuperCommander,
	const Rect		&inGlobalBounds,
	ConstStringPtr	inTitle,
	Int16			inProcID,
	Uint32			inAttributes,
	WindowPtr		inBehind,
	void			*inStorage)
:LWindow(inSuperCommander, inGlobalBounds, inTitle,
inProcID, inAttributes, inBehind, inStorage)
{
  myPIWindow = NULL;
}


// ---------------------------------------------------------------------------
//		 PIPPWindowMac(LStream*)
// ---------------------------------------------------------------------------
//	Construct Window from the data in a stream

PIPPWindowMac::PIPPWindowMac(
	LStream	*inStream)
:LWindow(inStream)
{
  myPIWindow = NULL;
}


// ---------------------------------------------------------------------------
//		 ~PIPPWindowMac
// ---------------------------------------------------------------------------
//	Destructor

PIPPWindowMac::~PIPPWindowMac()
{
}

void
PIPPWindowMac::AttemptClose()
{
  myPIWindow->Process(myPIWindow->BuildMsg(myPIWindow->Msg(),PIMsg_Close), myPIWindow, NULL) ;
}


const MessageT	msg_Resize			= 817;
const MessageT	msg_Move			= 818;

void PIPPWindowMac::DoSetPosition(Point inPosition)
{
    ExecuteAttachments(msg_Move, NULL);
    LWindow::DoSetPosition(inPosition);
}

void PIPPWindowMac::DoSetBounds(const Rect &inBounds)
{
    ExecuteAttachments(msg_Resize, NULL);
    LWindow::DoSetBounds(inBounds);
}

