#ifndef PIWDG_MAC_SEEN
#define PIWDG_MAC_SEEN

#include "piwdggen.h"
#include "pippviewadapter.h"
#include <LPane.h>
#include <LListener.h>

class PIWdgMac : public PIWdgGen, public LListener {
public:
  
                         PIWdgMac(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual                ~PIWdgMac();
  virtual void			 FinishCreate(); // apres avoir installe les sous-vues
                                       
  virtual void	         ListenToMessage(MessageT inMessage, void *ioParam);
  virtual void           SetLabel(string const&);

  virtual void           SetSize(int sx, int sy);
  virtual void           SetPos(int px, int py);
  virtual void           SetBorderWidth(int /*bw*/) {}
  virtual void           SetBinding(PIBindingKind left, PIBindingKind top, 
                                    PIBindingKind right, PIBindingKind bottom);
  virtual int            XSize();
  virtual int            YSize();
  virtual int            XPos();
  virtual int            YPos();
  virtual string         Nom()  { return mNom; }

  virtual void           Manage();
  virtual void           UnManage();
  virtual bool           IfManaged();
  virtual bool           IsVisible();
  
//  Gestion de copier-coller
// $$CHECK$$ Pourquoi les noms ont-ils change ???
// En plus, pour des trucs tout aussi obscurs...
// Et c'est quoi, typ, qui en plus n'est pas utilise sous X ???
  virtual bool           ClaimSelection(unsigned int typ=PICP_string);
  virtual void           SelectionLost();
  virtual unsigned int   RequestSelection(unsigned int typ=PICP_string);
  virtual void*          ProvideSelection(unsigned int& typ, unsigned int& len);
  virtual void           PasteSelection(unsigned int typ, void *, unsigned int l);
  virtual void           CopyFromSelection(char *, int l);
  virtual char*          SelectionString(int& len);
  virtual void           SelectionTransferEnd();

protected:
  LPane*				 mPane;
  PIPPViewAdapter*       mAdapter;
  SPaneInfo				 mAdapterPaneInfo;
  SViewInfo				 mAdapterViewInfo;
  SPaneInfo				 mPaneInfo;
  SViewInfo				 mViewInfo;
  string                 mNom;
  
  friend class PIGraphicMac;
};

typedef PIWdgMac PIWdg;


#endif
