#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream.h>

#include "histinit.h"
#include "dvlist.h"
#include "ntuple.h"
#include "xntuple.h"

void test_dvl();
void test_ntuple();
void test_xntuple() ; 
void test_Xntuple() ; 

int main(int narg, char *arg[])
{
  SophyaInit();
  if (narg < 2) {
    cout << " tnt/Erreur arg - Usage: tnt d/n/x/X \n" 
	 << " d:DVList n:NTuple x/X:XNTuple test \n" << endl;
    exit(0);
  }

  try {
    if (*arg[1] == 'd')  test_dvl();
    else if (*arg[1] == 'n')  test_ntuple();
    else if (*arg[1] == 'x')  test_xntuple();
    else if (*arg[1] == 'X')  test_Xntuple();
  }
  catch(PThrowable exc ) {
    cerr << "tnt-main() , Catched exception: \n" << exc.Msg() << endl;
  }
  catch(std::exception ex) {
    cerr << "tnt-main() , Catched exception ! " << (string)(ex.what()) << endl;
  }
  catch(...) {
    cerr << "tnt-main() , Catched ... ! " << endl;
  }
}

/*  ***** Test de NTuple simple ***** */
void test_ntuple()
{
  char * names[3] = {"XPos", "YPos", "Val"};
  int i,j, k;
  float xnt[3];

  cout << "======= test_ntuple:  Testing NTuple ======= " << endl;

 cout << "Creation Ntuple avec X,Y,Val ... " << endl;
 NTuple  nt1(3, names, 20);

 k = 0;
 for(j=0; j<8; j++)
   for(i=0; i<12; i++)
     { xnt[0] = i+0.5;  xnt[1] = j+0.5;  xnt[2] = k;
     nt1.Fill(xnt); k++; }

 nt1.Show(cout);
 nt1.Print(0, 5);
 nt1.Print(18, 5);
 nt1.Print(94, 5);

 string fn = "nt.ppf";
 {
  cout << "Ecriture NTuple ds nt.ppf ... \n" << endl;
  ObjFileIO<NTuple> fio(&nt1);
  fio.Write(fn);
 }

 {
   cout << "Lecture NTuple (nt2) ds nt.ppf ... \n" << endl;

   ObjFileIO<NTuple> fio(fn);
   NTuple* nt2 = (NTuple*)fio.DataObj();
   nt2->Show(cout);
   nt2->Print(0, 5);
   nt2->Print(18, 5);
   nt2->Print(94, 5);
 }


}

/*  ***** Test de dvlist ***** */
void test_dvl()
{
DVList dvl;

cout << "\n ======= test_dvl:  Testing DVList ======= " << endl;
dvl.SetI("Var XXX", 12345);
dvl.SetI("IV1-80", 80);
dvl.SetI("IV2-330", 330);

dvl.SetD("DV1-0.2", 0.2);
dvl.SetD("DV2-4.5", 4.5);
dvl.SetZ("ZV", complex<r_8>(2.0,-1.44));

dvl.SetI("IVV3-783", 783);
dvl("IVV3-783-O") =  7783;
// dvl["Avec[]"] =  "operateur [] !";
dvl.SetD("DVV3", 3.141592652141592652);
dvl.SetComment("DVV3", "Comment for DVV3, r_8 type variable");
dvl("DVV3avec()") =  44.555e-8; 

dvl.SetS("Blanc_White", "123.456Ma premiere chaine");
dvl.SetI("IntegerValue", 55777);
dvl.SetComment("IntegerValue", "This variable has a comment");
dvl.Comment() = "This is a test DVL produced by the program tdvl.cc \n Using SOPHYA , Feb 2000";
dvl.Print();

double d = dvl("DV2-4.5");
float f = dvl("DVV3");
int i = dvl("IVV3-783");
complex<r_8> z = dvl("ZV");

printf("\n \n Essai1 (IVV3 DVV3 DV2= ) %d  %.20g  %g \n", i, f, (float)d);
printf("\n \n Essai ZV= (%.2g  %g I) \n", z.real(), z.imag());
cout << "Test Comment/IntegerValue: " << dvl.GetComment("IntegerValue") << endl;
cout << "Test Comment/DVV3: " << dvl.GetComment("DVV3") << endl;

cout << "Test string recup  " << (string)(dvl["Blanc_White"]) << endl;
cout << "Test string recup(int=80)  " << (string)(dvl["IV1-80"]) << endl;
dvl("DVV3") = (double)3.141592652141592652;
cout << "Test string recup(double=Pi..i)  " << (string)(dvl["DVV3"]) << endl;

 {
   cout << " Writing DVList in file PPF dvl.ppf " << endl;
   POutPersist os("dvl.ppf");
   os << dvl ;
 }

 cout << "-------------------------- \n\n" 
      << " reading DVList from file dvl.ppf ... \n" << endl;

 DVList dvlr("dvl.ppf");
 double df1 = (double)( dvlr["DVV3"] );
 double df2 = (double)3.141592652141592652 - df1;
 cout << " Test Precision : Pi-Pi= " << df2  << "DVV3= " << df1 << endl;

 cout << dvlr;

}

void test_Xntuple() 
{
    char* names[] = {"str1", "str2", "str3", "str4", "str5"} ; 
    XNTuple nt(0, 0, 0, 5, names) ; 
    char** ce = new char*[5] ; 
    for(int i = 0 ; i < 5 ; i++)
	ce[i] = new char[20] ; 

  cout << "======= test_Xtuple:  simple XNTuple test ======= " << endl;

    strncpy(ce[1], "toto a une auto", 20) ; 
    strncpy(ce[2], "titi a une iti", 20) ; 
    strncpy(ce[3], "tutu a une utu", 20) ; 
    strncpy(ce[4], "tata a une ata", 20) ; 
    for(int i = 0 ; i < 100000 ; i++) {
	sprintf(ce[0], "%d", i) ; 
	nt.Fill(NULL, NULL, NULL, ce) ; 
    }
    
    nt.Show() ; 
    cout << nt.LineHeaderToString() ; 
    cout << nt.LineToString(5027) << endl ; 
    
    char* names2[] = {"d0", "d1", "f0", "f1", "f2", "i0", "str0", "str1"} ; 
    XNTuple nt2(2, 3, 1, 2, names2) ; 
    double de[2] ; float fe[3] ; int ie ; 
    char** ce2 = new char*[2] ; 
    for(int i = 0 ; i < 2 ; i++) ce2[i] = new char[20] ; 
    strncpy(ce2[1], "glop glop", 20) ; 
    
    for(int i = 0 ; i < 100000 ; i++) {
	de[0] = i ; 
	de[1] = sin(i) ; 
	fe[0] = i ; 
	fe[1] = i * cos(i) ; 
	fe[2] = 2*i ; 
	ie    = -i; 
	sprintf(ce[0], "%d", i) ; 
	nt2.Fill(de, fe, &ie, ce) ; 
    }
    nt2.Show() ; 
    nt2.LineHeaderToString() ; 
    //    nt2.LineToString(20) ; 
}


void test_xntuple() 
{
    char* names[] = {"dblval", "floval", "intval", "strval"} ; 
    XNTuple nt(1, 1, 1, 1, names) ; 
    double de ; 
    float  fe ; 
    int    ie ; 
    char*  ce = new char[22] ; 
    
    
  cout << "======= test_Xtuple:  XNTuple test ======= " << endl;
    for(int i = 0 ; i < nt.NVar() ; i++)
	printf(" +++ %s <--> %d \n", 
	       nt.NomIndex(i).c_str(), nt.IndexNom(nt.NomIndex(i).c_str())) ; 

    for(int i = 0 ; i < 100000 ; i++) {
	de = fe = ie = i ; 
	sprintf(ce, "%d", i) ; 
	nt.Fill(&de, &fe, &ie, &ce) ; 
    }
    nt.Show() ; 
    cout << nt.VarList_C("toto") ; 
    cout << nt.LineHeaderToString() ; 
    cout << nt.LineToString(20) << endl << endl ; 
    
    
    XNTuple nt2 ; 
    nt2.SwapPath() = "/tmp/sop/" ; 
    nt2.Copy(nt) ; 
    nt2.Show() ; 
    for(int i = 0 ; i < 100000 ; i++) {
	de = fe = ie = i ; 
	sprintf(ce, "%d", i) ; 
	nt2.Fill(&de, &fe, &ie, &ce) ; 
    }
    nt2.Show() ; 
    
    {
      POutPersist os("xnt.ppf");
      os << nt2 ;
    }

    XNTuple::SetSwapPath("/tmp/sop/") ; 
    XNTuple nt3("xnt.ppf") ; 
    nt3.Show() ; 
    
    for(int i = 0 ; i < nt3.NEntry() ; i+= 1000)
	printf("%f %f %d %s\n", 
	       nt3.GetDVal(i,0), 
	       nt3.GetFVal(i,1), 
	       nt3.GetIVal(i,2), 
	       nt3.GetSVal(i,3).c_str()) ; 
    
    double min, max ; 
    for(int i = 0 ; i < nt3.NVar() ; i++) {
	nt3.GetMinMax(i, min, max) ; 
	printf("GetMinMax(%s) : %f/%f\n", 
	       nt3.NomIndex(i).c_str(), min, max) ; 
    }
    //    nt3.Show() ; 
}

