#include "machdefs.h"

#include <math.h>
#include <iostream.h>

#include "tarrinit.h"
#include "array.h"
#include "timing.h"

int main(int narg, char* arg[])
{

  SophyaInit();
  InitTim();   // Initializing the CPU timer
  try {
    cout << "\n -----> Testing TArray Conversion <---- " << endl;
     TArray<int_4> ia(7,5);   
     ia = Sequence(10., 2.);
     TArray<r_4> ra(7,5);   
     ra = ia;
     cout << ra << endl;  
     TArray<r_4> rb(5,3);
     rb =  Sequence(20., .5);  
     TMatrix<int_4> mx(3,5);
     cout << " TArray<r_4> rb(5,3); rb =  Sequence(20., .5); rb : " << endl;
     cout << rb << endl;
     mx = rb;
     cout << " TMatrix<int_4> mx(3,5);       mx = rb;  mx: " << endl;
     cout << mx << endl;
     TArray<r_4> rc(10);
     rc = 3.1415;
     TMatrix<r_8> mx2(rc);
     cout << "   TArray<r_4> rc(10) = 3.1415 , TMatrix<r_8> mx2(rc) rc : " << endl;
     cout << mx2 << endl;
     TMatrix<int_4> mx3(3,5);
     cout << " Trying      TMatrix<int_4> mx3(3,5);  mx3 = rc; ?? " << endl;
     mx3 = rc;
  }
  catch (PThrowable & exc) {
    cerr << " catched Exception " << exc.Msg() << endl;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception " << endl; 
  }  

}
