#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ctimer.h"
#include "strecinit.h"

#include "pidrawwin.h"
#include "pihisto.h"
#include "psfile.h"

#include "exapp_1.h"

static int nbhis = 0;
static void mypact(void *);

/* --Methode-- */
PITApp::PITApp(int narg, char* arg[])
: PIApplication(230, 100, narg, arg), mPeriod(1)   // Periode de 1 seconde pour le "timer"
{

//  Menus, les numeros ds AppendItem sont les numeros de messages
//  qui seront passes a Process() et permettent d'identifier l'action

//  Creation du premier menu  
//  Update :
//  Mis a jour du Label se trouvant ds la fenetre principal avec l'heure
//  Start, Stop :
//  Demarrage et Arret d'une fonction Timer (PIPeriodic) pour 
//  la mise a jour periodique de ce champ
//  Exit : 
//  Arret et sortie du programme

m[0] = new PIPDMenu((PIMsgHandler *)Menubar(),"Fichier");
m[0]->AppendItem("Update", 10101);
m[0]->AppendItem("Start", 10102);
m[0]->AppendItem("Stop", 10103);
m[0]->AppendItem("Exit", 10105);
// On accroche le menu au Menubar
AppendMenu(m[0]);

// 2eme Menu
// Histo :  Creation, affichage d'un histo
// Args : Affichage d'une fenetre de dialogue avec champs texte
// Fermeture fenetre histo + suppression d'histo

m[1] = new PIPDMenu((PIMsgHandler *)Menubar(),"Actions");
m[1]->AppendItem("Histo", 10201);
m[1]->AppendItem("Args", 10202);
m[1]->AppendItem("Close", 10203);
m[1]->AppendItem("PS", 10205);
// On accroche le menu au Menubar
AppendMenu(m[1]);

// Creation de deux labels - Un pour l'heure, l'autre pour X-Y 
// de la fenetre histo
lab[0] = new PILabel(this->MainWin(), "time", 210, 30, 10, 10);
lab[1] = new PILabel(this->MainWin(), "info", 210, 30, 10, 50);
mPeriod.SetAction(mypact);

// Fenetre de dialogue
mAW = new ArgsWind(this);

mCurW = NULL;    // Fenetre courante
SetReady();
}

/* --Methode-- */
PITApp::~PITApp()
{
int i;
for(i=0; i<2; i++)  { delete lab[i]; delete m[i]; }
delete mAW;
}  

/* --Methode-- */
void PITApp::Process(PIMessage msg, PIMsgHandler* sender, void* /*data*/)
{

char strg[64];

// Gestion fenetre courante
if (ModMsg(msg) == PIMsg_Active)
  {
  PIWdg *sndw;
  sndw = (PIWdg *)sender;      
  if (sndw->kind() ==  PIWindow::ClassId)   mCurW = (PIWindow *)sender;
  }

else
  {
  switch(UserMsg(msg))
    {

// --------- 1er menu ----------
    case 10101:     // On met a l'heure
      mypact(NULL);    
      break;

    case 10102:
      mPeriod.Start();   // On demarre la montre 
      break;

    case 10103:
      mPeriod.Stop();    // On demarre la montre 
      break;

    case 10105:          // Sortie d'application
      Stop();
      break;

// ----------  2eme menu --------

    case 10201 :        //  Creation, Affichage d'histo
      PIDrawWindow *  draw;
      PIHisto *pih;
      Histo *h;
      float x;

      SetBusy();    // souris -> montre 
      // Creation et remplissage d'histo 
      h = new Histo(0., 200., 100);  
      for(int i=0; i<100; i++)  
        { x = (2*i+1.);  h->Add(x, x*(200.-x)); }

      nbhis++;  sprintf(strg, "Histo %d", nbhis);
      // Creation d'une fenetre de trace 
      draw = new PIDrawWindow(this, strg, PIWK_normal, 200, 200, 300, 300);
      // Creation d'un traceur d'histo
      pih = new PIHisto(h);   

      pih->SetAutoDelHisto(true);   // Histo delete quand window -> close
      // Accrochage du traceur d'histo a la fenetre de Draw
      draw->AddDrawer(pih);   
      // Designation du champ label pour affichage coordonnees quand click souris
      draw->DrawWdg()->SetTextWin(lab[1]);
      draw->SetAutoDelChilds(true);  
      // On affiche  la fenetre 
      draw->Show();    

      SetReady();    //  souris->pointeur , on n'est plus occupe
      break;

    case 10202 :     // Apparition de la fenetre de dialogue
      mAW->Show();
      break;

    case 10203 :     // Suppression de la fenetre courante
      if (mCurW)  { mCurW->Hide();  delete mCurW;}
      lab[1]->SetLabel("");
      mCurW = NULL;
      break;


    case 10205 :      // Creation fichier PostScript 
      if(mCurW) {
        PSFile *mps;
        printf("Open PSFile (exapp_1.ps) \n");
	mps = new PSFile("exapp_1.ps",14,10,
			 mCurW->XSize(),mCurW->YSize());
	// Contenu fenetre courante ds .ps 
	mCurW->PSPrint(mps,0,0);
	delete mps;
      }
      break;

    default :
      printf("PITApp::Process() Msg= %d (%d - %d)??? \n", 
            (int)msg, (int)UserMsg(msg),(int)ModMsg(msg));
     break;
    }
  }
return;
}

/* ........................................................... */
/*       Classe ArgsWindow  (Appel UserProc Function)      */
/* ........................................................... */


/* --Methode-- */
ArgsWind::ArgsWind(PIApplication *par)
: PIWindow((PIMsgHandler *)par, "Args", PIWK_dialog, 260, 200, 150, 150)
{
pap = par;

// Creation de champs "labels"
mLab[0] = new PILabel(this, "FMin Max:", 100, 35, 20, 10); 
mLab[1] = new PILabel(this, "XMin Max:", 100, 35, 20, 55);
mLab[2] = new PILabel(this, "YMin Max:", 100, 35, 20, 100);

// Creation de champs textes 
mText[0] = new PIText(this, "UsArg1", 130, 35, 120, 10);
mText[0]->SetText("1. -1.");
mText[1] = new PIText(this, "UsArg2", 130, 35, 120, 55);
mText[1]->SetText("1. -1.");
mText[2] = new PIText(this, "UsArg3", 130, 35, 120, 100);
mText[2]->SetText("1. -1.");

// Creation de bouton d'action 
//  Attention : Numero de message pour Process()
mBut[0] = new PIButton(this, "OK", 555, 70, 30, 30, 160);
mBut[1] = new PIButton(this, "Cancel", 777, 70, 30, 160, 160);
FinishCreate();

}

/* --Methode-- */
ArgsWind::~ArgsWind()
{
for(int i=0; i<3; i++)
  {
  delete mLab[i];
  delete mText[i];
  }

delete mBut[0]; 
delete mBut[1]; 
}

/* --Methode-- */
void ArgsWind::SetLabels(char *lab1, char *lab2, char *lab3)
// Permet de changer les etiquettes (les label)
{
mLab[0]->SetLabel(lab1);
mLab[1]->SetLabel(lab2);
mLab[2]->SetLabel(lab3);
}

/* --Methode-- */
void ArgsWind::SetTexts(char *tx1, char *tx2, char *tx3)
// Permet de changer les contenu des champs texte
{
mText[0]->SetText(tx1);
mText[1]->SetText(tx2);
mText[2]->SetText(tx3);

}

/* --Methode-- */
void ArgsWind::GetTexts(char *tx1, char *tx2, char *tx3)
// Permet de recuperer les contenus des champs texte
// ATTENTION : Il faut qu'il y ait assez de place 
// ds tx1, tx2, tx3 pour que la fonction puisse y copier 
// les chaines
{
strcpy(tx1, mText[0]->GetText().c_str());
strcpy(tx2, mText[1]->GetText().c_str());
strcpy(tx3, mText[2]->GetText().c_str());

}

/* --Methode-- */
void ArgsWind::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
float xmin, xmax, ymin, ymax;
float fmin, fmax;

switch (UserMsg(msg))
  {
  case 777:   // Bouton cancel - On s'en va 
    this->Hide();
    pap->SetReady();
    break;

  case 555:    // Bouton OK
// On recupere les textes des 3 champs :
    for(int i=0; i<3; i++)  
      printf("ArgsWind::Process() Txt[%d] = %s \n", i, mText[i]->GetText().c_str());
    sscanf(mText[0]->GetText().c_str(),"%g %g", &fmin, &fmax);
    sscanf(mText[1]->GetText().c_str(),"%g %g", &xmin, &xmax);
    sscanf(mText[2]->GetText().c_str(),"%g %g", &ymin, &ymax);
    
    printf("... FMin/Max= %g %g  XMin/Max= %g %g YMin/Max= %g %g\n",
           fmin, fmax, xmin, xmax, ymin, ymax); 
    this->Hide();
    pap->SetReady();
    break;    
  }
    
return;
}

static PITApp * app;

/* Nouvelle-Fonction */
void mypact(void *)
// Fonction pour lire l'heure de la machine et mettre a jour le champ label
{
int tm;
char *s;
time(&tm);
s = ctime(&tm);
// printf("mypact_Info:  %d  (%s)", tm, s);
app->lab[0]->SetLabel((string)s);
return;
}

int main(int narg, char *arg[])
{

// Initialisation de tout PEIDA (avec StarReco++)
PeidaStarRecoInitiator InitStar;

app = new PITApp(narg, arg);
puts("appel de Application.Run() ... ");
app->Run();

delete app;
exit(0);
}


