#include <stdlib.h>
#include <stdio.h>

extern "C" {
void InitTim();
void PrtTim(char *);
}

void Mult(int n, double *v1, double *v2, double *v3);
void MultOMP(int n, double *v1, double *v2, double *v3);
void MultOMP2(int N, int n, double *v1, double *v2, double *v3);

int main (int narg, char *arg[])
{
int i,j, N, M;

double *v1, *v2, *v3;

if (narg < 2) { 
  printf("\n Usage tompCXX P/x [N M] \n \n");
  printf(" P -> Calling MultOMP2 p -> Calling MultOMP, x -> Calling Mult \n");
  printf(" N (=100): External loop number   M : Array Size (500000) \n");
  exit(0);
}
N = 100;
M = 500000;
if (narg > 2) N = atoi(arg[2]);
if (narg > 3) M = atoi(arg[3]);

InitTim();

v1 = new double[M];
v2 = new double[M];
v3 = new double[M];

 for(i=0; i<M; i++) { v1[i] = random()%1000;  v2[i] = random()%5000; }
PrtTim("End of Init ");

if (*arg[1] == 'p') { 
  printf("Calling MultOMP2(N=%d, Size= %d) \n", N, M);
  for(i=0; i<N; i++) MultOMP2(N, M, v1, v2, v3);
}
else if (*arg[1] == 'p') { 
  printf("Calling N=%d times MultOMP(Size= %d) \n", N, M);
  for(i=0; i<N; i++) MultOMP(M, v1, v2, v3);
}
else { 
  printf("Calling N=%d times Mult(Size= %d) \n", N, M);
  for(i=0; i<N; i++) Mult(M, v1, v2, v3);
}

PrtTim("End of Multiplication ");

delete[] v1;
delete[] v2;
delete[] v3;
exit(0);
}


void Mult(int n, double *v1, double *v2, double *v3)
{
int k;
for(k=0; k<n; k++)
  v3[k] = v1[k] * v2[k];
}

void MultOMP(int n, double *v1, double *v2, double *v3)
{
int k;
#pragma omp parallel for
for(k=0; k<n; k++)
  v3[k] = v1[k] * v2[k];
}
void MultOMP2(int N, int n, double *v1, double *v2, double *v3)
{
int k;
int i;
#pragma omp parallel default(shared)
#pragma omp parallel for
for(i=0; i<N; i++)
#pragma omp parallel for
  for(k=0; k<n; k++)
     v3[k] = v1[k] * v2[k];
}
