#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dlfcn.h>

#include "perrors.h"
#include "fitsimage.h"

#include "pidemo.h"
#include "piup.h"


/*  Pour le link dynamique  */
typedef FitsImageR4 * (* UsPrFunc) (FitsImageR4 * myimg, int xp, int yp, int dx, int dy,
                                    char * arg1, char * arg2);
static UsPrFunc  userFunc[3] = { NULL, NULL, NULL };
static void *dlhandle = NULL;

static char userlibname[256];

static int DynLink(char *usln);

int DynLink(char *usln)
{
UsPrFunc uf;
int i, rc;

if (usln != NULL)  strncpy(userlibname, usln, 255);  userlibname[255] = '\0';

printf("PIDemo_DynLink(): Relinking from %s \n", userlibname);
if (dlhandle != NULL)  dlclose(dlhandle);
for(i=0; i<3; i++)  userFunc[i] = NULL;
dlhandle =  dlopen(userlibname, RTLD_NOW);
if (dlhandle == NULL)  
  { printf("PIDemo_DynLink(), Erreur d'ouverture UserShLib %s \n", userlibname);
  return(100); }
rc = 0;
printf("PIDemo_DynLink(): Searching for PIUserProc_1 (Rc=%d) \n", rc);
uf = dlsym(dlhandle, "PIUserProc_1__FPt9FitsImage1ZfiiiiPcT5");
if (uf != NULL)  userFunc[0] = uf;
else rc += 2;
printf("PIDemo_DynLink(): Searching for PIUserProc_3 (Rc=%d) \n", rc);
uf = dlsym(dlhandle, "PIUserProc_2__FPt9FitsImage1ZfiiiiPcT5");
if (uf != NULL)  userFunc[1] = uf;
else rc += 4;
printf("PIDemo_DynLink(): Searching for PIUserProc_3 (Rc=%d) \n", rc);
uf = dlsym(dlhandle, "PIUserProc_3__FPt9FitsImage1ZfiiiiPcT5");
if (uf != NULL)  userFunc[2] = uf;
else rc += 8;

if (rc != 0)  printf("PIDemo_DynLink() / Erreur, Rc = %d \n", rc);
return(rc);
}

/* ........................................................... */
/*                    Classe PIDemoApp                         */
/* ........................................................... */

/* --Methode-- */
PIDemoApp::PIDemoApp(char *path)
: PIApplication(300, 200)
{
for(int i=0; i<NMXIMG; i++)
  { wpii[i] = NULL;  pii[i] = NULL;  img[i] = NULL; }
mNimg = 0;   mCur = NULL;
mState = 0;

m[0] = new PIPDMenu((PIMsgHandler *)Menubar(),"File");
m[0]->AppendItem("Open", 10101);
m[0]->AppendItem("Close", 10102);
m[0]->AppendItem("Save", 10103);
m[0]->AppendItem("Relink", 10104);
m[0]->AppendItem("Exit", 10105);

m[1] = new PIPDMenu((PIMsgHandler *)Menubar(),"Image");
m[1]->AppendItem("Lut...", 10201);
m[1]->AppendItem("Size*1", 10202);
m[1]->AppendItem("Expand*2", 10203);
m[1]->AppendItem("Compress*2", 10204);
m[1]->AppendItem("Expand*4", 10205);
m[1]->AppendItem("Compress*4", 10206);

m[2] = new PIPDMenu((PIMsgHandler *)Menubar(),"Operation");
m[2]->AppendItem("UserProc-1", 10301);
m[2]->AppendItem("UserProc-2", 10302);
m[2]->AppendItem("UserProc-3", 10303);
m[2]->AppendItem("PixelHisto", 10304);
m[2]->AppendItem("PrintLut", 10305);
m[2]->AppendItem("CheckDyn", 10306);

AppendMenu(m[0]);
AppendMenu(m[1]);   
AppendMenu(m[2]);

zoom = new PIPixmap(this->MainWin(), "Zoom", 120,120,10,10);
labimg = new PILabel(this->MainWin(), "PixelValue", 280, 25, 10, 150);
labimg->SetLabel("");

draw = new PIDrawWindow(this, "histo", PIWK_normal, 300, 300, 300, 300);
pixelHisto = new Histo(0,2000, 200);
draw->AddDrawer(piHisto=new PIHisto(pixelHisto));

// lab =  new PILabel(this->MainWin(), "State", 60, 20, 150, 10);
// lab->SetBorderWidth(1);
 
olb[0] = new PILabel(this->MainWin(), "AutoLut :", 60, 25, 140, 30);
pum[0] = new PIPUMenu((PIMsgHandler *)this, "AutoLut");
pum[0]->AppendItem("+3 Sig", 20303);
pum[0]->AppendItem("+2 Sig", 20302);
pum[0]->AppendItem("+1 Sig", 20301);
pum[0]->AppendItem("-1 Sig", 20299);
pum[0]->AppendItem("-2 Sig", 20298);
opm[0] = new PIOptMenu(this->MainWin(), pum[0], 80, 25, 210, 30);
opm[0]->SetValue(20302);

olb[1] = new PILabel(this->MainWin(), "Zoom :", 60, 25, 140, 70);
pum[1] = new PIPUMenu((PIMsgHandler *)this, "Zoom");
pum[1]->AppendItem("Agr. * 5", 20105);
pum[1]->AppendItem("Agr. * 4", 20104);
pum[1]->AppendItem("Agr. * 3", 20103);
pum[1]->AppendItem("Agr. * 2", 20102);
pum[1]->AppendItem("* 1", 20101);
pum[1]->AppendItem("Red. / 2", 20098);
pum[1]->AppendItem("Red. / 3", 20097);
pum[1]->AppendItem("Red. / 4", 20096);
pum[1]->AppendItem("Red. / 5", 20095);
opm[1] = new PIOptMenu(this->MainWin(), pum[1], 80, 25, 210, 70);
opm[1]->SetValue(20101);

olb[2] = new PILabel(this->MainWin(), "ColMap :", 60, 25, 140, 110);
pum[2] = new PIPUMenu((PIMsgHandler *)this, "ColMap");
pum[2]->AppendItem("Grey32", 20201);
pum[2]->AppendItem("GreyInv32", 20202);
pum[2]->AppendItem("ColRJ32", 20203);
pum[2]->AppendItem("ColBR32", 20204);
pum[2]->AppendItem("ColRV32", 20205);
opm[2] = new PIOptMenu(this->MainWin(), pum[2], 80, 25, 210, 110);
opm[2]->SetValue(20203);

pfc = new PIFileChooser(this,"FileChooser", 5000); 
if (path)
  pfc->SetPath(path);


mLutw = new LutWind(this);
mUP = new UserProcWind(this);

SetReady();
}

/* --Methode-- */
PIDemoApp::~PIDemoApp()
{
int i;
for(i=0; i<3; i++)
  { 
  delete m[i];
  delete opm[i];
  delete pum[i];
  delete olb[i];
  }
delete pfc;
delete lab;

for(i=0; i<mNimg; i++)
  {  
  delete pii[i];
  delete img[i];
  delete wpii[i];
  }

delete zoom;
delete labimg;

delete draw;
delete pixelHisto;
delete piHisto;

delete mLutw;
delete mUP;

}  

/* --Methode-- */
void PIDemoApp::Process(long msg, PIMsgHandler* sender, void* data)
{
CMapId cmap[5] = { CMAP_GREY32, CMAP_GREYINV32, CMAP_COLRJ32, 
                   CMAP_COLBR32, CMAP_COLRV32 } ;


if  ((mState != 0) && (msg > 9999)) { PIBeep(); return; }


if ( (msg > 20000)  && (CurrentPIImage()) )
  {
  msg -= 20000;
  if ((msg < 110) && (msg > 90))  // Zoom
    CurrentPIImage()->SetZoom(msg-100);
  else if ((msg > 200) && (msg < 206)) // Changement de couleur 
    CurrentPIImage()->SetColMap(cmap[msg-201]);
  else if ((msg > 290) && (msg < 310))
    CurrentPIImage()->SetLut( CurrentImage()->minPix, CurrentImage()->maxPix,
                               kLutType_Lin, msg-300);
  }

else
  {
  switch (msg)
    {
    case  PIMsg_ActiveWindow :
      mCur = (PIImage *)sender;
      break;

    case 10101 :
      pfc->AcceptNewFile(false); 
      pfc->SetMsg(5101);
      SetBlocked();
      pfc->Show();
      break;

    case 10102 :
      CloseCurrent();
      break;
        
    case 10103 :
      pfc->AcceptNewFile(true); 
      pfc->SetMsg(5103);
      SetBlocked();
      pfc->Show();
      break;

    case 10104:
      SetBusy();
      DynLink(NULL);
      SetReady();
      break;

    case 10105:
      Stop();
      break;

    case 5101 :
      if (data)  OpenImage(pfc->GetFileName());
      SetReady();
      break;

    case 5103 :
      if (data)  SaveCurrent(pfc->GetFileName());
      SetReady();
      break;      

    case 10201 :
      if ( CurrentPIImage() )  mLutw->Show();
      break;

    case 10202 :
      if ( CurrentPIImage()) 
        {
        CurrentPIImage()->SetZoom(1, false);
        CurrentPIImage()->SetOffset(0, 0, false);
        CurrentImgWin()->SetSize(CurrentImage()->XSize(), 
                                  CurrentImage()->YSize());
        }
      break;

    case 10203 :
      if ( CurrentPIImage()) 
        {
        CurrentPIImage()->SetZoom(2, false);
        CurrentPIImage()->SetOffset(0, 0, false);
        CurrentImgWin()->SetSize(CurrentImage()->XSize()*2, 
                                  CurrentImage()->YSize()*2);
        }
      break;

    case 10204 :
      if ( CurrentPIImage()) 
        {
        CurrentPIImage()->SetZoom(-2, false);
        CurrentPIImage()->SetOffset(0, 0, false);
        CurrentImgWin()->SetSize(CurrentImage()->XSize()/2, 
                                  CurrentImage()->YSize()/2);
        }
      break;
       
    case 10205 :
      if ( CurrentPIImage()) 
        {
        CurrentPIImage()->SetZoom(4, false);
        CurrentPIImage()->SetOffset(0, 0, false);
        CurrentImgWin()->SetSize(CurrentImage()->XSize()*4, 
                                  CurrentImage()->YSize()*4);
        }
      break;

    case 10206 :
      if ( CurrentPIImage()) 
        {
        CurrentPIImage()->SetZoom(-4, false);
        CurrentPIImage()->SetOffset(0, 0);
        CurrentImgWin()->SetSize(CurrentImage()->XSize()/4, 
                                  CurrentImage()->YSize()/4);
        }
      break;
       

    case 10301:
    case 10302:
    case 10303:
      if ( CurrentPIImage() )
        {
        SetBlocked();
        mUP->SelectUP(msg-10300);
        mUP->Show();
        }
      break;
      
    case 10304:
      pixelHisto->Zero();
      for (int i=0; i<CurrentImage()->XSize(); i++)
        for (int j=0; j<CurrentImage()->YSize(); j++)
          pixelHisto->Add((*CurrentImage())(i,j));
      piHisto->Refresh();
      draw->Show();
      break;

    case 10305:
      if ( CurrentPIImage() )
        (CurrentPIImage()->Lut())->Print();
      break;

    case 10306:
      if ( CurrentPIImage() )
        {
        SetBusy();
        CurrentImage()->CheckDyn();
        CurrentImage()->Print();
        SetReady();
        }
      break;

              
    }
  }
}

/* --Methode-- */
void PIDemoApp::SetBusy()
{
mState = 2;
// lab->SetLabel("Working ...");
}

/* --Methode-- */
void PIDemoApp::SetReady()
{
mState = 0;
// lab->SetLabel("**Ready**");
}

/* --Methode-- */
void PIDemoApp::SetBlocked()
{
mState = 1;
// lab->SetLabel("--Dialog--");
}

/* --Methode-- */
void PIDemoApp::OpenImage(string const & flnm)
{
char buff[128];
char * pn;
int i,j,k;
bool ok = true;
FitsImageR4 * myimg;

if (mNimg >= NMXIMG)
  {
  printf("PIDemoApp::OpenImage_Error Two many images (%d) opened ...\n",mNimg);
  printf("   Close some of the images ... ");
  return;
  }

pn = (char *)flnm.c_str();
printf("PIDemoApp::OpenImage Opening file %s \n", pn);

if ((k=strchr(pn, '.')-pn) < 0)  k = strlen(pn);
k--;
if (k < 0)  {printf("PIDemoApp::OpenImage_Error \n"); return;}

for(j=k; j>=0; j--)
  if (pn[j] == FILESEP)  break;
for(i=j+1; i<=k; i++)  buff[i-j-1] = pn[i];  
buff[i-j-1] = '\0';
printf("PIDemoApp::OpenImage ImageName= %s \n", buff);

TRY{
  myimg = new FitsImageR4();
  myimg->Read(flnm);
}  CATCH(merr) 
  { printf("PIDemoApp::OpenImage_Error Exception= %d (%s) \n", merr, PeidaExc(merr)); 
  ok = false; } ENDTRY;
if (ok)
  {
  string s(buff);
  AddImage(myimg, s);
  }
}

/* --Methode-- */
void PIDemoApp::AddImage(FitsImageR4 * nouv, string const & name)
{
int nimg = mNimg;
int sx, sy;

if (nouv == NULL)
  {
  printf("PIDemoApp::AddImage_Error  Cannot Add NULL image \n");
  return;
  }
if (mNimg >= NMXIMG)
  {
  printf("PIDemoApp::AddImage_Error Two many images (%d) opened ...\n",mNimg);
  printf("   Close some of the images ... ");
  return;
  }

img[nimg] = nouv;
if ( (img[nimg]->XSize() <= 0)  || (img[nimg]->YSize() <= 0))
  {
  printf("PIDemoApp::OpenImage_Error Pb lecture (FitsImage::Read) \n");
  return;
  }

sx = img[nimg]->XSize();  sy = img[nimg]->YSize();
if (sx > 512) sx = 512;
if (sy > 512) sy = 512;

wpii[nimg] = new PIWindow(this, (char *)name.c_str(), PIWK_normal, 
                          sx, sy, 200, 200);
pii[nimg] = new PIImage(wpii[nimg], (char *)name.c_str(), sx, sy, 0, 0);
pii[nimg]->SetBinding(true, true, true, true);
pii[nimg]->SetZoomWin(zoom);
pii[nimg]->SetTextWin(labimg);
pii[nimg]->SetImage(img[nimg]);
// pii[nimg]->Apply();
wpii[nimg]->Show();
mCur = pii[nimg];
mNimg++;
return; 
}

/* --Methode-- */
void PIDemoApp::CloseCurrent()
{
int n;
if ((n=GetNumCurrent()) < 0)  return;
zoom->SetPixmap(NULL,0,0);
zoom->EraseWindow();
labimg->SetLabel("");
wpii[n]->Hide();
delete pii[n];
delete img[n];
delete wpii[n];
pii[n] = pii[mNimg-1];
wpii[n] = wpii[mNimg-1];
img[n] = img[mNimg-1];
mNimg--;
mCur = NULL;
return;
}

/* --Methode-- */
void PIDemoApp::SaveCurrent(string const & flnm)
{
int n;
if ((n=GetNumCurrent()) < 0)  return;

if (strlen(flnm.c_str()) <= 0) 
  { 
  printf("PIDemoApp::SaveCurrent_Error: bad filename (%s) \n", flnm.c_str());
  return;
  }

printf("PIDemoApp::SaveCurrent: Image %s saved to %s \n", 
       (char *)pii[n]->Nom().c_str(), (char *)flnm.c_str());
TRY {
  img[n]->Save(flnm); 
}  CATCH(merr) 
  { printf("PIDemoApp::SaveCurrent_Error Exception= %d (%s) \n", merr, PeidaExc(merr));  } ENDTRY;
return;
}

/* --Methode-- */
int PIDemoApp::GetNumCurrent()
{
int n=-1;
if (mNimg <= 0)  return(-1);
for(int i=0; i<mNimg; i++)
  if (mCur == pii[i])  { n = i; break; }

if (n < 0)  
  printf(" PIDemoApp::GetNumImg() Curret image not found (%lx)\n",(long)mCur);

return(n);  
}

/* --Methode-- */
FitsImageR4 * PIDemoApp::CurrentImage()
{
int n;
n = GetNumCurrent();
if (n < 0)  return(NULL);
else return(img[n]);
}

/* --Methode-- */
PIWindow * PIDemoApp::CurrentImgWin()
{
int n;
n = GetNumCurrent();
if (n < 0)  return(NULL);
else return(wpii[n]);
}

/* ........................................................... */
/*       Classe LutWind  (Changement de Lut d'image)           */
/* ........................................................... */



/* --Methode-- */
LutWind::LutWind(PIDemoApp *par)
: PIWindow((PIMsgHandler *)par, "ChangeLut", PIWK_dialog, 240, 220, 150, 150)
{
dap = par;

mLab[0] = new PILabel(this, "MinPixel", 60, 30, 30, 20); 
mLab[1] = new PILabel(this, "MaxPixel", 60, 30, 30, 60); 

mText[0] = new PIText(this, "MinVal", 100, 30, 110, 20);
mText[0]->SetText("1");
mText[1] = new PIText(this, "MaxVal", 100, 30, 110, 60);
mText[1]->SetText("32000");

mOlb[0] = new PILabel(this, "LutType", 60, 25, 30, 100); 
mPum[0] = new PIPUMenu((PIMsgHandler *)this, "LutType");
mPum[0]->AppendItem("Linear", 1100);
mPum[0]->AppendItem("Log.", 1101);
mOpt[0] = new PIOptMenu(this, mPum[0], 100, 25, 110, 100);
mOpt[0]->SetValue(1100);

mOlb[1] = new PILabel(this, "AutoLut", 60, 25, 30, 135); 
mPum[1] = new PIPUMenu((PIMsgHandler *)this, "AutoLut");
mPum[1]->AppendItem("+3 Sig", 1203);
mPum[1]->AppendItem("+2 Sig", 1202);
mPum[1]->AppendItem("+1 Sig", 1201);
mPum[1]->AppendItem("NoAuto", 1200);
mPum[1]->AppendItem("-1 Sig", 1199);
mPum[1]->AppendItem("-2 Sig", 1198);
mPum[1]->AppendItem("-3 Sig", 1197);
mOpt[1] = new PIOptMenu(this, mPum[1], 100, 25, 110, 135);
mOpt[1]->SetValue(1202);

mBut[0] = new PIButton(this, "Apply", 1500, 70, 30, 30, 170);
mBut[1] = new PIButton(this, "Dismiss", 1600, 70, 30, 140, 170);

FinishCreate();
}

/* --Methode-- */
LutWind::~LutWind()
{
for(int i=0; i<2; i++)
  {
  delete mLab[i];
  delete mBut[i];
  delete mText[i];
  delete mOpt[i];
  delete mPum[i];
  }
}
/* --Methode-- */
void LutWind::Show()
{
char buff[32];
PIImage *mpii;
mpii = dap->CurrentPIImage();
if (mpii == NULL)  return;
sprintf(buff,"%g", (mpii->Lut())->Min());
mText[0]->SetText(buff);
sprintf(buff,"%g", (mpii->Lut())->Max());
mText[1]->SetText(buff);
if ( (mpii->Lut())->Type() == kLutType_Lin ) 
  mOpt[0]->SetValue(1100);
else mOpt[0]->SetValue(1101);
mOpt[1]->SetValueStr("NoAuto");
dap->SetBlocked();
PIWindow::Show();
return;
}


/* --Methode-- */
void LutWind::Process(long msg, PIMsgHandler* sender, void* data)
{
float min, max;
int lauto, typ;
int typlut[2] = {kLutType_Lin, kLutType_Log} ; 

switch (msg)
  {
  case 1600:
    dap->SetReady();
    this->Hide();
    break;
  case 1500:
    if (dap->CurrentPIImage() == NULL)  return;
    min = atof(mText[0]->GetText().c_str());
    max = atof(mText[1]->GetText().c_str());
    lauto = mOpt[1]->GetValue() - 1200;
    typ = mOpt[0]->GetValue() - 1100;
    if ( (typ < 0) || (typ > 1) )  typ = 0;
    (dap->CurrentPIImage())->SetLut(min, max, typlut[typ], lauto);
//    ((dap->CurrentPIImage())->Lut())->Print();
    break;
  default:
//    printf("LutWind::Process Msg %d received \n", (int)msg);
    break;
  }
}


/* ........................................................... */
/*       Classe UserProcWindow  (Appel UserProc Function)      */
/* ........................................................... */


/* --Methode-- */
UserProcWind::UserProcWind(PIDemoApp *par)
: PIWindow((PIMsgHandler *)par, "UserProc", PIWK_dialog, 260, 200, 150, 150)
{
dap = par;
mUpr = 0;

mLab[0] = new PILabel(this, "OutImageName:", 100, 35, 20, 10); 
mLab[1] = new PILabel(this, "UserArg(1):", 100, 35, 20, 55);
mLab[2] = new PILabel(this, "UserArg(2):", 100, 35, 20, 100);
 
mText[0] = new PIText(this, "OutName", 130, 35, 120, 10);
mText[0]->SetText("ImgOut");
mText[1] = new PIText(this, "UserArg1", 130, 35, 120, 55);
mText[1]->SetText("");
mText[2] = new PIText(this, "UserArg2", 130, 35, 120, 100);
mText[2]->SetText("");

mBut[0] = new PIButton(this, "Process", 2500, 70, 30, 30, 160);
mBut[1] = new PIButton(this, "Cancel", 2600, 70, 30, 160, 160);
FinishCreate();

}

/* --Methode-- */
UserProcWind::~UserProcWind()
{
for(int i=0; i<3; i++)
  {
  delete mLab[i];
  delete mText[i];
  }

delete mBut[0]; 
delete mBut[1]; 
}

/* --Methode-- */
void UserProcWind::Process(long msg, PIMsgHandler* sender, void* data)
{
FitsImageR4 *mimg, *oimg;
int xp, yp, dx, dy;

switch (msg)
  {
  case 2600:
    dap->SetReady();
    this->Hide();
    break;

  case 2500:
    mimg = dap->CurrentImage();
    if (mimg == NULL)  return;
    xp = (dap->CurrentPIImage())->XPave();
    yp = (dap->CurrentPIImage())->YPave();
    dx = (dap->CurrentPIImage())->XSzPave();
    dy = (dap->CurrentPIImage())->YSzPave();
    dap->SetBusy();
    this->Hide();
    oimg = NULL;
    switch (mUpr)
      {
      case 1 :
      case 2 :
      case 3 :
        oimg = userFunc[mUpr-1] (mimg, xp, yp, dx, dy,
                            (char *) (mText[1]->GetText().c_str()), 
                            (char *) (mText[2]->GetText().c_str()));
        break;
/*
      case 2 :
        oimg = PIUserProc_2(mimg, xp, yp, dx, dy,
                            (char *) (mText[1]->GetText().c_str()), 
                            (char *) (mText[2]->GetText().c_str()));
        break;

      case 3 :
        oimg = PIUserProc_3(mimg, xp, yp, dx, dy,
                            (char *) (mText[1]->GetText().c_str()), 
                            (char *) (mText[2]->GetText().c_str()));
        break;
*/
      }    
    if (oimg)  dap->AddImage(oimg,mText[0]->GetText());
    dap->SetReady();
    break;
  }
    
return;
}

// Le main  ....

int main(int narg, char *arg[])
{

char *path;
int rc;
  
if (narg > 1)  path = arg[1];
else path = NULL;

if (narg > 2)  rc = DynLink(arg[2]);
else rc = DynLink("piup.so");
if (rc != 0)
  {
  printf("PIApp:: Erreur d'ouverture UserProcFunc Shared-Object ... \n");
  exit(0);
  }

PIDemoApp app(path);

app.Run();

dlclose(dlhandle);
exit(0);
}
