#ifndef PIMSGHANDLER_H_SEEN
#define PIMSGHANDLER_H_SEEN

/* Classe de gestion de messages */

#include <stdlib.h>

enum {
 // Les messages reserves systeme (PI)   les 8 premiers bits
 // Messages user, les bits restants
	PIMsg_Active        = 1,
        PIMsg_Close         = 2,
        PIMsg_Resize        = 3,
        PIMsg_ResizeRequest = 4,

	PIMsg_Click         = 21,
        PIMsg_Press         = 22,
        PIMsg_Release       = 23,
        PIMsg_Drag          = 24,
        PIMsg_Drop          = 25,
        PIMsg_Copy          = 26,
        PIMsg_Paste         = 27,
        PIMsg_Cut           = 28,

	PIMsg_OK            = 21,
	PIMsg_Cancel        = 22,
	PIMsg_Help          = 23,

	PIMsg_DataChanged   = 31,
        PIMsg_Select        = 32,
        PIMsg_ClearSel      = 33

};


// Definition de type pour les messages - Il est peu probable que le typedef change ...
//                                      Reza 17/10/96
typedef unsigned long PIMessage;
typedef unsigned char PIMsgMod;

class PIMsgHandler {
public:
			     PIMsgHandler(PIMsgHandler* par=NULL);
	virtual 	     ~PIMsgHandler();
	
	virtual void	     SetMsgParent(PIMsgHandler* par) {msgParent = par;}

	virtual void         Send(PIMessage msg, PIMsgMod mm=0, void* data=NULL);
	inline  void         SendSelf(PIMessage msg, PIMsgMod mm=0, void* data=NULL)
                                  { Process(BuildMsg(msg, mm), this, data); }

        inline  PIMessage    UserMsg(PIMessage msg) { return (msg >> 8); }
        inline  PIMessage    ModMsg(PIMessage msg) { return (msg & 0xFF); }
	inline  PIMessage    BuildMsg(PIMessage um, PIMsgMod mm) 
                        	  { return ((um << 8) | mm); }

protected:
	virtual void	ReSend(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
	virtual void	Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private:
	PIMsgHandler*     msgParent;
};

#endif
