/*  Caracteristique du CCD      Reza  03/95  -*- C++ -*- */

#ifndef DYNCCD_H_SEEN
#define DYNCCD_H_SEEN

#include "machdefs.h"
#include "pexceptions.h"
#include "cimage.h"
#include "ppersist.h"

namespace SOPHYA {

enum {kConstantNoise = 0, kPhotonNoise, kSigFondNoise, kSqrtADUNoise};

class DynCCD 
{
  public :

  int_4 TypNoise;        // Type de calcul du bruit 
  r_8 MinADU,MaxADU;   // Valeur min et max des pixels 
  r_8 Gain;            // Gain en electron/ADU 
  r_8 RONoise;         // Bruit de lecture en electron  
  r_8 RefFond;         // Fond de ciel de ref (TypNoise=2) 
  r_8 RefSFond;        // Sigma du fond  (TypNoise=2) */

/*    ===>  Les methodes   */
  DynCCD(int_4 typ=0, r_8 min=-9.e19, r_8 max=9.e19,
         r_8 g=1., r_8 ron=0., r_8 rf=0., r_8 rfs=0.);

  void Set(int_4 typ=0, r_8 min=-9.e19, r_8 max=9.e19,
         r_8 g=1., r_8 ron=0., r_8 rf=0., r_8 rfs=0.);
  void Print();
  r_8 Noise(r_8 pixel) const;
};

} // Fin du namespace


template <class T>
Image<T> NoiseImage(Image<T> const & pim, DynCCD const & dynccd);

template <class T>
void ImgAddNoise(Image<T>&, DynCCD const&);

// Les entrees-sortie

inline POutPersist& operator << (POutPersist& c, DynCCD const& data)
{
  c.PutI4(data.TypNoise);
  c.PutR8s(&data.MinADU, 6);
  return c;
}

inline 
PInPersist& operator >> (PInPersist& c, DynCCD& data)
{
  c.GetI4(data.TypNoise);
  c.GetR8s(&data.MinADU, 6);
  return c;
}




#endif
