//  Classes image heritant de TMatrix<T>
//                       R.Ansari, C.Magneville 07/2000    
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include "pexceptions.h"
#include "cimage.h"

template <class T>
Image<T>::Image()
// Constructeur par defaut.
  : TMatrix<T>()
{
  SetOrg();
  SetPixelSize();
}

template <class T>
Image<T>::Image(uint_4 sizx, uint_4 sizy, r_8 szpx, r_8 szpy, r_8 orgx, r_8 orgy)
// Constructeur par defaut.
  : TMatrix<T>(sizy, sizx) 
{
  SetOrg(orgx, orgy);
  SetPixelSize(szpx, szpy);
}

template <class T>
Image<T>::Image(const Image<T>& a)
  : TMatrix<T>(a)
{
  SetOrg(a.XOrg(), a.YOrg() );
  SetPixelSize(a.XPixSize(), a.YPixSize());
}

template <class T>
Image<T>::Image(const Image<T>& a, bool share)
  : TMatrix<T>(a, share)
{
  SetOrg(a.XOrg(), a.YOrg() );
  SetPixelSize(a.XPixSize(), a.YPixSize());
}
template <class T>
Image<T>::~Image()
{
}

///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template Image<uint_2>
#pragma define_template Image<int_4>
#pragma define_template Image<int_8>
#pragma define_template Image<r_4>
#pragma define_template Image<r_8> 
//#pragma define_template Image< complex<r_4> > 
//#pragma define_template Image< complex<r_8> > 
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class Image<uint_2>;
template class Image<int_4>;
template class Image<int_8>;
template class Image<r_4>;
template class Image<r_8>;
//template class Image< complex<r_4> >;
//template class Image< complex<r_8> >;
#endif
