#ifndef PIBWDGGEN_H_SEEN
#define PIBWDGGEN_H_SEEN


#include "pisysdep.h"
#include PIWDG_H
#include PICMAP_H
#include PIGRAPHIC_H
#include "pigraphuc.h"
#include "psfile.h"

// Mettre dans cet ordre, sinon g++ a des problemes   
#include <vector>   

enum PIKeyModifier { PIKM_Blank = 0, PIKM_Shift = 1, PIKM_Alt = 2, PIKM_Cntl = 4 } ; 

enum PIKeyValues { PIK_Return = 1+0x2000, PIK_Enter = 2+0x2000 , 
                   PIK_BackSpace = 3+0x2000, PIK_Delete = 4+0x2000,
                   PIK_Tab = 5+0x2000, PIK_Escape = 6+0x2000, 
                   PIK_Up = 11+0x2000, PIK_Down = 12+0x2000, 
                   PIK_Right = 13+0x2000, PIK_Left = 14+0x2000,
                   PIK_Previous = 21+0x2000, PIK_Next = 22+0x2000  } ; 


enum PIPointer { PI_ArrowPointer = 1, PI_CrossPointer = 2, 
                 PI_HandPointer = 3, PI_TDLRArrowPointer = 4 };


class PIBaseWdgGen : public PIWdg
{
public:
  enum {ClassId = 5000};

// Les methodes ...

                     PIBaseWdgGen(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIBaseWdgGen();

  virtual long       kind() {return ClassId; }

//  Activation des evenements
  virtual void       ActivatePtrCross()        = 0;
  virtual void       ActivateButton(int bid)   = 0;
  virtual void       ActivateMove(int bid)     = 0;
  virtual void       ActivateKeyboard()        = 0;

//  Divers : couleur de fond, Effacement fenetre,  forme de la souris
  virtual void       SetBackgroundColor(PIColors col=PI_White)               = 0;
  virtual void       EraseWindow(int x0=0, int y0=0, int dx=0, int dy=0)     = 0;
  virtual void       SelPointerShape(PIPointer ptr=PI_ArrowPointer)          = 0;
  virtual PIColors   GetBackgroundColor()                                    = 0;
  virtual PIPointer  GetPointerShape()                                       = 0;
  virtual void       AssignKeyboard()                                        = 0;

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void       Refresh();

//  Fonctions qui doivent contenir le dessin du contenu du widget lui-meme
  virtual void       Draw(PIGraphic* g);
  virtual void       Draw(PIGraphic* g, int x0, int y0, int dx, int dy);
  
// Traitement des evenements   
  virtual void       Resize();
  virtual void       Enter();
  virtual void       Leave();  
  virtual void       But1Press(int x, int y);  
  virtual void       But1Release(int x, int y); 
  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       But3Press(int x, int y);
  virtual void       But3Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  virtual void       Ptr3Move(int x, int y);
  virtual void       Keyboard(int key, PIKeyModifier kmod);

// PostScript output
  virtual void       PSPrint(PSFile* psf, int ofx = 0, int ofy = 0);

// ------ Gestion des Drawers  ------
  friend class PIDrawer;
          void       SetDefaultDrawRectangle(PIGrCoord x1, PIGrCoord y1, 
                                             PIGrCoord x2, PIGrCoord y2, bool psz=true); 
          void       SetDefaultDrawerLimits(float xmin, float xmax, float ymin, float ymax,
                                            int axrl=kAxeDirSame, int ayud=kAxeDirSame); 
          int        AddDrawer(PIDrawer* drw, PIGrCoord x1, PIGrCoord y1, 
                               PIGrCoord x2, PIGrCoord y2, 
                               bool psz=true, bool clip=true, bool ad=false);
          int        AddDrawer(PIDrawer* drw, bool autolim=false, bool clip=true, bool ad=false);
          void       MoveResizeDrawer(int id, PIGrCoord x1, PIGrCoord y1, 
                                      PIGrCoord x2, PIGrCoord y2, bool psz=true);
          void       RemoveDrawer(int id);       // Ote un drawer de la liste
          void       DeleteDrawers();            // Ote et detruit tous les drawers
// Acces aux drawers 
          int        NbDrawers();
          PIDrawer*  GetDrawerId(int id);   
          PIDrawer*  GetDrawer(int n);   

//  Trace des Drawers ...          
  virtual void       CallDrawers(PIGraphicGen* g, int x0=0, int y0=0, int dx=0, int dy=0); 
  virtual void       CallDrawer(int id);

// Devrait etre protected - mis ici a cause de cxx  11/07/97  Reza
  struct BWDrwId { int id; PIGrCoord x1, y1, x2, y2; bool autoszp, autolim, elastic, clip, ad;  PIDrawer* drw; };

  virtual PIGraphic*  WindowGraphic();

// -------------- Variables membre protegees -------------------
protected:
  PIGraphicWin* mWGrC;  // PIGraphic (Contexte graphique) associe a la fenetre
  bool mAdfg;           // Pour la gestion de DeleteDrawers() quand appele par delete de PIBaseWdg
  int mDrwId;           // Compteur pour DrawerId
  vector<BWDrwId> mDrwList;
//  Definition de la zone de trace et limites UC des drawers par defaut  
  PIGrCoord mDrX1, mDrY1,  mDrX2,  mDrY2;  
  bool mDrElastic;   // true --> Coord en fraction de la taille 
  float mDrXmin, mDrXmax, mDrYmin, mDrYmax;   // Limites par defaut - UC
  int  mDXdir, mDYdir;                        // Sens des axes par defaut

};


#endif /* PIBWDGGEN_H_SEEN */

