/* Fonctions interface XWindow pour affichage d'images */
/*                  Reza   05/95                       */

/*                  LAL (Orsay) / IN2P3-CNRS           */

#include <stdlib.h>
#include <stdio.h>

#include "pipixmapgen.h"

// Methodes de la classe PIPixMap  :

/* --Methode-- */
PIPixmapGen::PIPixmapGen(PIContainerGen  *par, char *nom,
                     int sx, int sy, int px, int py) :
PIBaseWdg(par, nom, sx, sy, px, py)
{
pixmap = NULL;
nx = ny = 0;
ofx = ofy = 0;
mPpos[0] = mPpos[0] = 0;
cmap = new PIColorMap(CMAP_GREY32);
ActivateButton(1);
}


/* --Methode-- */
PIPixmapGen::~PIPixmapGen()
{
delete cmap;
}

/* --Methode-- */
void PIPixmapGen::SetPixmap(unsigned char *pix, int sx, int sy, bool refr, int ox, int oy)
{
pixmap = pix; 
if (pixmap)
  {
  if (sx < 0)  sx = 0;
  if (sy < 0)  sy = 0;
  if (ox < 0)  ox = 0;
  if (oy < 0)  oy = 0;
  nx = sx; ny = sy;
  ofx = ox;  ofy = oy;
  }
else { ofx = ofy = nx = ny = 0; }
if (refr) Refresh();   
}


/* --Methode-- */
void PIPixmapGen::SetColMap(CMapId cmapid, bool refr)
{
if (!cmap || (cmap->Type() != cmapid) || (cmapid == CMAP_OTHER) ) {  
  if (cmap) delete cmap;
  cmap = new PIColorMap(cmapid);
}
if (refr)  Refresh();  
}


/* --Methode-- */
void  PIPixmapGen::But1Press(int x, int y)
{
mPpos[0] = x;  mPpos[1] = y;  
if (Msg())  Send(Msg(), PIMsg_Click, mPpos);
return;
}



// Fin des methodes de la classe 


