#ifndef PIGRAPHICUC_H_SEEN
#define PIGRAPHICUC_H_SEEN

#include "pisysdep.h"
#include "pigraphgen.h"

enum {
  kAxeDirSame     = 0,
  kAxeDirLtoR     = 1,
  kAxeDirRtoL     = 2,
  kAxeDirDownUp   = 4,
  kAxeDirUpDown   = 8,
  kAxeDirAuto     = 255
};

class PIGraphicUC : public PIGraphicGen
{
public:
                     PIGraphicUC(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual           ~PIGraphicUC();

  virtual int        kind();

//  Espace des coordonnees
  virtual void       GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax);

//  Definition des coordonnees utilisateur
  virtual void       SetUCS(float xmin, float xmax, float ymin, float ymax,
                            int axrl=kAxeDirSame, int ayud=kAxeDirSame);     

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawString(PIGrCoord x, PIGrCoord y, char* s, int pos = 0);
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, char* s, int pos = 0);
  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2);
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n);  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n);  
  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0);
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n);
  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap);

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black);
  virtual void       SelBackground(PIColors col=PI_White);
  virtual void       SelForeground(PIColorMap& cmap, int cid);
  virtual void       SelBackground(PIColorMap& cmap, int cid);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);
  virtual void       SelLine(PILineAtt att=PI_NormalLine);
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker);

//  Fonctions specifiques a PIGraphicUC :
  virtual void       SelFontSz(PIGrCoord sz, PIFontAtt att=PI_RomanFont);
  virtual void       SelMarkerSz(PIGrCoord msz, PIMarker mrk=PI_DotMarker);

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       ClearClipRectangle();

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PIFontAtt  GetFontAtt();
  virtual int        GetFontSize();
  virtual PILineAtt  GetLineAtt();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();

  virtual int        GetFontHeight(int& asc, int& desc);
  virtual PIGrCoord  CalcStringWidth(char const* s);

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

//  Transformation des ccordonnees
  virtual void       UC2GrC(float x, float y, float& xpix, float& ypix);
  virtual void       GrC2UC(float xpix, float ypix, float& x, float& y);
  virtual void       DUC2GrC(float dx, float dy, float& dxpix, float& dypix);
  virtual void       DGrC2UC(float dxpix, float dypix, float& dx, float& dy);

  void   NoClip() {clip = false; }
  void   Clip() {clip = true; }
  inline PIGraphicGen*  BaseGraphic() { return(mGrC); }

protected:

  PIGraphicGen* mGrC;

  float xMin, xMax, yMin, yMax; // Valeurs en unites user
  float xOrg, yOrg;             // Position en pixels de (0.0, 0.0)
  float xScale, yScale;         // Pixels par unites graphiques
  float xW0, yW0, xWd, yWd;        // Origine/largeur ds la fenetre de trace
  bool   aXdir, aYdir;           // Sens des axes horiz, vertical 
  bool   clip;
};


#endif
