#include "generalfit.h"
#include "piscdrawwdg.h"

PIScDrawWdg::PIScDrawWdg(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
:PIBaseWdg(par, nom, sx, sy, px, py)
{
  mBDrw = new PIElDrawer;
  SetLimits(-1.,1.,-1.,1.,kAxeDirLtoR,kAxeDirDownUp);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);  
  FreeLimits();
  xEndDrag = yEndDrag = xBegDrag = yBegDrag = 0;
  SetDefaultDrawRectangle(0.12, 0.12, 0.88, 0.88, true);
  AddDrawer(mBDrw, true, false, false);
  
  mTrlb = mTxw = NULL;
  mTrW = NULL;
  SetTextWin(NULL);
  ActivateButton(1);    // Pour pouvoir activer la fenetre et coordonnees
  ActivateMove(1);      //    "         "         "        "
  ActivateButton(2);
  ActivateMove(2);

}

PIScDrawWdg::~PIScDrawWdg()
{
  delete mBDrw;
  if (mTrW)  delete mTrW;
}


void
PIScDrawWdg::SetLimits(float xmin, float xmax, float ymin, float ymax,
                       int axrl, int ayud, bool tmp)
{
  if (xmax <= xmin || ymax <= ymin)
    return; // $CHECK$ exception ?
  SetDefaultDrawerLimits(xmin, xmax, ymin, ymax, axrl, ayud);
  mPPos[0] = 0.5*(XMin()+XMax());
  mPPos[1] = 0.5*(YMin()+YMax());
  if (!tmp) {
    xMinS = xmin;
    xMaxS = xmax;
    yMinS = ymin;
    yMaxS = ymax;
  }
}
  

int 
PIScDrawWdg::AddScDrawer(PIDrawer* d, bool ad)
{
  return(AddDrawer(d, true, ad));
}


void
PIScDrawWdg::SetTextWin(PILabel * tw, bool trw, int tx, int ty)
{
mTxw = tw;
if (trw)
  {
  if (mTrW)  mTrW->SetSize(tx, ty);
  else
    {
    mTrW = new PIWindow(this, "Point", PIWK_transient, tx, ty, 0, 0);
    mTrW->SetAutoDelChilds(true);
    mTrlb = new PILabel(mTrW, "PointCoord", tx, ty, 0, 0);
    mTrlb->SetBinding(PIBK_fixed,PIBK_fixed, PIBK_fixed,PIBK_fixed);
    }
  }
else
  if (mTrW) { delete mTrW; mTrW = NULL;  mTrlb = NULL; }

return;
}

void
PIScDrawWdg::Draw(PIGraphic* g)
{
  EraseWindow();
  if (! LimitsFixed() ) {  //  On met a jour les limites a partir du premier Drawer
    PIDrawer* drw = GetDrawer(1);
    if (drw != NULL)   {    
      drw->UpdateSize();
      SetLimits(drw->XMin(), drw->XMax(), drw->YMin(), drw->YMax());
      }
    else SetLimits(0., 1., 0., 1.);
    }
}

void
PIScDrawWdg::Draw(PIGraphic* g, int x0, int y0, int dx, int dy)
{
//  EraseWindow();
  if (! LimitsFixed() ) {  //  On met a jour les limites a partir du premier Drawer
    PIDrawer* drw = GetDrawer(1);
    if (drw != NULL)   {    
      drw->UpdateSize();
      SetLimits(drw->XMin(), drw->XMax(), drw->YMin(), drw->YMax());
      }
    else SetLimits(0., 1., 0., 1.);
    }
}


// Gestion affichage coordonnees du point 

string   PIScDrawWdg::GetClickText(float x, float y) 
// Donne le texte a afficher pour position x,y  
{
  char buff[128];
  sprintf(buff, "X= %g  Y= %g",  x, y);
  return((string)buff);
}

void
PIScDrawWdg::But1Press(int x, int y)
{
  if (UpdateText(x, y))
     {
     if (mTrW)
       { 
       int tpx, tpy;
       GetScreenPos(tpx, tpy);       
       tpy -= (mTrW->YSize()+5);
       if (tpy < 0)  tpy = 0;
       mTrW->SetPos(tpx, tpy);
       mTrW->Show();
       }
     SelPointerShape(PI_CrossPointer);
     }
  Send(Msg(), PIMsg_Active);

}

void
PIScDrawWdg::Ptr1Move(int x, int y)
{
  UpdateText(x, y);
}

void
PIScDrawWdg::But1Release(int x, int y)
{
  if (UpdateText(x, y)) 
    SelPointerShape(PI_ArrowPointer);
  if (mTrW)  mTrW->Hide();
}

bool
PIScDrawWdg::UpdateText(int xp, int yp)
{

  float dx, dy;
  mBDrw->GetGraphicUC()->GrC2UC(xp, yp, dx, dy); 
  mPPos[0] = dx;  mPPos[1] = dy; 
  if ((mTxw == NULL) && (mTrlb == NULL)) return(false);
  
  string ctxt =  GetClickText(dx, dy);

  if (mTxw)
    mTxw->SetLabel(ctxt);
  if (mTrlb)
    mTrlb->SetLabel(ctxt);
  return(true);

}

// Gestion du zoom
void
PIScDrawWdg::But2Press(int x, int y)
{
  xEndDrag = xBegDrag = x;
  yEndDrag = yBegDrag = y;
  cForCol = mWGrC->GetForeground();
  cGOmod  = mWGrC->GetGOMode();
  cPointer = GetPointerShape();
  cLatt = mWGrC->GetLineAtt();
  SelPointerShape(PI_CrossPointer);
  mWGrC->SelForeground(PI_Magenta);
  mWGrC->SelGOMode(PI_GOXOR);
  mWGrC->SelLine(PI_ThinLine);
  Send(Msg(), PIMsg_Active);
}

void
PIScDrawWdg::But2Release(int /*x*/, int /*y*/)
{

  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);

  mWGrC->SelForeground(cForCol);
  mWGrC->SelGOMode(cGOmod);
  SelPointerShape(cPointer); 
  mWGrC->SelLine(cLatt); 
  
  if (xBegDrag == xEndDrag || yBegDrag == yEndDrag)
    SetLimits(xMinS, xMaxS, yMinS, yMaxS, kAxeDirSame, kAxeDirSame );
  else {
    float xl,yl,xh,yh;
    mBDrw->GetGraphicUC()->GrC2UC(xBegDrag, yBegDrag, xl, yl);
    mBDrw->GetGraphicUC()->GrC2UC(xEndDrag, yEndDrag, xh, yh);
    if (xl > xh) swap(xl, xh);
    if (yl > yh) swap(yl, yh);
    SetLimits(xl,xh,yl,yh, kAxeDirSame, kAxeDirSame, true);
  }
  
  Refresh();
}

void
PIScDrawWdg::Ptr2Move(int x, int y)
{
  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
  xEndDrag = x;
  yEndDrag = y;
  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
}


//================================================================
// PIFuncDrawer
//================================================================

PIFuncDrawer::PIFuncDrawer(PIFuncDrawer::FUNC f)
: mFunc(f)
{}

PIFuncDrawer::~PIFuncDrawer()
{
}

void
PIFuncDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float/*ymin*/, float/*xmax*/, float/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  float xMax = x2;
  float xMin = x1;
  float yMax = y2;
  float yMin = y1;
  float xStep = (xMax - xMin)/100;
  float xOld = xMin;
  float yOld = mFunc(xMin);
  for (float x = xMin+xStep; x<xMax; x+=xStep) {
    double y = mFunc(x);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

//================================================================
// PIGFFDrawer
//================================================================

PIGFFDrawer::PIGFFDrawer(GeneralFunction* f)
: mFunc(f), mNParms(f->NPar()), mParms(new double[mNParms])
{
  ASSERT(f->NVar() == 1);
}

PIGFFDrawer::~PIGFFDrawer()
{
  delete[] mParms;
}

void
PIGFFDrawer::SetParms(double const* p)
{
  for (int i=0; i<mNParms; i++)
    mParms[i] = p[i];
}


void
PIGFFDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float/*ymin*/, float/*xmax*/, float/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  float xMax = x2;
  float xMin = x1;
  float yMax = y2;
  float yMin = y1;
  float xStep = (xMax - xMin)/100;
  float xOld = xMin;
  float yOld = 0;
//  float yOld = f->Value(&xMin, mParms);
  for (float x = xMin+xStep; x<xMax; x+=xStep) {
   float y = 0; // $CHECK$
//    float y = f->Value(&x, mParms);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

