// This may look like C code, but it is really -*- C++ -*-
// Outils de manipulation des PIImage  R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdlib.h>

#include "piimgtools.h"
#include PISTDWDG_H
#include PIOPTMENU_H
#include "piimage.h"

// ------ Menu des options et fenetre de dialogue pour changement de LUT --------


/* --Methode-- */
PIImgLutWind::PIImgLutWind(PIApplication* par)
: PIWindow((PIMsgHandler*)par, "PIImg-ChangeLut", PIWK_dialog, 240, 240, 150, 150)
{

mLab[0] = new PILabel(this, "MinPixel", 60, 35, 30, 20); 
mLab[1] = new PILabel(this, "MaxPixel", 60, 35, 30, 65); 

mLab[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mLab[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

mText[0] = new PIText(this, "MinVal", 100, 35, 110, 20);
mText[0]->SetText("1");
mText[1] = new PIText(this, "MaxVal", 100, 35, 110, 65);
mText[1]->SetText("32000");
mText[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mText[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

mOlb[0] = new PILabel(this, "LutType", 60, 30, 30, 110); 
mOlb[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mOpt[0] = new PIOptMenu(this, "imglut-opt-1", 100, 30, 110, 110);
mOpt[0]->AppendItem("Linear", 1100);
mOpt[0]->AppendItem("Log.", 1101);
mOpt[0]->SetValue(1100);
mOpt[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

mOlb[1] = new PILabel(this, "AutoLut", 60, 30, 30, 140); 
mOlb[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mOpt[1] = new PIOptMenu(this, "imglut-opt-2", 100, 30, 110, 140);
mOpt[1]->AppendItem("+3 Sig", 1203);
mOpt[1]->AppendItem("+2 Sig", 1202);
mOpt[1]->AppendItem("+1 Sig", 1201);
mOpt[1]->AppendItem("NoAuto", 1200);
mOpt[1]->AppendItem("-1 Sig", 1199);
mOpt[1]->AppendItem("-2 Sig", 1198);
mOpt[1]->AppendItem("-3 Sig", 1197);
mOpt[1]->SetValue(1202);
mOpt[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

mBut[0] = new PIButton(this, "Apply", 1500, 70, 30, 30, 190);
mBut[1] = new PIButton(this, "Dismiss", 1600, 70, 30, 140, 190);
mBut[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mBut[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
}

/* --Methode-- */
PIImgLutWind::~PIImgLutWind()
{
for(int i=0; i<2; i++)
  {
  delete mLab[i];
  delete mBut[i];
  delete mText[i];
  delete mOpt[i];
  delete mOlb[i];
  }
}

/* --Methode-- */
void PIImgLutWind::Show()
{
char buff[32];
PIImage *mpii;
PIWindow::Show();
mpii = PIImage::CurrentPIImage();
if (mpii == NULL)  return;
sprintf(buff,"%g", (mpii->Lut())->Min());
mText[0]->SetText(buff);
sprintf(buff,"%g", (mpii->Lut())->Max());
mText[1]->SetText(buff);
if ( (mpii->Lut())->Type() == kLutType_Lin ) 
  mOpt[0]->SetValue(1100);
else mOpt[0]->SetValue(1101);
string s("NoAuto");
mOpt[1]->SetValueStr(s);
return;
}


/* --Methode-- */
void PIImgLutWind::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
float min, max;
int lauto, typ;
int typlut[2] = {kLutType_Lin, kLutType_Log} ; 

msg = UserMsg(msg);
switch (msg)
  {
  case 1600:
    this->Hide();
    break;
  case 1500:
    if (PIImage::CurrentPIImage() == NULL)  return;
    min = atof(mText[0]->GetText().c_str());
    max = atof(mText[1]->GetText().c_str());
    lauto = mOpt[1]->GetValue() - 1200;
    typ = mOpt[0]->GetValue() - 1100;
    if ( (typ < 0) || (typ > 1) )  typ = 0;
    (PIImage::CurrentPIImage())->SetLut(min, max, typlut[typ], lauto);
//    ((PIImage::CurrentPIImage())->Lut())->Print();
    break;
  default:
//    printf("PIImgLutWind::Process Msg %d received \n", (int)msg);
    break;
  }
}

// --------------------------------------------------------------

/* --Methode-- */
PIImgMenu::PIImgMenu(PIApplication* par) 
        : PIMenu(par->Menubar(), "ImgTools")
{
pdm[0] = new PIMenu(this, "AutoLut");
pdm[0]->AppendItem("+3 Sig", 303);
pdm[0]->AppendItem("+2 Sig", 302);
pdm[0]->AppendItem("+1 Sig", 301);
pdm[0]->AppendItem("-1 Sig", 299);
pdm[0]->AppendItem("-2 Sig", 298);
AppendPDMenu(pdm[0]);

pdm[1] = new PIMenu(this, "Zoom");
pdm[1]->AppendItem("Agr. *10", 110);
pdm[1]->AppendItem("Agr. * 8", 108);
pdm[1]->AppendItem("Agr. * 6", 106);
pdm[1]->AppendItem("Agr. * 5", 105);
pdm[1]->AppendItem("Agr. * 4", 104);
pdm[1]->AppendItem("Agr. * 3", 103);
pdm[1]->AppendItem("Agr. * 2", 102);
pdm[1]->AppendItem("* 1", 101);
pdm[1]->AppendItem("Red. / 2", 98);
pdm[1]->AppendItem("Red. / 3", 97);
pdm[1]->AppendItem("Red. / 4", 96);
pdm[1]->AppendItem("Red. / 5", 95);
pdm[1]->AppendItem("Red. / 6", 94);
pdm[1]->AppendItem("Red. / 8", 92);
pdm[1]->AppendItem("Red. /10", 90);
AppendPDMenu(pdm[1]);

pdm[2] = new PIMenu(this, "ColMap");
pdm[2]->AppendItem("Grey32", 201);
pdm[2]->AppendItem("GreyInv32", 202);
pdm[2]->AppendItem("ColRJ32", 203);
pdm[2]->AppendItem("ColBR32", 204);
pdm[2]->AppendItem("ColRV32", 205);
AppendPDMenu(pdm[2]);

AppendItem("Sz x 1", 5101);
AppendCheckItem("Show Cursor", 5102);
AppendCheckItem("Show Axes", 5103);
pdm[3] = new PIMenu(this, "Conf. Axes");
pdm[3]->AppendItem("Invert-X",  5201);
pdm[3]->AppendItem("Invert-Y",  5202);
pdm[3]->AppendItem("Exchange X-Y",  5203);
AppendPDMenu(pdm[3]);

AppendItem("Lut...", 5300);

mLW = new PIImgLutWind(par);
}

/* --Methode-- */
PIImgMenu::~PIImgMenu()
{
int i;
for(i=0; i<4; i++)  delete pdm[i];
delete mLW;
}

/* --Methode-- */
void PIImgMenu::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* data)
{
CMapId cmap[5] = { CMAP_GREY32, CMAP_GREYINV32, CMAP_COLRJ32, 
                   CMAP_COLBR32, CMAP_COLRV32 } ;
if (PIImage::CurrentPIImage() == NULL)  return;
msg = UserMsg(msg);
if ((msg <= 110) && (msg >= 90))  // Zoom
  PIImage::CurrentPIImage()->SetZoom((int)(msg-100));
else if ((msg > 200) && (msg < 206)) // Changement de couleur 
  PIImage::CurrentPIImage()->SetColMap(cmap[msg-201]);
else if ((msg > 290) && (msg < 310))
  PIImage::CurrentPIImage()->SetLut( PIImage::CurrentPIImage()->Lut()->Min(), PIImage::CurrentPIImage()->Lut()->Max(), 
                                 kLutType_Lin, msg-300);
else if ((msg > 500) && (msg < 505)) {
  PIImage* mpii = PIImage::CurrentPIImage();
  float x1 = (mpii->Lut())->Min(); 
  float x2 = (mpii->Lut())->Max(); 
  float dx = 0.1*(x2-x1);
  int typ  = (mpii->Lut())->Type();
  switch (msg)
    {
    case 501 :
      mpii->SetLut(x1-dx, x2, typ);
      break;
    case 502 :
      mpii->SetLut(x1+dx, x2, typ);
      break;
    case 503 :
      mpii->SetLut(x1, x2-dx, typ);
      break;
    case 504 :
      mpii->SetLut(x1, x2+dx, typ);
      break;
    default :
      break;
    }

}
else {
  PIImage* mpii = PIImage::CurrentPIImage();
  switch (msg)
    {
  case 5101 :
    mpii->SetOffset(0, 0, false);
    mpii->SetZoom(1, true);
    break;

  case 5102 :
    if (*((bool *)data))  mpii->ShowCursor(true);
    else  mpii->ShowCursor(false);
    break;

  case 5103 :
    if (*((bool *)data))  mpii->SetDrawAxesFlags();
    else  mpii->SetDrawAxesFlags(kAxesNone);
    break;

  case 5201 :
    mpii->ChangeAxesConfiguration(true, false, false);
    break;
  case 5202 :
    mpii->ChangeAxesConfiguration(false, true, false);
    break;
  case 5203 :
    mpii->ChangeAxesConfiguration(false, false, true);
    break;

  case 5300 :
    mLW->Show();
    break;

  default :
    break;
  }
}
return;
}
