#include<stdio.h>

#include <Xm/Xm.h>
#include <Xm/PushB.h>

#include "pisysdep.h"
#include "pioptmenux.h"
#include "piapplx.h"


/************* PIOptionMenuX ************/
static int rsx=0, rsy=0;

/* Nouvelle-Fonction */
static void mouse_handler_optmenux (Widget wdgp, XtPointer ud, 
                                    XEvent* evt, Boolean* cont){
*cont = FALSE ; 
// printf("---  mouse_handler_optmenux ud = %lx ----- EvtType=%d (%d) \n", (long)ud, evt->type, Expose );
if ( evt->type == Expose ) {
  PIOptMenuX* opm = (PIOptMenuX*) ud;
  Display* dis = PIXDisplay();
  Window w = XtWindow(opm->XtWdg()) ;
  XFillRectangle(dis, w, opm->myGC(), rsy, (opm->YSize()-rsy)/2, rsy, rsy); 
  }
else if ( (evt->type == ButtonPress) && (evt->xbutton.button == 1))  { 
  PIXSetLastEventTimeSerial(evt->xbutton.time,  evt->xbutton.serial);
  PIOptMenuX* opm = (PIOptMenuX*) ud;
  opm->Menu()->Show(opm, rsy/2, opm->YSize());
  }
}


/* --Methode-- */
PIOptMenuX::PIOptMenuX(PIContainerGen* par, const char* nom, int sx, int sy, int px, int py)
: PIOptMenuGen(par, nom, sx, sy, px, py)
{
mSmsg = 0;
mStext = "";

if (rsx == 0) { 
  PIApplicationPrefCompSize(rsx, rsy);
  rsy = rsy/3-2; 
  }
Arg warg[10];
int n = 0;
CreateXtWdg(nom, xmPushButtonWidgetClass, NULL, sx, sy, px, py);
XtSetArg(warg[n],XmNhighlightThickness, 0);  n++;
XtSetArg(warg[n], XmNrecomputeSize, FALSE); n++;
XtSetArg(warg[n],XmNnavigationType,XmNONE);  n++;
XtSetArg(warg[n],XmNtraversalOn,FALSE);  n++;
XtSetArg(warg[n],XmNmarginLeft,rsy*3);  n++;
XtSetValues(XtWdg(), warg, n);
XtTranslations trans = XtParseTranslationTable( 
      "<Btn1Down>: \n <Btn1Up>: \n <Btn2Down>: \n <Btn2Up>: \n <Btn3Down>: \n <Btn3Up>:");
XtOverrideTranslations(XtWdg(), trans);
XtAddEventHandler( XtWdg(), ButtonPressMask|ExposureMask, FALSE, mouse_handler_optmenux, this);
mgc = 0;
char buff[128];
strncpy(buff, nom, 64);
strcat(buff,"_Menu");
mMen = new PIMenu((PIWdg*)par, buff, k_PopupMenu);
mMen->SetMsgParent(this);
Manage();
}


/* --Methode-- */
PIOptMenuX::~PIOptMenuX()
{
delete mMen;
}

/* --Methode-- */
void PIOptMenuX::FinishCreate()
{
PIWdgX::FinishCreate();
// printf("PIOptMenuX::FinishCreate()/DBG  %s \n", Nom().c_str());
if (mSmsg == 0)  SetValue(mMen->ItemMsg(0)); 
}

/* --Methode-- */
void PIOptMenuX::Process(PIMessage msg, PIMsgHandler* sender, void* data)
{
// printf("PIOptMenuX::Process Msg= %d Sender= %lx \n", (int)msg, (long)sender);
  // if (sender == mMen)   {    Ca peut venir d'un cascade menu !!
  SetValue(UserMsg(msg));
  ReSend(msg, this, NULL);
  //}
return;
}


/* --Methode-- */
void PIOptMenuX::SetValueStr(string & s)
{
int n;
Arg warg[2];
n=mMen->GetNumItem((char *)s.c_str());
if (n < 0)  return;  

XtSetArg(warg[0], XmNmenuHistory, mMen->GetItemWdg(n));
XtSetValues(XtWdg(), warg, 1);
mStext = s;
mSmsg  = mMen->ItemMsg(n);

SetLabel(mStext);

return;
}

/* --Methode-- */
void PIOptMenuX::SetValue(PIMessage msg)
{
int n;
Arg warg[2];

n=mMen->GetNumItemMsg(msg);
if (n < 0)  return;
  
XtSetArg(warg[0], XmNmenuHistory, mMen->GetItemWdg(n));
XtSetValues(XtWdg(), warg, 1);
mStext = mMen->ItemName(n);
mSmsg  = msg;
SetLabel(mStext);
return;
}

/* --Methode-- */
void PIOptMenuX::SetLabel(string const& lab)
{
XmString xmstr;
xmstr = XmStringLtoRCreate((char *)lab.c_str(), XmSTRING_DEFAULT_CHARSET);
int n=0;
Arg warg[2];

XtSetArg(warg[n], XmNlabelString, xmstr); n++;
XtSetValues(XtWdg(), warg, n);
XmStringFree(xmstr);
return;
}

/* --Methode-- */
void PIOptMenuX::createmygc()
{
unsigned long fgc = 0;
Arg warg[2];
XtSetArg(warg[0], XmNforeground, &fgc);
XtGetValues(XtWdg(), warg, 1);
mgc = XCreateGC(PIXDisplay(), XtWindow(XtWdg()), 0, NULL); 
XSetForeground(PIXDisplay(), mgc, fgc);
}
