#include <stdlib.h>
#include <stdio.h>


#include <exception>
#include <string>

using namespace std;

#ifdef USEVECSTL
#include <vector>
#endif

class MyException : public exception
{
public:
  MyException(const char * msg) { _msg = msg; }
//  ~MyException() { }
  string Msg() { return(_msg); }
private:
string _msg;
};

template<class T> class Vector
{
private:
#ifdef USEVECSTL
vector<T> data;
#else  
  T* data;
#endif
  int size;
  
public:
  Vector (int s, bool fg=false);
  ~Vector ();

  inline T  elem (int pos) const { return data[pos]; }
  inline T& elem (int pos) { return data[pos]; }

  inline T  elemCk (int pos) const
    { if ((pos < 0) || (pos >= size)) throw MyException("Vector<T> Out of bound");
       return data[pos]; }

  inline T& elemCk (int pos) 
    { if ((pos < 0) || (pos >= size)) throw MyException("Vector<T> Out of bound");
       return data[pos]; }

  inline int getSize () const { return size; }

  // Addition et multiplication en utilisant elem()
  Vector<T> * Add(Vector<T> & v1, Vector<T> & v2);
  Vector<T> * Mult(Vector<T> & v1, Vector<T> & v2);
  // Addition et multiplication en utilisant elemCk()
  Vector<T> * AddCk(Vector<T> & v1, Vector<T> & v2);
  Vector<T> * MultCk(Vector<T> & v1, Vector<T> & v2);
  // Addition et multiplication en utilisant des pointeurs
  Vector<T> * AddP(Vector<T> & v1, Vector<T> & v2);
  Vector<T> * MultP(Vector<T> & v1, Vector<T> & v2);
  // Addition et multiplication en utilisant des pointeurs et p[i]
  Vector<T> * AddPE(Vector<T> & v1, Vector<T> & v2);
  Vector<T> * MultPE(Vector<T> & v1, Vector<T> & v2);
};

template<class T> Vector<T>::Vector (int s, bool fg)
{
  int k;
  if (s < 1) s = 1;
  size = s;
#ifdef USEVECSTL
  for(k=0; k<s; k++) data.push_back((T)0);
#else
  data = new T[size];
  if (!fg)  return;

  T * p = data;
  for(k=0; k<s; k++) *p++ = (T)0;
#endif
}

template<class T> Vector<T>::~Vector()
{
size = 0;
#ifdef USEVECSTL
#else
delete[] data;
#endif
}



template<class T> Vector<T> * Vector<T>::Add(Vector<T> &v1, Vector<T> &v2)
{
int i;

for (i = 0; i < size; i++)
  elem(i) = v1.elem(i)+v2.elem(i);
return (this);
}

template<class T> Vector<T> * Vector<T>::Mult(Vector<T> &v1, Vector<T> &v2)
{
int i;

for (i = 0; i < size; i++)
  elem(i) = v1.elem(i)*v2.elem(i);
return (this);
}


template<class T> Vector<T> * Vector<T>::AddCk(Vector<T> &v1, Vector<T> &v2)
{
int i;

for (i = 0; i < size; i++)
  elemCk(i) = v1.elemCk(i)+v2.elemCk(i);
return (this);
}

template<class T> Vector<T> * Vector<T>::MultCk(Vector<T> &v1, Vector<T> &v2)
{
int i;

for (i = 0; i < size; i++)
  elemCk(i) = v1.elemCk(i)*v2.elemCk(i);
return (this);
}

template<class T> Vector<T> * Vector<T>::AddP(Vector<T> &v1, Vector<T> &v2)
{
int i;
#ifdef USEVECSTL
vector<T>::iterator p = data.begin();
vector<T>::iterator p1 = v1.data.begin();
vector<T>::iterator p2 = v2.data.begin();
#else
T * p = data;
T * p1 = v1.data;
T * p2 = v2.data;
#endif
for (i = 0; i < size; i++) *p++ = *p1++ + *p2++;
return (this);
}

template<class T> Vector<T> * Vector<T>::MultP(Vector<T> &v1, Vector<T> &v2)
{
int i;
#ifdef USEVECSTL
vector<T>::iterator p = data.begin();
vector<T>::iterator p1 = v1.data.begin();
vector<T>::iterator p2 = v2.data.begin();
#else
T * p = data;
T * p1 = v1.data;
T * p2 = v2.data;
#endif
for (i = 0; i < size; i++) *p++ = *p1++ * *p2++;
return (this);
}
template<class T> Vector<T> * Vector<T>::AddPE(Vector<T> &v1, Vector<T> &v2)
{
int i;
#ifdef USEVECSTL
vector<T>::iterator p = data.begin();
vector<T>::iterator p1 = v1.data.begin();
vector<T>::iterator p2 = v2.data.begin();
#else
T * p = data;
T * p1 = v1.data;
T * p2 = v2.data;
#endif
for (i = 0; i < size; i++) p[i] = p1[i] + p2[i];
return (this);
}

template<class T> Vector<T> * Vector<T>::MultPE(Vector<T> &v1, Vector<T> &v2)
{
int i;
#ifdef USEVECSTL
vector<T>::iterator p = data.begin();
vector<T>::iterator p1 = v1.data.begin();
vector<T>::iterator p2 = v2.data.begin();
#else
T * p = data;
T * p1 = v1.data;
T * p2 = v2.data;
#endif
for (i = 0; i < size; i++) p[i] = p1[i] * p2[i];
return (this);
}


extern "C" void InitTim();
extern "C" void PrtTim(char *Comm);

/* --------------------------------------------------------------------- */
/* --------------------------- Main Program ---------------------------- */
/* --------------------------------------------------------------------- */

int main (int narg, char *arg[])
{

int pos, N, M, OPT, OPE, i;


if (narg < 2) { 
  printf("\n Usage: vectorC++ Type(=1,2,3 Int,Float,Double) Ope(=1/2/3/4/5/6/7/8) [N [M] ] \n");
  printf("Ope: 1=Create/Delete 2=1+FillVect \n");
  printf("Ope: 3=AddP   4=Mult P  (Using pointers) \n");
  printf("Ope: 5=AddPE  6=MultPE  (Using pointers p[]) \n");
  printf("Ope: 7=Add    8=Mul t   (Using elem()) \n");
  printf("Ope: 9=AddCk  10=MultCk (Using elemCk() - with bound checking) \n");
  printf("N: Number of operations (def= 100) \n");
  printf("M: Vector size (def= 50000) \n\n");
  exit(0);
}

 InitTim();

OPT = 1; OPE = 1;
if (narg > 1)  OPT = atoi(arg[1]);
if ( (OPT < 1) || (OPT > 3) )  OPT = 1;

if (narg > 2)  OPE = atoi(arg[2]);
if ( (OPE < 1) || (OPE > 10) )  OPE = 1;

N = 100;
if (narg > 3)  N = atoi(arg[3]);
if (N < 1) N = 1;
if (N > 100000) N = 100000;
M = 50000;
if (narg > 4)  M = atoi(arg[4]);
if (M < 1000) M = 1000;
if (M > 100000000) M = 100000000;


printf(" VectorC++ TestSpeed Typ=%d Ope=%d N=%d VSz=%d\n", OPT, OPE, N,M);
#ifdef USEVECSTL
printf(" ---------- Using STL vector<T> inside Vector<T> ------------ \n");
#endif

if (OPE < 3) { /* Test creation / destruction */
int fg = OPE-1;
bool fgf = (fg != 0) ? true : false;
printf("\n\n Test new/delete Vector<T> - fg= %d ( <> 0 ---> FillVec) \n", fg); 
 switch (OPT)
   {
   case 1 :
     {
       Vector<int> * v;
       printf("Test %d new/delete Vector<int>[%d] \n",N,M);
       for(i=0; i<N; i++) {
	 v = new Vector<int>(M, fgf);
	 delete v;
       }
     }
     break;
   case 2 :
     {
       Vector<float> * v;
       printf("Test %d  new/delete Vector<float>[%d] \n",N,M);
       for(i=0; i<N; i++) {
	 v = new Vector<float>(M, fgf);
	 delete v;
       }
     }
     break;
   case 3 :
     {
       Vector<double> * v;
       printf("Test %d  new/delete Vector<double>[%d] \n",N,M);
       for(i=0; i<N; i++) {
	 v = new Vector<double>(M, fgf);
	 delete v;
       }
     }
     break;
  }
  PrtTim("Fin New/Delete ");
  printf(" .......... Fin de VectorC++ ........... \n");
  return (0);
}

// ---------- Test Addition, Multiplication -------------

switch (OPT)
  {
  case 1 :
    {
    printf("\n\n Test %d operations Vector<int>[%d] \n",N,M);

    Vector<int> *v1,*v2,*v3;
    v1 = new Vector<int>(M);
    v2 = new Vector<int>(M);
    v3 = new Vector<int>(M);
    PrtTim("Fin_Creation ");

    for(pos=0; pos<M; pos++)  
      { v1->elem(pos) = random()%1000;
      v2->elem(pos) = random()%5000; }

    PrtTim("Fin remplissage ");

    if (OPE == 3) {
      for(pos=0; pos<N; pos++)  
        v3->AddP(*v1, *v2);  
      PrtTim("Fin Addition AddP");
    }
    else if (OPE == 4) {
      for(pos=0; pos<N; pos++)  
        v3->MultP(*v1, *v2);  
      PrtTim("Fin Multiplication MultP");
    }
    else if (OPE == 5) {
      for(pos=0; pos<N; pos++)  
        v3->AddPE(*v1, *v2);  
      PrtTim("Fin Addition AddPE p[i]");
    }
    else if (OPE == 6) {
      for(pos=0; pos<N; pos++)  
        v3->MultPE(*v1, *v2);  
      PrtTim("Fin Multiplication MultPE p[i]");
    }
    else if (OPE == 7) {
      for(pos=0; pos<N; pos++)  
        v3->Add(*v1, *v2);  
      PrtTim("Fin Addition Add");
    }
    else if (OPE == 8) {
      for(pos=0; pos<N; pos++)  
        v3->Mult(*v1, *v2);  
      PrtTim("Fin Multiplication Mult");
    }
    else if (OPE == 9) {
      for(pos=0; pos<N; pos++)  
        v3->AddCk(*v1, *v2);  
      PrtTim("Fin Addition AddCk");
    }
    else if (OPE == 10) {
      for(pos=0; pos<N; pos++)  
        v3->MultCk(*v1, *v2);  
      PrtTim("Fin Multiplication MultCk");
    }

    printf("Result[1.2] I1= %d %d  I2= %d %d  I3= %d %d \n",
          v1->elem(1),v1->elem(2), v2->elem(1),v2->elem(2),
          v3->elem(1),v3->elem(2));
    printf("ResAdd[991-2] I1= %d %d  I2= %d %d  I3= %d %d \n",
          v1->elem(991),v1->elem(992), v2->elem(991),v2->elem(992),
          v3->elem(991),v3->elem(992));
    }
    break;

  case 2 :
    {
    printf("\n\n Test %d operations Vector<float>[%d] \n",N,M);
    Vector<float> *v1,*v2,*v3;
    v1 = new Vector<float>(M);
    v2 = new Vector<float>(M);
    v3 = new Vector<float>(M);
    PrtTim("Fin_Creation ");

    for(pos=0; pos<M; pos++)  
      { v1->elem(pos) = (float)(random()%1000)/250.;
      v2->elem(pos) =  (float)(random()%5000)/250.; }

    PrtTim("Fin remplissage ");
    if (OPE == 3) {
      for(pos=0; pos<N; pos++)  
        v3->AddP(*v1, *v2);  
      PrtTim("Fin Addition AddP");
    }
    else if (OPE == 4) {
      for(pos=0; pos<N; pos++)  
        v3->MultP(*v1, *v2);  
      PrtTim("Fin Multiplication MultP");
    }
    if (OPE == 5) {
      for(pos=0; pos<N; pos++)  
        v3->AddPE(*v1, *v2);  
      PrtTim("Fin Addition AddPE p[i]");
    }
    else if (OPE == 6) {
      for(pos=0; pos<N; pos++)  
        v3->MultPE(*v1, *v2);  
      PrtTim("Fin Multiplication MultPe p[i]");
    }
    else if (OPE == 7) {
      for(pos=0; pos<N; pos++)  
        v3->Add(*v1, *v2);  
      PrtTim("Fin Addition Add");
    }
    else if (OPE == 8) {
      for(pos=0; pos<N; pos++)  
        v3->Mult(*v1, *v2);  
      PrtTim("Fin Multiplication Mult");
    }
    else if (OPE == 9) {
      for(pos=0; pos<N; pos++)  
        v3->AddCk(*v1, *v2);  
      PrtTim("Fin Addition AddCk");
    }
    else if (OPE == 10) {
      for(pos=0; pos<N; pos++)  
        v3->MultCk(*v1, *v2);  
      PrtTim("Fin Multiplication MultCk");
    }
    printf("Result[1.2] F1= %g %g  F2= %g %g  F3= %g %g \n",
          v1->elem(1),v1->elem(2), v2->elem(1),v2->elem(2),
          v3->elem(1),v3->elem(2));
    printf("Result[991-2] F1= %g %g  F2= %g %g  F3= %g %g \n",
          v1->elem(991),v1->elem(992), v2->elem(991),v2->elem(992),
          v3->elem(991),v3->elem(992));
    }
    break;

  case 3 :
    {
    printf("\n\n Test %d operations Vector<double>[%d] \n",N,M);
    Vector<double> *v1,*v2,*v3;
    v1 = new Vector<double>(M);
    v2 = new Vector<double>(M);
    v3 = new Vector<double>(M);
    PrtTim("Fin_Creation ");

    for(pos=0; pos<M; pos++)  
      { v1->elem(pos) = (double)(random()%1000)/250.;
      v2->elem(pos) =  (double)(random()%5000)/250.; }

    PrtTim("Fin remplissage ");
    if (OPE == 3) {
      for(pos=0; pos<N; pos++)  
        v3->AddP(*v1, *v2);  
      PrtTim("Fin Addition AddP");
    }
    else if (OPE == 4) {
      for(pos=0; pos<N; pos++)  
        v3->MultP(*v1, *v2);  
      PrtTim("Fin Multiplication MultP");
    }
    else if (OPE == 5) {
      for(pos=0; pos<N; pos++)  
        v3->AddPE(*v1, *v2);  
      PrtTim("Fin Addition AddPE p[i]");
    }
    else if (OPE == 6) {
      for(pos=0; pos<N; pos++)  
        v3->MultPE(*v1, *v2);  
      PrtTim("Fin Multiplication MultPE p[i]");
    }
    else if (OPE == 7) {
      for(pos=0; pos<N; pos++)  
        v3->Add(*v1, *v2);  
      PrtTim("Fin Addition Add");
    }
    else if (OPE == 8) {
      for(pos=0; pos<N; pos++)  
        v3->Mult(*v1, *v2);  
      PrtTim("Fin Multiplication Mult");
    }
    else if (OPE == 9) {
      for(pos=0; pos<N; pos++)  
        v3->AddCk(*v1, *v2);  
      PrtTim("Fin Addition AddCk");
    }
    else if (OPE == 10) {
      for(pos=0; pos<N; pos++)  
        v3->MultCk(*v1, *v2);  
      PrtTim("Fin Multiplication MultCk");
    }

    printf("Result[1.2] D1= %g %g  D2= %g %g  D3= %g %g \n",
          v1->elem(1),v1->elem(2), v2->elem(1),v2->elem(2),
          v3->elem(1),v3->elem(2));
    printf("Result[991-2] D1= %g %g  D2= %g %g  D3= %g %g \n",
          v1->elem(991),v1->elem(992), v2->elem(991),v2->elem(992),
          v3->elem(991),v3->elem(992));
    }
    break;

  default:
    puts("Erreur d'option !");
    break;
  }


  
PrtTim("Fin de Vector/C++ ");
printf(" .......... Fin de VectorC++ ........... \n");
return (0);
}

/*
#ifdef DECCXX
#pragma define_template Vector<int>
#pragma define_template Vector<float>
#pragma define_template Vector<double>
#endif

#if defined(GNUGCC) || defined (HPaCC)
template class Vector<int>;
template class Vector<float>;
template class Vector<double>;
#endif

*/
