// Module PI : Peida Interactive     PIImage
// Affichage d image            R. Ansari  05/95
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIIMAGE_H_SEEN
#define PIIMAGE_H_SEEN

#include "parradapter.h"

#include "pisysdep.h"

#include "pidrawer.h"
#include PIPIXMAP_H
#include PISTDWDG_H
#include PIWIN_H

class PIImage : public PIPixmap
{

public:
  enum {ClassId = 5150};

//  Les methodes 

  PIImage(PIContainerGen *par, char *nom=NULL, 
           int sx=0, int sy=0, int px=0, int py=0);
  ~PIImage();

  virtual long    kind() {return ClassId; }

//  Tableau des pixels et changement de configuration des axes 
  void SetImage(P2DArrayAdapter* pim, bool ad = true, bool refr=true);
  void ChangeAxesConfiguration(bool ix, bool iy, bool xy, bool refr=true);
  inline void   SetDrawAxesFlags(unsigned int flags=kBoxAxes | kExtTicks | kLabels)
                       { mdrw->SetAxesFlags(flags); mdrw->Refresh(); }

// Fenetre de Zoom, text, ...
  void SetZoomWin(PIPixmap * zw, bool refr=true);
  void SetGloVWin(PIPixmap * zw, bool refr=true);
  void SetTextWin(PILabel * tw, bool trw=true, int tx=350, int ty=30);
  void ShowCursor(bool sc=true); 

//  Gestion du choix de LUT, facteur d agrandissement, table de couleur
  void SetLut(float min, float max, int typlut=kLutType_Lin,
              int lauto=0, bool refr=true);
  void SetLut(LUT *clut, bool refr=true);

  void SetZoom(int zm, bool refr=true);
  void SetZoomF(float fzm, bool refr=true);
  float GetZoomF();

  virtual void SetColMap(CMapId cmap, bool refr=true);

  void SetOffset(int ox, int oy, bool refr=true);
  void SetPave(int x, int y, bool refr=true, bool cent=true);

  inline P2DArrayAdapter * Image() { return(img); }
  inline LUT *     Lut() { return(lut); }
  inline int XPave() { return(xpav); } ;
  inline int YPave() { return(ypav); } ;

  inline int XSzPave() { return(xszpav); }
  inline int YSzPave() { return(yszpav); }

  void Apply(bool mw=true);

  virtual void Resize();
  virtual void Draw(PIGraphic* g, int x0, int y0, int dx, int dy);

  virtual void Keyboard(int key, PIKeyModifier kmod);
  virtual void But1Press(int x, int y);
  virtual void But1Release(int x, int y);
  virtual void Ptr1Move(int x, int y);
  virtual void But2Press(int x, int y);
  virtual void But2Release(int x, int y);
  virtual void Ptr2Move(int x, int y);
  virtual void But3Press(int x, int y);
  virtual void But3Release(int x, int y);
  virtual void Ptr3Move(int x, int y);

  virtual void PasteSelection(unsigned int typ, void *pdata, unsigned int l);

//  Pour acces par les ImgTools (LutWind, ...)
  static PIImage* CurrentPIImage();
  static void SetCurrentPIImage(PIImage* curimg);

protected:
  virtual void    Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  void ComputePixmap();
  void ComputeZoomPixmap();
  void ComputeGloVPixmap();
  void SetGloVPixmap();

  void DrawCursor(PIGraphicGen* g);
  void DrawCursor(PIGraphicGen* g, int xc, int yc);

  void ShowTrTxW();

  int PosW2Img(int xiw, int yiw, int * xp, int * yp);
  int PosImg2W(int xp, int yp, int * xiw, int * yiw);

  void SetOffsetFromPave();
  void CenterPave();

// Les donnees 
  P2DArrayAdapter * img;
  bool aisup;     // Flag de suppression automatique de img
  bool curshow;
  bool winovis;   // $CHECK$ Reza A enlever si possible 17/6/96
// Tableau des pixels principal  
  unsigned char * pixm;
  int xspxm, yspxm;
  LUT * lut;
  int offx, offy;
  PIElDrawer* mdrw;
// Fenetre de zoom
  int zoom;
  PIPixmap * zow;
  unsigned char * zpixm;
  int xszpxm, yszpxm;
// Fenetre pour l'image entiere  
  int zmgv;
  PIPixmap * gvw;
  unsigned char * gpixm;
  int xsgpxm, ysgpxm;
  PIElDrawer* gvdrw;
// Fenetre/champ de texte
  PILabel * txw;
  PILabel * trtlb;
  PIWindow * trtw;
// Le pave et le curseur
  int xpav, ypav;
  int xpv0, ypv0;
  int xmv0, ymv0;
  int dxmv, dymv;
  int xcurs, ycurs;
  int xszpav, yszpav;

//  PIImage courante 
  static PIImage* cur_piimage;
};

#endif
