#include <stdio.h>
#include "pintup3d.h"

 
/* --Methode-- */
PINTuple3D::PINTuple3D(NTuple* nt, bool ad)
: PIDrawer3D()
{
  mNT = nt;
  mAdDO = ad; 
  SelectXYZ(NULL, NULL, NULL);
  SelectErrBar();
}

PINTuple3D::~PINTuple3D()
{
  if (mAdDO && mNT)  delete mNT;
}

/* --Methode-- */
void  PINTuple3D::SelectXYZ(char* px, char* py, char* pz)
{
if (mNT == NULL)  xK = yK = zK = -1;
if (px == NULL) xK = -1;
else xK = mNT->IndexNom(px);
if (py == NULL) yK = -1;
else yK = mNT->IndexNom(py);
if (pz == NULL) zK = -1;
else zK = mNT->IndexNom(pz);
}

/* --Methode-- */
void  PINTuple3D::SelectErrBar(char* erbx, char* erby, char* erbz)
{
if (mNT == NULL)  xebK = yebK = zebK = -1;
if (erbx == NULL) xebK = -1;
else xebK = mNT->IndexNom(erbx);
if (erby == NULL) yebK = -1;
else yebK = mNT->IndexNom(erby);
if (erbz == NULL) zebK = -1;
else zebK = mNT->IndexNom(erbz);
}


/* --Methode-- */
void PINTuple3D::UpdateSize()
{
  if (!mNT) return;
  if (mNT->NEntry() <= 0)  return;
  if ( (xK < 0) || (yK < 0)  || (zK < 0) )   return;

  // Commencer par trouver nos limites
  float xmin, xmax, ymin, ymax, zmin, zmax;
  xmin = ymin = 9.e19;
  xmax = ymax = -9.e19;
  zmax = zmax = -9.e19;
  mNT->GetMinMax(xK, xmin, xmax);
  mNT->GetMinMax(yK, ymin, ymax);
  mNT->GetMinMax(zK, zmin, zmax);

// Centre du champ en C = (xmin+xmax)/2., (ymin+ymax)/2  (zmin+zmax)*0.5
// Distance D = Max(xmax-xmin,ymin-ymax)*2
// Observateur en O = X+D, Yc+2*D 
  float D = xmax-xmin;
  if (D < (ymax-ymin))  D = ymax-ymin;
  D *= 1.4;
  
  Set3DView((xmin+xmax)/2., (ymin+ymax)/2, (zmin+zmax)/2., 
            (xmin+xmax)/2.+D , (ymin+ymax)/2.+2.*D , zmin+(zmax-zmin)*0.1, 0.3, 0.3);  
//  printf("PINTuple3D::UpdateSize() : %g-%g  %g-%g  %g-%g (%g) \n", xmin,xmax,ymin,ymax,zmin,zmax,D);
//  printf("PINTuple3D::UpdateSize() :  %g %g %g << %g %g %g \n", 
//         (xmin+xmax)/2., (ymin+ymax)/2, (zmin+zmax)*0.5, 
//         (xmin+xmax)/2.+D , (ymin+ymax)/2.+2.*D , zmin+(zmax-zmin)*0.1);
}


/* --Methode-- */
void PINTuple3D::Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax)
{
float xp,yp,zp,xer,yer,zer;
int nok;

if (!mNT) return;
if ( (xK < 0) || (yK < 0) || (zK < 0) )  return;
PIGraphic3D* g3 = dynamic_cast<PIGraphic3D*>(g);

nok = 0;  
for (int i=0; i<mNT->NEntry(); i++) {
  xp = mNT->GetVal(i, xK);
  yp = mNT->GetVal(i, yK);
  zp = mNT->GetVal(i, zK);
  nok++;
  g3->DrawMarker3D(xp, yp, zp); 
  if ( xebK >= 0 ) {
    xer = mNT->GetVal(i, xebK);
    g3->DrawLine3D(xp-xer, yp, zp, xp+xer, yp, zp);
  }
  if ( yebK >= 0 ) {
    yer = mNT->GetVal(i, yebK);
    g3->DrawLine3D(xp, yp-yer, zp, xp, yp+yer, zp);
  }
  if ( zebK >= 0 ) {
    zer = mNT->GetVal(i, zebK);
    g3->DrawLine3D(xp, yp, zp-zer, xp, yp, zp+zer);
  }
}

return;
}

