// Module PI : Peida Interactive     PIGraphic 
// Primitives de trace graphiques    R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

// Classe generique de trace graphique de base (Ne peut etre instancie)

#include "pigraphgen.h"

/* --Methode-- */
PIGraphicGen::PIGraphicGen()
{
myWdg = NULL;
}

/* --Methode-- */
PIGraphicGen::PIGraphicGen(PIWdg* wdg)
{
myWdg = wdg;
}

/* --Methode-- */
PIGraphicGen::~PIGraphicGen()
{
}
/* --Methode-- */
int PIGraphicGen::kind() 
{
return PI_ScrWindowGraphics; 
}

/* --Methode-- */
void PIGraphicGen::GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax)
{
xmin = ymin = 0;  
xmax = ymax = 0;
if (myWdg) {
  xmax = myWdg->XSize();
  ymax = myWdg->YSize();
  }
}

/* --Methode-- */
void PIGraphicGen::SaveGraphicAtt()
{
  sFCol = GetForeground();
  sBCol = GetBackground();
  sGOm = GetGOMode();
  sFAtt = GetFontAtt();   
  sFSize = GetFontSize();
  sLAtt = GetLineAtt();
  sMrk = GetMarker();   
  sMrkSz = GetMarkerSize();
  return;
}

/* --Methode-- */
void PIGraphicGen::RestoreGraphicAtt()
{
  SelForeground(sFCol);
  SelBackground(sBCol);
  SelGOMode(sGOm);
  SelFontSzPt(sFSize, sFAtt);
  SelLine(sLAtt);
  SelMarker(sMrkSz, sMrk);
  return;
}
