// Guy Le Meur 03/2000


#ifndef FITSXNTuple_SEEN
#define FITSXNTuple_SEEN
#include "machdefs.h"
#include "xntuple.h"
#include "anydataobj.h"
#include "ppersist.h"
#include "fitsfile.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////
//   Les objets delegues pour la gestion de persistance sur fichiers fits 
//   pour XNTuple
///////////////////////////////////////////////////////////

class  FITS_XNTuple : public FitsIOHandler  
{

public:
FITS_XNTuple();
FITS_XNTuple(char inputfile[],int hdunum=2);
FITS_XNTuple(const XNTuple & obj);
FITS_XNTuple(XNTuple* obj);
~FITS_XNTuple();

virtual   AnyDataObj* DataObj() { return(dobj_); }
virtual   void        SetDataObj(AnyDataObj & o) 
  {   
    XNTuple* po = dynamic_cast<  XNTuple* >(& o); 
    if (po == NULL) return;
    if (ownobj_ && dobj_) delete dobj_;  
    dobj_ = po; 
    ownobj_ = false; 
  }    


/*!
fill the XNTuple only with lines from firstLine-th to (firstLine+numberOfLines-1)-th of the FITS-file inputfile.
\param <firstLine>  first line  to be read (the first line of the file is numbered 0)
\param <numberOfLines>  number of lines to be read
*/
void ReadLines(char inputfile[],int firstLine, int numberOfLines,int hdunum=2);
inline operator XNTuple() { return(*dobj_); }
inline XNTuple * getObj() { return(dobj_); }

protected:

  // implementation de FitsFile
 virtual void  ReadFromFits(FitsInFile& is);
virtual void    WriteToFits(FitsOutFile& os) ;

 private :


inline void InitNull()
   {
     fistLineToBeRead_= -1;
     numberOfLinesToBeRead_= -1;
   }

  // attributs de classe
  XNTuple* dobj_;
  bool    ownobj_;
  int fistLineToBeRead_;
  int numberOfLinesToBeRead_;
};
//////////////////////////////////////////////////////////////////


} // Fin du namespace

#endif
