#include "pexceptions.h"
#include "fitsbntbllinereader.h"
///////////////////////////////////////////////////////////
//    
//    
///////////////////////////////////////////////////////////


#define LONNOM 31 


FITS_BntblLineReader::FITS_BntblLineReader()
{
  InitNull();
}

FITS_BntblLineReader::FITS_BntblLineReader(char inputfile[],int hdunum)
{
  InitNull();

  //  FitsFile* fn=ReadFInit(inputfile,hdunum);
  //  ReadFInit(inputfile,hdunum);
  inFits_  = new FitsInFile (inputfile);
  inFits_->ReadFInit(hdunum);

  //  if (!fn->IsFitsTable())
  if (!inFits_->IsFitsTable())
    {
      throw PException("FITS_BntblLineReader: the fits file seems not to be a bintable nor ASCII table");
    }

  //
  int nbcols, nbentries;
  //  nbcols = fn->NbColsFromFits();
  nbcols = inFits_->NbColsFromFits();
  nbentries = 0;
  int k;
  //  for (k=0; k<nbcols; k++) nbentries=max( nbentries, fn->NentriesFromFits(k) );
  for (k=0; k<nbcols; k++) nbentries=max( nbentries, inFits_->NentriesFromFits(k) );

  //
  // pour mettre les colonnes dans l'ordre double, float, int, char :
  // tableau de correspondance 
  // DfitsCol(j)= numero dans le fichier fits de la  jeme variable double du 
  // xntuple;
  // FfitsCol(j)= numero dans le fichier fits de la  jeme variable float du 
  // xntuple;
  // etc.
  vector<int> DfitsCol;
  vector<int> FfitsCol;
  vector<int> IfitsCol;
  vector<int> SfitsCol;
  for (k=0; k<nbcols;k++)
    {
      //      char ss= fn->ColTypeFromFits(k);
      char ss= inFits_->ColTypeFromFits(k);
      if (ss == 'D') DfitsCol.push_back(k);
      else if (ss == 'E') FfitsCol.push_back(k);
      else if (ss == 'I') IfitsCol.push_back(k);
      else if (ss == 'S') SfitsCol.push_back(k);
      else {
	cout << " FITS_XNTuple: colonne fits " << k << " type= " << ss << endl;
	throw  IOExc("type de champ inconnu");
      }
    }
  ColName_ = new char*[nbcols];
  int compt=0;
  for (k=0; k<DfitsCol.size(); k++)
    {
      ColName_[compt] = new char[LONNOM+1]; 
      //      strncpy(ColName_[compt], fn->ColNameFromFits(DfitsCol[k]).c_str(), LONNOM);
      strncpy(ColName_[compt], inFits_->ColNameFromFits(DfitsCol[k]).c_str(), LONNOM);
      ColName_[compt++][ LONNOM] =  '\0';
    }
  for (k=0; k<FfitsCol.size(); k++)
    {
      ColName_[compt] = new char[LONNOM+1]; 
      //      strncpy(ColName_[compt], fn->ColNameFromFits(FfitsCol[k]).c_str(), LONNOM);
      strncpy(ColName_[compt], inFits_->ColNameFromFits(FfitsCol[k]).c_str(), LONNOM);
      ColName_[compt++][ LONNOM] =  '\0';
    }
  for (k=0; k<IfitsCol.size(); k++)
    {
      ColName_[compt] = new char[LONNOM+1]; 
      //      strncpy(ColName_[compt], fn->ColNameFromFits(IfitsCol[k]).c_str(), LONNOM);
      strncpy(ColName_[compt], inFits_->ColNameFromFits(IfitsCol[k]).c_str(), LONNOM);
      ColName_[compt++][ LONNOM] =  '\0';
    }
  for (k=0; k<SfitsCol.size(); k++)
    {
      ColName_[compt] = new char[LONNOM+1]; 
      //      strncpy(ColName_[compt], fn->ColNameFromFits(SfitsCol[k]).c_str(), LONNOM);
      strncpy(ColName_[compt], inFits_->ColNameFromFits(SfitsCol[k]).c_str(), LONNOM);
      ColName_[compt++][LONNOM] =  '\0';
    }

  if (DfitsCol.size()>0)
    {
      dcount_ = DfitsCol.size();
      ddata_ = new r_8[dcount_];
    }
  if (FfitsCol.size()>0)
    {
      fcount_ = FfitsCol.size();
      fdata_ = new r_4[fcount_];
    }
  if (IfitsCol.size()>0)
    {
      icount_ = IfitsCol.size();
      idata_ = new int_4[icount_];
    }
  if (SfitsCol.size()>0) 
    {
      ccount_ = SfitsCol.size();
      cdata_ = new char*[ccount_];
      taille_des_chaines_ = 0;
      //      for (k=0; k< ccount_; k++)  taille_des_chaines_ = max( taille_des_chaines_, fn->ColStringLengthFromFits(SfitsCol[k]) );
      for (k=0; k< ccount_; k++)  taille_des_chaines_ = max( taille_des_chaines_, inFits_->ColStringLengthFromFits(SfitsCol[k]) );
      for (k=0; k<ccount_; k++) cdata_[k]=new char[taille_des_chaines_+1];
    }
}


FITS_BntblLineReader::~FITS_BntblLineReader()
{
  if (inFits_ != NULL) delete inFits_;
  if (ddata_ != NULL) delete [] ddata_;
  if (fdata_ != NULL) delete [] fdata_;
  if (idata_ != NULL) delete [] idata_;
  if (cdata_ != NULL)
    {
      if (ccount_ != 0)
	{
	  for (int k=0; k< ccount_; k++)
	    { 
	      delete [] cdata_[k];
	      delete [] ColName_[k];
	    }
	  delete [] cdata_;
	  delete [] ColName_;
	}
      else
	{
	  cout << "FITS_BntblLineReader, destructeur: bizarre, cdata non vide, avec ccount=0 ?" << endl;;  	}
    }
}


XNTuple FITS_BntblLineReader::ReadNextLine()
{ //inFits_->GetBinTabLine(nextLineToBeRead_++, ddata_, fdata_, idata_, cdata_ );
  inFits_->GetBinTabLine(nextLineToBeRead_++, ddata_, fdata_, (int *) idata_, cdata_ );
  		// Portage Mac Incompatibilite int_4, int sur mac et CFitsIO
  XNTuple xnt(dcount_, fcount_, icount_,ccount_, ColName_); 
  xnt.Fill(ddata_, fdata_, idata_, cdata_);    
  return xnt;
}

void  FITS_BntblLineReader::ReadFromFits(FitsInFile&)
{   
}

void FITS_BntblLineReader::WriteToFits(FitsOutFile&)
{
}
