			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef MeanFreqLobe_H
#define MeanFreqLobe_H

#include "lobesep.h"
#include "distribflatfilter.h"

/* Class design to implement mean lobes: 
   Lobes you spatial response do no depend on frequency.
   Thus behavior is completely described as behavior at mean frequency
*/
 
class MeanFreqLobe:public LobeSep {
public:
  MeanFreqLobe(double freqMin, double freqMax):LobeSep(freqMin,freqMax) {
  	pRespShape=new DistribFlatFilter(freqMin,freqMax);
  	One_ExcurFreq=1.;
  }
  virtual ~MeanFreqLobe() {delete pRespShape;}
  DistribFlatFilter* pRespShape;
    		// Units conversion tools
protected:
	double One_ExcurFreq;		
 	virtual double spectre(double freq) const {
 		if(freq<FreqMin||freq>FreqMax) return 0.;
 		return One_ExcurFreq;
 	}
};


#endif