			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef LightDIFFDUST_SEEN
#define LightDIFFDUST_SEEN
#include "spherehealpix.h" 
#include "lightsrcsep.h"


class LightDiffDust:public LightSrcSep {
 public:
    LightDiffDust(int_4 nside);
    virtual ~LightDiffDust();
 protected: 
    int nlat;           // Nlat de la carte gorsky de reference
    double TDust;  		// Temperature of dust
    double fRef;   		// Frequency Reference
    double index;  		// Index en frequence fitt sur le modle
    double Hfraction;
    double index2;
   	double CorrelatedfreeWeight;
    double nuPlanckfRef;
    SphereHEALPix<float>* pMap;         // Map units MJy from IRAS Data.
    
    virtual double powerDensAmpli(double theta,double phi){
    	return (*pMap)(theta,phi)*1.e-20*fRef;
  		// Return power density Amplidude at coordinates
    	// (W/m2/Hz/st)
    }
    virtual double spectre(double freq){
    /*	double temp=planckSpectrum(freq,TDust)/planckSpectrum(fRef,TDust)
    			*(1-Hfraction)* freq*freq/fRef/fRef;
    	return temp;
    */
  	double nuPnu= nuPlanck(freq)/nuPlanck(fRef) * (1.-Hfraction) * pow(freq/fRef,index) 
    	+ pow(freq/fRef,1+index2) * CorrelatedfreeWeight;	
    	return nuPnu/freq;	
    }
    inline double nuPlanck(double freq){
    	return freq*planckSpectrum(freq,TDust);
    }
};

#endif
 