			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <math.h>
#ifdef __MWERKS__
    
   #include "unixmac.h"
   #include "macenvvariables.h"
#endif
#include "unitvector.h"
#include "lobecartographmoyen.h"

LobeCartoMoyen::LobeCartoMoyen(CarteLobe* pcart,double freqMin, double freqMax)
  :MeanFreqLobe(freqMin,freqMax), pCarte(pcart) {
  
  	angleMax=pCarte->halfAngAperture();
  	cosanglemax=cos(angleMax);
  	sprintf(Name,"Lobe Cartographi TICRA");
}

LobeCartoMoyen::~LobeCartoMoyen(){	}
double LobeCartoMoyen::lobeResol() const{
  // Du fait des extrapolations paraboliques, on peut calculer le lobe en
  // tout point sans reconter de probleme de precision
  return pCarte->resol();
}

UnitVector LobeCartoMoyen::VecShift(const UnitVector& Vpointe, const UnitVector& VY) const {
  double alpha,beta;
  pCarte->UVToAng(pCarte->UCentre(),pCarte->VCentre(),alpha,beta);
  UnitVector Vec;
  Vec=Vpointe.Rotate(VY,alpha);
  Vec=Vec.Rotate(Vpointe,beta);
  return Vec;
}


double LobeCartoMoyen::weigthAmpl(const UnitVector& Vcourant,const UnitVector& VP, 
  		const UnitVector& VY) const{
  UnitVector VCentreLobe;
  VCentreLobe=VecShift(VP, VY);
  double cosbidon=(Vcourant*VCentreLobe);
  if (cosanglemax>cosbidon) return 0.;
  else 
  //return 1.;	//Debug
  {   double cosalpha=Vcourant*VP;
  	//  cout<<1-cosalpha*cosalpha<<endl;
 	  double sinalpha=sqrt(1-cosalpha*cosalpha); 	// Approx. des petits angles
  
	  Vector3d VProjVcourant;
	  VProjVcourant=Vcourant-cosalpha*VP;
	  VProjVcourant.Normalize();
	  
	  UnitVector VX=VY^VP;		
	  // Produit vectoriel
	  // On peut optimiser en sortant le calcul de VX de la fonction.
	  double cosbeta=VProjVcourant*VX;
	  double sinbeta=VProjVcourant*VY;

	  return pCarte->Value(sinalpha*cosbeta,sinalpha*sinbeta);
	  // Il faut comprendre les homogeneites de la carte BUGGGGGG  XXXXXXX
	 
  }
  
}