			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef MakeBoloTimeline_H
#define MakeBoloTimeline_H

#include <fstream>

#include "abslightsource.h"
#include "abslobenopolar.h"
#include "sigcalctools.h"
#include "ptsrcinbandcalctools.h"

#include "specresp.h"
#include "spherehealpix.h"

#define VisuIsActive


enum Normalisation { RayleighJeans, TempeCMB, Power};
class MakeBoloTimeline
{	
public:
	MakeBoloTimeline(char file[], AbsCalcTool& Tool, Normalisation Norm);
	MakeBoloTimeline(char file[], AbsLightSource& LSrc, AbsLobeNoPolar& Lobe, 
		SpectralResponse& Filter, Normalisation Norm);
	MakeBoloTimeline(char file[], LightPtSrcLevSInBand& LSrc, 
		MeanFreqLobe& Lobe, LevSPanckBand band, Normalisation Norm);
	~MakeBoloTimeline();
	void addToStreamArchTOI(double theta, double phi);
		//	 Theta en heures, Phi en degres, coordonnes RA Dec
	void addToStream(double lgalax,double bgalax);
		// theta et phi en radian, coordones galactiques J2000.

protected:
	AbsCalcTool* ptool;
	
	SigCalcTool* pSigCalcTool;
	bool IsSigCalctool;
	PtSrcInBandCalTools* pPtSrcInBandCalTools;
	bool IsPtSrcInBandtool;
	
	double NormRJ;
	double NormTCMB;
	Normalisation NormMethode;
	
	// Outils de fichier sortie
	ofstream* pMystr;		// Fichier ascii des valeurs physiques simulees
	
	void saveReadMe(char File[]);		// ReadMe file for ASCII output
	
//	long flushControl;

#ifdef VisuIsActive
	SphereHEALPix<r_4>* pSphere;		// Pour creer une visu de controle
	SphereHEALPix<uint_2>* pSphereInt;
	char Name[200];
#endif

};

#endif
