// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef AbsLobeNoPolar_H
#define AbsLobeNoPolar_H

#ifdef __MWERKS__
//   #include "unixmac.h"
   #include "macenvvariables.h"
#endif

#include <stdlib.h>
#include "unitvector.h"
	
#include "lobespecresp.h"
#include "radspec.h"

class AbsLobeNoPolar{
//friend class SigCalcTool;
// Base class for Implementing Lobes 

 public:
  AbsLobeNoPolar(double FMin,double FMax):FreqMin(FMin),FreqMax(FMax) 
  { cosanglemax=-1.;
  	sprintf(Name,"");
  }
  virtual double weigth(const UnitVector& VInteg, const UnitVector& VP, 
  	const UnitVector& VY, double freq) const =0;
    // Return relative weigth of incoming power from direction VInteg
    // at frequency freq no dimensions
  virtual double lobeResol() const =0;
    // Return reasonable computing resolution for this lobe
  virtual double ResolutionCurve(double angle) const=0;
 	// Compute angular resolution degradation factor as a function of angle
 	// Usefull to optimize the speed of computation at large angle
    // Overloaded when optimisation is required.
  virtual void print(ostream& OutStr) const;
  inline LobeSpecResp WeigthVsFreq(const UnitVector& VInteg, 
  	const UnitVector& VP, const UnitVector& VY) 
  {
  	LobeSpecResp TheSpecResp(this,VInteg,VP,VY,this->minFreq(),this->maxFreq());
  	return TheSpecResp;
  }
	// Return an object including WeigthVsFreq  with no dimensions.
	
/*  virtual DPixelMap& getLobeMap(double ResLSrcMap)=0;  
 	// Return Map of Lobe to allow multiplication of map 
 	// To be implemented
*/  
  inline double AngleMax() const{return angleMax;}
  inline double minFreq() const {return FreqMin;}
  inline double maxFreq() const {return FreqMax;}
  inline bool IsFreqSep() const {return LobeFSep;}

  int gorskyNlatFromRes() const;
    // Compute Gorsky Nlat to prepare a map with full resolution of the lobe

  virtual UnitVector VecShift(const UnitVector& VPointe,const UnitVector& VY) const{
    // Usefull when peak sensitivity is not in boresight direction
  	return VPointe;
  }

  //	Optimisations tools for frequency separable Lobe computations.
  virtual double spectre(double freq) const{
  	freq=0.;	//evite un warning
  	if(!LobeFSep) cerr<< "appel a lobe.spectre() in a non separable lobe"<<endl;
  	exit(-1);
  	return 0;
  }
  virtual double weigthAmpl(const UnitVector& VInteg, const UnitVector& VP, 
  	const UnitVector& VY) const{
  	if(!LobeFSep) cerr<< "appel a lobe.weigthAmpl() in a non separable lobe"<<endl;
  	exit(-1);
  	return 0;
  }

 protected:
  char Name[32];
  double FreqMin;
  double FreqMax;
  double angleMax;
  double cosanglemax; 
    // Angle beyond which constributions is neglected for this lobe
    // Lobe 4 M_PI angleMax=180.
  bool LobeFSep;	
    // Are spatial coordinated and frequency separable variables?
  inline double minToRad(double minute) { return minute/(180.*60.)*M_PI;}
  inline double radToMin(double rad) { return rad/M_PI*180.*60.; }
  //SpectralResponse* pSpecRep;
};


#endif