			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef LightCMBPrim_SEEN
#define LightCMBPrim_SEEN
#include "spherehealpix.h" 
#include "lightsrcsep.h"

class LightCMBPrim:public LightSrcDiffBlackBody
{
 public:
    LightCMBPrim(int_4 nside=256);
    	// nside de la carte Gorsky
    	// Variane required for sky fluctuationss
    virtual ~LightCMBPrim();
 protected:
 	double Variance;
    SphereHEALPix<float>*  pMap;
    int_4 nlat;
    
    virtual double DeltaT(double theta,double phi) {
    	int_4 index=pMap->PixIndexSph(theta,phi); 	
    		// La carte est en DT/T * 1.e6 
  		double valeur=pMap->PixVal(index)*T_CMBR*1.e-6;
  		return valeur; // En Kelvin
    }
};

#endif
