			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef Numrecipes_H_
#define Numrecipes_H_

#include <math.h>
#ifdef __MWERKS__
   #include "unixmac.h"
#endif


/* 	Cree pour encapsuler les fonctions utiles de la Numerical Recipes
	Actuellement encapsule: nrtil.h, hunt.c, polin2.c polint.c
*/

class NumRecipes{
public:	
	NumRecipes() {}
	~NumRecipes() {}
	void nrerror(char error_text[]);
	float *vector(long nl, long nh);
	int *ivector(long nl, long nh);
	unsigned char *cvector(long nl, long nh);
	unsigned long *lvector(long nl, long nh);
	double *dvector(long nl, long nh);
	float **matrix(long nrl, long nrh, long ncl, long nch);
	double **dmatrix(long nrl, long nrh, long ncl, long nch);
	int **imatrix(long nrl, long nrh, long ncl, long nch);
	float **submatrix(float **a, long oldrl, long oldrh, long oldcl, long oldch,
		long newrl, long newcl);
	float **convert_matrix(float *a, long nrl, long nrh, long ncl, long nch);
	float ***f3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
	void free_vector(float *v, long nl, long nh);
	void free_ivector(int *v, long nl, long nh);
	void free_cvector(unsigned char *v, long nl, long nh);
	void free_lvector(unsigned long *v, long nl, long nh);
	void free_dvector(double *v, long nl, long nh);
	void free_matrix(float **m, long nrl, long nrh, long ncl, long nch);
	void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch);
	void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch);
	void free_submatrix(float **b, long nrl, long nrh, long ncl, long nch);
	void free_convert_matrix(float **b, long nrl, long nrh, long ncl, long nch);
	void free_f3tensor(float ***t, long nrl, long nrh, long ncl, long nch,
		long ndl, long ndh);

	void hunt(float xx[], unsigned long n, float x, unsigned long *jlo);
  	void polin2(float *xx,float *yy, float** yaa,int,int,float,float,float*,float*);
  	void polint(float xa[], float ya[], int n, float x, float *y, float *dy);
 };
 
 #endif