#ifndef LevSPtSrc_H
#define LevSPtSrc_H

#include <ostream>
#include "unitvector.h"

struct LevSPtSrc 
{
	/*	// Coordinates in Healpix convention, radians
	double theta;	// 0 ---->M_PI
	double phi;		// 0 ----> 2*M_PI
	*/
	UnitVector VecPoint;
	float flux30G;
	float flux44G;
	float flux70G;
	float flux100G;
	float flux143G;
	float flux217G;
	float flux352G;
	float flux545G;
	float flux857G;
	LevSPtSrc(	double Phi, double Theta, 
					float F30G, float F44G, float F70G, 
					float F100G, float F143G, float F217G, float F352G, float F545G, float F857G
					);					
	LevSPtSrc();
	LevSPtSrc(double theta, double phi);
	~LevSPtSrc() { }
	double Phi() const 	{	return VecPoint.Phi();	}
	double Theta() const {	return VecPoint.Theta();}
	LevSPtSrc& operator= (LevSPtSrc const & a); 
	
	void print(ostream& flux) const
	{	flux<<VecPoint.Theta()<<'\t'<<VecPoint.Phi()<<'\t'<<flux30G;
		flux<<'\t'<<flux44G<<'\t'<<flux70G<<'\t'<<flux100G<<'\t'<<flux143G;
		flux<<'\t'<<flux217G<<'\t'<<flux352G<<'\t'<<flux545G<<'\t'<<flux857G<<endl;
	}
		
	void printHeader(ostream& flux) const
	{	flux<<"theta\tphi\tflux30G\tflux44G\tflux70G\tflux100G\tflux143G\tflux217G\tflux352G\tflux545G\tflux857G"<<endl;
		return;
	}	
};

// Relation d'ordre sur la sphere a utiliser dans les contenaires.
inline bool operator < (const LevSPtSrc& Vec1, const LevSPtSrc& Vec2)
{	if ( Vec1.Theta() < Vec2.Theta() )  return true;
/*	if ( Vec1.Theta() == Vec2.Theta() ) 
	{	if ( Vec1.Phi() < Vec2.Phi() ) return true;
	}
*/	
	return false;
}

/*
// Pour utiliser dans le conteneur

struct lessThLevSPtSrc
{
	inline bool operator () (const LevSPtSrc& Vec1, const LevSPtSrc& Vec2) const
	{	if ( Vec1.Theta() < Vec2.Theta() )  return true;
		if ( Vec1.Theta() == Vec2.Theta() ) 
		{	if ( Vec1.Phi() < Vec2.Phi() ) return true;
		}
		return false;
	}
};

*/

#endif

