#include "levsptsrc.h"


LevSPtSrc::LevSPtSrc(
	double Phi, double Theta, 
	float F30G, float F44G, float F70G, 
	float F100G, float F143G, float F217G, float F352G, float F545G, float F857G
	)
	:VecPoint(Theta,Phi), flux30G(F30G), flux44G(F44G), flux70G(F70G), flux100G(F100G),
	flux143G(F143G), flux217G(F217G), flux352G(F352G), flux545G(F545G), flux857G(F857G)
{ }

LevSPtSrc::LevSPtSrc()
	:VecPoint(0.,0.), flux30G(0.), flux44G(0.), flux70G(0.), flux100G(0.),
	flux143G(0.), flux217G(0.), flux352G(0.), flux545G(0.), flux857G(0.)
{ }

LevSPtSrc::LevSPtSrc(double theta, double phi)
	:VecPoint(theta,phi), flux30G(0.), flux44G(0.), flux70G(0.), flux100G(0.),
	flux143G(0.), flux217G(0.), flux352G(0.), flux545G(0.), flux857G(0.)
{ }

LevSPtSrc& LevSPtSrc::operator= (LevSPtSrc const & a)
{	VecPoint=a.VecPoint;
	flux30G=a.flux30G;
	flux44G=a.flux44G;
	flux70G=a.flux70G;
	flux100G=a.flux100G;
	flux143G=a.flux143G;
	flux217G=a.flux217G;
	flux352G=a.flux352G;
	flux545G=a.flux545G;
	flux857G=a.flux857G;
	return *this;
}