#ifndef LobeLevSHealpix_H
#define LobeLevSHealpix_H

#include "meanlobe.h"
#include "spherehealpix.h"

class LobeLevSHealpix:public MeanFreqLobe
{
 public:
 	LobeLevSHealpix(char FileOflobeMap[],double angMax_degre, double MeanFreq_Hz);
  	~LobeLevSHealpix();
   const SphereHEALPix<float>& sphere() const {	return *pSphere;}
 protected:
  	virtual double ResolutionCurve(double angleShift) const
  	{	return 1.; } //return (double) (1.+(angleShift/sigma/7.));
  	
	virtual double lobeResol() const
	{	return M_PI/(2*pSphere->SizeIndex()); } //Radian
	
	virtual double weigthAmpl(const UnitVector& VInteg, const UnitVector& VP, 
  	  const UnitVector& VY) const;
		
 	SphereHEALPix<float>* pSphere;
};


#endif
