#ifndef ptsrcinbandcalctools_H
#define ptsrcinbandcalctools_H

#include "abscalctool.h"

#include "lightptsrclevsinband.h"
#include "meanlobe.h"


class PtSrcInBandCalTools:public AbsCalcTool {
 public:
  	PtSrcInBandCalTools(LightPtSrcLevSInBand* pLightSource,MeanFreqLobe* pLob, LevSPanckBand thisBand);
 	~PtSrcInBandCalTools() {	}
	virtual double compPixel(UnitVector& VP, UnitVector& VY);
  	// Return power on detector (Watt/m2) for this Lobe and band
   // Pointing at these ccordinates. with this telescope orientation
   // Exact
	virtual void print(ostream& ReadMe)
	{	ReadMe<<" La source physique: "<<endl;
		pLightSrc->print(ReadMe);
		ReadMe<<" Le Lobe : "<<endl;
		pLobe->print(ReadMe);
		ReadMe<<" Le Filtre: "<<endl;
		pFilter->Print(ReadMe);	
		ReadMe<<endl;
	}
	

	virtual double CalcLobeSize(double frequency);
	// Calcule l'extension spatiale du lobe de cet outil
	// par integration numerique, calquee sur 
	// L'integration spatiale ddu signal physique;
	// VALEUR RETOUR EN STERADIAN
	// Doit EVOLUER SI l'integration spatiale du signal physique CHANGE;
 protected:
  	LightPtSrcLevSInBand* pLightSrc;
 	LevSPanckBand Band;
 /*	
 		inline double powerInteg(double TMin, double TMax, double PMin, 
		double PMax, UnitVector& VP, UnitVector& VY, bool InvLog=false);
*/
 };
 
#endif
