#ifndef AbsCalTool_H
#define AbsCalTool_H

#include <fstream>
#include "unitvector.h"
#include "pixelmap.h" 
#include "specresp.h"
#include "abslobenopolar.h"

class AbsCalcTool
{
 public:
 	AbsCalcTool(double CompResol=0.,double freqMin=0.,double freqMax=-1.) 
 		:FreqMax(freqMax), FreqMin(freqMin), RAngComp(CompResol) {	}
 	//	Dummy values. Have to be initialised in offspring classes
 	
 	~AbsCalcTool() {	}
 	
 	virtual double compPixel(UnitVector& VP, UnitVector& VY)=0;
 	 // Return power on detector (Watt/m2) for this Lobe and filter
    // Pointing at these ccordinates and orientation. Exact
    
   virtual void print(ostream& ReadMe)=0;
   //	Main infos about calcTool
    
   virtual double CalcLobeSize(double frequency= -10.)=0;
	// Calcule l'extension spatiale du lobe de cet outil
	// par integration numerique, calquee sur 
	// L'integration spatiale ddu signal physique;
	// VALEUR RETOUR EN STERADIAN
	// Doit EVOLUER SI l'integration spatiale du signal physique CHANGE;
	
 	double compPixelQD(double theta, double phi);
    // Return power on detector (Watt/m2) for this Lobe and filter
    // Pointing at these ccordinates.
    // Exact if lobes are symmetrical by rotation around pointed axe
   
  // Normalisation tools
	double NormKelvinRayleighJeans();
 	// Compute te normalisation factor to go from Watt/m2 to KelvinRaleighJeans
 	// same computation option than the map options
 	// KelvinRJ/(Watt/m2)
 	
 	double NormKelvinCMB();
 	// Compute te normalisation factor to go from Watt/m2 to KelvinCMB
 	// same computation option than the map options
 	// KelvinCMB/(Watt/m2)
 	
 protected:
 	double RAngComp;		// angular resolution of computations
 	double FreqMax;		// Hz
 	double FreqMin;
 
 	AbsLobeNoPolar* pLobe;
 	SpectralResponse* pFilter;		// Hz
 	
 	 // Computation tools       
    // Math tools !!!!!!!-------------------------------------------------------
 	inline double max(double a, double b)const
 	{ 	if(a>b) return a;
  		else return b;
	}
 	inline double min(double a, double b)const
 	{ 	if(a<b) return a;
  		else return b;
	}
            //compute solid angle between cones of aperture angles ang1 and ang2
 
	virtual double diffSolidAng(double ang1,double ang2) const;

};
 	
// Tools for computing Maps
template <class T> void addToSkyMap(PixelMap<T>& Map, AbsCalcTool& Tool);
template <class T> void compSkyMap(PixelMap<T>& Map, AbsCalcTool& Tool);
template <class T> void addInInBandPowerMap(PixelMap<T>& Map, AbsCalcTool& tool);
  	// Exact if lobes are symmetrical by rotation around pointed axe
	// Return a map at the requested resolution and frequency

// Tools for manipulating maps	
template <class T1, class T2> void addMap(PixelMap<T1>& Map, PixelMap<T2>& Map2);
template <class T1, class T2> void substractMap(PixelMap<T1>& Map, PixelMap<T2>& Map2);
template <class T1, class T2> void divMap1WithMap2(PixelMap<T1>& Map, PixelMap<T2>& Map2);
template <class T> void scaleMap(double scalefactor, PixelMap<T>& Map);
template <class T> int MinMaxSigMap(PixelMap<T>& Map, double& Min, 
	double& Max, double& Moy, double& Var);
	
// Tool for changing ccordinates
// All coordinates are in Radian.
  /* kmg_euler.c
   *
   * Converts between different coordinate systems. 
   *
   * SELECT   From           To         |   SELECT    From          To
   *    1     RA-Dec (2000)  Galactic   |     4       Ecliptic      RA-Dec    
   *    2     Galactic       RA-DEC     |     5       Ecliptic
Galactic  
   *    3     RA-Dec         Ecliptic   |     6       Galactic
Ecliptic  
   *
   *    Date     Programmer Remarks
   * ----------- ---------- -------
   * 08-Aug-1999 K. Ganga   First version. Copied and modified EULER from 
   *                        the IDL Astrolib. 
   * May 2000, D. Yvon		 Change coordinates units to Radians
   */
int kmg_eulerRad(double ai, double bi, int select, double *ao, double *bo);

#endif