// This may look like C code, but it is really -*- C++ -*-
//                         C.Magneville          05/99
#ifndef TVector_SEEN
#define TVector_SEEN

#include "tmatrix.h"

namespace SOPHYA {

//! Class of vector (line or column)
template <class T>
class TVector : public TMatrix<T> {
public:
  // Creation / destruction 
  TVector();
  TVector(sa_size_t n, short lcv=AutoVectorType, short mm=AutoMemoryMapping);
  TVector(const TVector<T>& v);
  TVector(const TVector<T>& v, bool share);
  TVector(const TArray<T>& a);
  TVector(const TArray<T>& a,  bool share, short lcv=AutoVectorType, short mm=AutoMemoryMapping);
  TVector(const BaseArray& a);

  virtual ~TVector();

  //! Operator = 
  /*! \warning Datas are copied (cloned) from \b a.
      \sa NDataBlock::operator=(const NDataBlock<T>&) */
  inline  TVector<T>& operator = (const TVector<T>& a)
                       { Set(a);  return(*this); }
  //! Operator = between a vector and a matrix 
  inline  TVector<T>& operator = (const TMatrix<T>& a)
                       { Set(a);  return(*this); }
  //! Operator = between a vector and an array 
  inline  TVector<T>& operator = (const TArray<T>& a)
                       { Set(a);  return(*this); }
  //! Operator = between Vectors with different types
  inline  TVector<T>& operator = (const BaseArray& a)
                       { SetBA(a);  return(*this); }
    
  // Gestion taille/Remplissage
  void ReSize(sa_size_t n, short lcv=SameVectorType ); 
  void Realloc(sa_size_t n, short lcv=SameVectorType, bool force=false);

  // Sub-Vector extraction $CHECK$ Reza 03/2000  Doit-on declarer cette methode const ?
  TVector<T> SubVector(Range relt) const ;
  //! Extract a vector define by Range \b relt
  inline TVector<T> operator () (Range relt) const 
                    { return SubVector(relt); }

  // Informations pointeur/data
  //! return the number of elements
  inline sa_size_t NElts() const {return Size(); }
  
  // Inline element acces methods 
  inline T const& operator()(sa_size_t n) const;
  inline T&       operator()(sa_size_t n);

  // Operateur d'affectation
  //! Fill the vector with Sequence \b seq
  inline  TVector<T>&  operator = (Sequence const & seq) { SetSeq(seq); return(*this); }

  // Operations diverses  avec une constante
  //! Set vector elements to constant value \b x
  inline  TVector<T>&  operator = (T x)             { SetT(x); return(*this); }
  //! Add constant value \b x to vector elements
  inline  TVector<T>&  operator += (T x)            { Add(x); return(*this); }
  //! Substract constant value \b x to vector elements
  inline  TVector<T>&  operator -= (T x)            { Sub(x); return(*this); }
  //! Multiply vector elements by constant value \b x
  inline  TVector<T>&  operator *= (T x)            { Mul(x); return(*this); }
  //! Divide vector elements by constant value \b x
  inline  TVector<T>&  operator /= (T x)            { Div(x); return(*this); }

  //  operations avec matrices 
  //! += : add a vector in place
  inline  TVector<T>&  operator += (const TVector<T>& a)  { AddElt(a); return(*this); }
  //! += : substract a vector in place
  inline  TVector<T>&  operator -= (const TVector<T>& a)  { SubElt(a); return(*this); }

  // Norme(^2) 
  T Norm2() const ;

  virtual string InfoString() const;

};

//  ---- inline acces methods ------

//! Return the value of element \b n
template <class T>
inline T const& TVector<T>::operator()(sa_size_t n) const
{
#ifdef SO_BOUNDCHECKING
  if (veceli__ == 0)   CheckBound(n, 0, 0, 0, 0, 4);
  else   CheckBound(0, n, 0, 0, 0, 4);
#endif
  return ( *( mNDBlock.Begin()+ offset_ + n*step_[veceli_] ) );
}

//! Return the value of element \b n
template <class T>
inline T & TVector<T>::operator()(sa_size_t n) 
{
#ifdef SO_BOUNDCHECKING
  if (veceli__ == 0)   CheckBound(n, 0, 0, 0, 0, 4);
  else   CheckBound(0, n, 0, 0, 0, 4);
#endif
  return ( *( mNDBlock.Begin()+ offset_ + n*step_[veceli_] ) );
}

// Typedef pour simplifier et compatibilite Peida
/*! \ingroup TArray
  \typedef Vector
  \brief To simplified TVector<r_8> writing
*/
typedef TVector<r_8> Vector;

} // Fin du namespace

#endif
