// Classe MuTyV : Variable multi-type numerique
//                  R. Ansari  1997-2000
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA


#include "mutyv.h"
#include <stdio.h>

#include <iostream.h>
#include <string.h>

/*!
   \class SOPHYA::MuTyV
   \ingroup SysTools
   Simple utility class which can be used to hold values of type
   string, integer (\b int_8) or float (\b r_8) as well as complex,
   It provides also easy conversion methods between these types. 

   \code
   //  ------- Using MuTyV objects ------- 
   MuTyV mvu;         // MuTyV variable declaration 
   mvu = 60;          // mvu contains the integer value 60
   mvu = 66.6;        // and now the double value 66.6 
   string ds = mvu;   // ds contains the string "66.6"
   MuTyV mvi(14);     // New MuTyV variable containing integer value 14
   r_4 x = mvi;       // x has the value 14.0
   MuTyV mvs("Bonjour !");  // mvs contains the string "Bonjour !"
   string s = mvs;          // s contains "Bonjour !"
  
   \endcode
*/


static void mutyv_decodestr(const char * si, double& r, double& im);

/* --Methode-- */
MuTyV::MuTyV(MuTyV const & a)
{
  typ = a.typ;  iv = a.iv;  dv = a.dv;  dv_im = a.dv_im; 
  if (typ == 'S')  strv = new string(*(a.strv));
  else strv = NULL;
}

/* --Methode-- */
MuTyV::~MuTyV()
{
  if (strv) delete strv;
}

/* --Methode-- */
MuTyV::MuTyV(char const* s)
{
  typ = 'S';
  strv = new string(s);
  mutyv_decodestr(s, dv, dv_im);
  iv = (int_8)dv;
}

/* --Methode-- */
MuTyV::MuTyV(string const& s)
{
  typ = 'S';
  strv = new string(s);
  mutyv_decodestr(s.c_str(), dv, dv_im);
  iv = (int_8)dv;
}

/* --Methode-- */
MuTyV & MuTyV::operator= (MuTyV const & a)
{
  typ = a.typ;  iv = a.iv;  dv = a.dv;  dv_im = a.dv_im; 
  if (typ == 'S')  strv = new string(*(a.strv));
  else strv = NULL;
  return(*this);
}

/* --Methode-- */
char * MuTyV::operator= (char* s)
{
  typ = 'S';
  strv = new string(s);
  mutyv_decodestr(s, dv, dv_im);
  iv = (int_8)dv;
  return(s);
}

/* --Methode-- */
string & MuTyV::operator= (string& s)
{
  typ = 'S';
  strv = new string(s);
  mutyv_decodestr(s.c_str(), dv, dv_im);
  iv = (int_8)dv;
  return(s);
}

/* --Methode-- */
MuTyV::operator string() const 
{
  if (typ == 'S')  return(*strv);
  else {
    char buff[96];
    if (typ == 'I')  sprintf(buff,"%ld", (long)iv);
    else if (typ == 'D') sprintf(buff,"%.20g", dv);
    else if (typ == 'Z') sprintf(buff,"(%.20g , %.20g)", dv, dv_im);
    else buff[0] = '\0';
    return(string(buff));
  }
}


static void mutyv_decodestr(const char * si, double& r, double& im)
  // decodage d'une chaine contenant une ou deux valeurs
{
  r = im = 0.;
  string s = si;
  size_t l = s.length();
  size_t p = s.find_first_not_of(" ()\t",0);
  if (p >= l) return;
  size_t q = s.find_first_of(" ()\t",p+1);
  
  
  if (!isdigit(s[p]) && !(s[p] == '+') && !(s[p] == '-') )
    return;
  r = atof(s.substr(p,q-p).c_str());

  p = s.find_first_not_of(" ()\t",q+1);
  if (p >= l) return;
  q = s.find_first_of(" ()\t",p+1);
  if (!isdigit(s[p]) && !(s[p] == '+') && !(s[p] == '-') )
    return;
  im = atof(s.substr(p,q-p).c_str());
}




