#include "machdefs.h"

#include <math.h>
#include <iostream.h>

#include "tarrinit.h"
#include "array.h"
#include "timing.h"

static int test_ac();
static int test_oso(int r, int c);
static int test_odo(int r, int c);

static int prtlev = 0;
static int nprt = 100;

template <class T>
void getMinMax(TArray<T>& a, T& min, T& max)
{
  min = a[0];
  max = a[0];
  for(uint_8 k=1; k<a.Size(); k++) {
    if (a[k]<min)  min = a[k];
    else if (a[k]>max)  max = a[k];
  }
}

int main(int narg, char* arg[])
{

  SophyaInit();
  InitTim();   // Initializing the CPU timer

  if (narg < 2) {
    cout << " carrt ac/oso/odo [NRow=5] [NCols=10] [prtlev=0] [nprtmax=100] \n"
	 << "   ac : array conversion test   \n" 
	 << "   oso : operation same memory organisation \n" 
	 << "   odo : operation different memory organisation \n" << endl;
    exit(0);
  }

  string opt = arg[1];
  int nr = 5;
  int nc = 10;
  if (narg > 2) nr = atoi(arg[2]);
  if (narg > 3) nc = atoi(arg[3]);
  if (narg > 4) prtlev = atoi(arg[4]);
  if (narg > 5) nprt = atoi(arg[5]);

  BaseArray::SetMaxPrint(nprt, prtlev);
  
  PrtTim(" Start of Test ");
  try {
    if (opt == "ac") test_ac();
    else if (opt == "oso") test_oso(nr, nc);
    else if (opt == "odo") test_odo(nr, nc);
  }
  catch (PThrowable & exc) {
    cerr << " catched Exception " << exc.Msg() << endl;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception " << endl; 
  }  

  PrtTim(" End of Test ");

}


int test_ac()
{
    cout << "\n -----> Testing TArray Conversion <---- " << endl;
     TArray<int_4> ia(7,5);   
     ia = RegularSequence(10., 2.);
     TArray<r_4> ra(7,5);   
     ra = ia;
     cout << " ra = ia(= RegularSequence(10., 2.)) = \n " << ra << endl;
     TArray<r_4> rb(5,3);
     rb =  RegularSequence(20., .5);  
     TMatrix<int_4> mx(3,5);
     cout << " TArray<r_4> rb(5,3); rb =  RegularSequence(20., .5); rb : " << endl;
     cout << rb << endl;
     mx = rb;
     cout << " TMatrix<int_4> mx(3,5);       mx = rb;  mx: " << endl;
     cout << mx << endl;
     TArray<r_4> rc(10);
     rc = 3.1415;
     TMatrix<r_8> mx2(rc);
     cout << "   TArray<r_4> rc(10) = 3.1415 , TMatrix<r_8> mx2(rc) rc : " << endl;
     cout << mx2 << endl;
     TMatrix<int_4> mx3(3,5);
     cout << " Trying      TMatrix<int_4> mx3(3,5);  mx3 = rc; ?? " << endl;
     mx3 = rc;
     return(0);
}

int test_oso(int nr, int nc)
{
  cout << "\n -----> Testing TArray operation TArray<int_4>(nx=" << nr << ",ny=" 
       << nc << " )" << endl;

  int rc = 0;
  int min,max;

  TArray<int_4> a(nr,nc);
  a = 20;
  TArray<int_4> b(nr,nc);
  b = 9;
  TArray<int_4> c = a-2*b;

  if (prtlev > 0) {
    cout << " A = \n " << a << endl;
    cout << " B = \n " << b << endl;
    cout << " C = A-2*B= \n " << c << endl;
  }

  getMinMax(c, min, max);
  if ((min != 2) || (max != 2)) {
    cout << "!!! ERROR Test C=A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 1;
  }
  else cout << " OK   Test C=A+2*B  OK " << endl; 

  c = (a*4+1).DivElt(b);
  if (prtlev > 0) cout << " C = (A*4+1)/B = \n" << c << endl;
  getMinMax(c, min, max);
  if ((min != 9) || (max != 9)) {
    cout << "!!! ERROR Test C = (A*4+1)/B  Min=" << min << " Max=" << max << endl;
    rc += 2;
  }
  else cout << " OK   Test C = (A*4+1)/B  OK " << endl; 
  
  a = RegularSequence(1, 1);
  b = RegularSequence(nr*nc, -1);
  c = (a*2)+(b*2);
  if (prtlev > 0) {
    cout << " A = \n " << a << endl;
    cout << " B = \n " << b << endl;
    cout << " C = 2A-2*B= \n " << c << endl;
  }
  c /= (nr*nc+1);
  getMinMax(c, min, max);
  if ((min != 2) || (max != 2)) {
    cout << "!!! ERROR Test3 C=2A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 1;
  }
  else cout << " OK   Test3 C=2A+2*B  OK " << endl; 
  
  return(rc);
}

int test_odo(int nr, int nc)
{
  cout << "\n -----> Testing TMatrix operation TMatrix<r_4>(nr=" << nr << ",nc=" 
       << nc << " )" << endl;
  cout << "   A CMemoryMapping  - B FortranMemoryMapping " << endl;

  int rc = 0;
  r_4 min,max;

  TMatrix<r_4> a(nr,nc,BaseArray::CMemoryMapping);
  a = 20;
  TMatrix<r_4> b(nr,nc,BaseArray::FortranMemoryMapping);
  b = 9;
  TMatrix<r_4> c(nr,nc,BaseArray::CMemoryMapping);

  if (prtlev > 0) {
    cout << " A = \n " << a << endl;
    cout << " B = \n " << b << endl;
  }
  c = a-(b*2.0f);
  if (prtlev > 0) cout << " C = A-2*B= \n " << c << endl;

  getMinMax(c, min, max);
  if ((fabs(min-2.) > 0.0001) || (fabs(max-2.) > 0.0001)) {
    cout << "!!! ERROR Test C=A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 1;
  }
  else cout << " OK   Test C=A+2*B  OK " << endl; 

  c = (a*4.0f+5.5f).DivElt(b);
  if (prtlev > 0) cout << " C = (A*4+12)/B = \n" << c << endl;
  getMinMax(c, min, max);
  if ((fabs(min-9.5) > 0.0001) || (fabs(max-9.5) > 0.0001)) {
    cout << "!!! ERROR Test C = (A*4+12)/B  Min=" << min << " Max=" << max << endl;
    rc += 2;
  }
  else cout << " OK   Test C = (A*4+12)/B  OK " << endl; 

  a = RegularSequence(1, 1);
  b = RegularSequence(nr*nc, -1);
  c = (a*2.f)+(b*2.f);
  if (prtlev > 0) {
    cout << " A = \n " << a << endl;
    cout << " B = \n " << b << endl;
    cout << " C = 2A-2*B= \n " << c << endl;
  }
  c /= (nr*nc+1);
  getMinMax(c, min, max);
  if ((fabs(min-2.) > 0.0001) || (fabs(max-2.) > 0.0001)) {
    cout << "!!! ERROR Test3 C=2A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 1;
  }
  else cout << " OK   Test3 C=2A+2*B  OK " << endl; 

  return(rc);

}
