// This may look like C code, but it is really -*- C++ -*-
// Adaptateur d objets (pour NamedObjMgr) pour les classes 
// PixelMap/SphericalMap/LocalMap  de Sophya
//                                      Reza 11/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA     
 
#ifndef NOMSKYMAPADAPTER_H_SEEN
#define NOMSKYMAPADAPTER_H_SEEN

#include "nomgadapter.h"
#include "tmatrix.h"
#include "pixelmap.h"



//----------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet PixelMap<T> 
//----------------------------------------------------------------

template <class T> 
class NOMAdapter_PixelMap : public NObjMgrAdapter {
public:
				NOMAdapter_PixelMap(PixelMap<T>* m = NULL);
  virtual			~NOMAdapter_PixelMap();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual string		GetDataObjType();

  virtual AnyDataObj*		CloneDataObj();

  //  virtual void			ReadFits(string const & flnm);
  //  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual P2DArrayAdapter*	Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  virtual void			MeanSig(T& gmoy, T& gsig);
  virtual void			Project_Mol(TMatrix<T> & mtx, T defval=0.);

protected:
  PixelMap<T>* mMap;
};

// Class Interface NTuple pour PixelMap<T>

template <class T> 
class NTupInt_PixelMap : public NTupleInterface {
public:
			NTupInt_PixelMap(PixelMap<T>* m);
  virtual		~NTupInt_PixelMap();
  virtual uint_4        NbLines() const ;
  virtual uint_4        NbColumns() const ;
  virtual r_8 *         GetLineD(int n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  PixelMap<T>* mMap;
  mutable r_8 mRet[8];
};


#endif
