#include <stdio.h>

#include "pibwdggen.h"
#include "pidrawer.h"
#include "pigraphps.h"

// Les methodes de la classe  PIBWdgGen
 
/* --Methode-- */
PIBaseWdgGen::PIBaseWdgGen(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) :
PIWdg(par, nom, sx, sy, px, py)
{
mDrwId=0;   // Compteur des numeros sequentiel des PIDrawer
mAdfg=false;    // Pour controle d'appel de RemoveDrawer()
mWGrC = NULL;   // PIGraphic (Contexte graphique) associe a la fenetre}
                // Doit etre cree par PIBaseWdgX/Mac/... 
SetDefaultDrawRectangle(0., 0., 1., 1., true);
SetDefaultDrawerLimits(0., 1., 0., 1., kAxeDirLtoR, kAxeDirUpDown);
}

/* --Methode-- */
PIBaseWdgGen::~PIBaseWdgGen()
{
delete mWGrC;
DeleteDrawers();
}
 

/* --Methode-- */
void PIBaseWdgGen::Refresh()
{
if ( IsVisible() )  { 
  Draw(mWGrC);
  CallDrawers(mWGrC); 
}
return;
}

// On met une variable pour eviter des boucles infinies entre les deux methodes 
// Draw(PIGraphic* g, int, int, int, int) et Draw(PIGraphic* g) 
static int fgdrawloop = 0;

/* --Methode-- */
void PIBaseWdgGen::Draw(PIGraphic* g, int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
if (fgdrawloop == 0) 
  { fgdrawloop=1;  Draw(g); }
fgdrawloop = 0;
return;
}

/* --Methode-- */
void PIBaseWdgGen::Draw(PIGraphic* g)
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Draw() Efface la fenetre par defaut ! ");
#endif
if (g->kind() != PI_PSFileGraphics) EraseWindow(0, 0, XSize(), YSize());
if (fgdrawloop == 0) 
  { fgdrawloop=2;  Draw(g, 0, 0, XSize(), YSize()); }
fgdrawloop = 0;
return;
}


/* --Methode-- */
void PIBaseWdgGen::Resize()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Resize()  resize notify ");
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::Enter()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Enter() enter notify ");
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::Leave()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Leave() leave notify ");
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::But1Press(int /*x*/, int /*y*/)
{
Send(Msg(), PIMsg_Active);
#ifdef DEBUG_RZXB
printf ("PIBaseWdgGen::But1Press PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::But1Release(int /*x*/, int /*y*/)
{
#ifdef DEBUG_RZXB
printf ("PIBaseWdgGen::ButReleasePosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::But2Press(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But2Release(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But3Press(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But3Release(int /*x*/, int /*y*/)
{
return;
}


/* --Methode-- */
void PIBaseWdgGen::Ptr1Move(int /*x*/, int /*y*/)
{
#ifdef DEBUG_RZXB
printf ("Debug_PIBaseWdgGen::Ptr1Move PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::Ptr2Move(int /*x*/, int /*y*/)
{
return;
}


/* --Methode-- */
void PIBaseWdgGen::Ptr3Move(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::Keyboard(int /*key*/, PIKeyModifier /*kmod*/)
{
#ifdef DEBUG_RZXB
printf("PIBaseWdgGen::Keyboard: Key= %d (%c)  Mod= %d \n", key, (char)key, (int)kmod); 
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::PSPrint(PSFile * psf, int ofx, int ofy)
{
if (!psf) return;
PIGraphicPS grpsf(psf, (PIWdg *)this, ofx, ofy);
Draw(&grpsf);
CallDrawers(&grpsf); 
return;
}

/* --Methode-- */
void PIBaseWdgGen::SetDefaultDrawRectangle(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, bool psz)
{
mDrX1 = x1;  mDrY1 = y1;
mDrX2 = x2;  mDrY2 = y2;   mDrElastic = psz;
}

/* --Methode-- */
void PIBaseWdgGen::SetDefaultDrawerLimits(float xmin, float xmax, float ymin, float ymax,
                                          int axrl, int ayud)
{
mDrXmin = xmin;   mDrXmax = xmax; 
mDrYmin = ymin;   mDrYmax = ymax; 
mDXdir = axrl;    mDYdir = ayud;
}


/* --Methode-- */
int PIBaseWdgGen::AddDrawer(PIDrawer* drw, PIGrCoord x1, PIGrCoord y1,  
                            PIGrCoord x2, PIGrCoord y2, bool psz, bool clip, bool ad)
{
if (drw == NULL)   return(0);
mDrwId++;
BWDrwId did;
did.x1 = x1;  did.y1 = y1;
did.x2 = x2;  did.y2 = y2;
did.autoszp = did.autolim = false;   
did.elastic = psz;  did.clip = clip;
did.id = mDrwId;  did.ad = ad; 
did.drw = drw;
mDrwList.push_back(did);
drw->Attach(this, mDrwId);
return(mDrwId);
}

/* --Methode-- */
int PIBaseWdgGen::AddDrawer(PIDrawer* drw, bool autolim, bool clip, bool ad)
{
if (drw == NULL)   return(0);
mDrwId++;
BWDrwId did;
did.x1 = 0.;  did.y1 = 0.;
did.x2 = 1.;  did.y2 = 1.;
did.autoszp = true;   did.autolim = autolim;   
did.elastic = false;   did.clip = clip;
did.id = mDrwId;  did.ad = ad; 
did.drw = drw;
mDrwList.push_back(did);
drw->Attach(this, mDrwId);
return(mDrwId);
}


/* --Methode-- */
void PIBaseWdgGen::MoveResizeDrawer(int id,  PIGrCoord x1, PIGrCoord y1,  PIGrCoord x2, PIGrCoord y2, bool psz)
{
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id) { 
    (*it).x1 = x1;  (*it).y1 = y1;
    (*it).x2 = x2;  (*it).y2 = y2;
    (*it).elastic = psz;
    break;
  }
return;
}

/* --Methode-- */
void PIBaseWdgGen::RemoveDrawer(int id)
{
if (mAdfg)  return;
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)
  if ((*it).id == id) 
    { (*it).drw->Detach(this, id); mDrwList.erase(it); break; }
return;
}

/* --Methode-- */
void PIBaseWdgGen::DeleteDrawers()
{
mAdfg = true;
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).ad)  delete (*it).drw;
mDrwList.erase(mDrwList.begin(), mDrwList.end() );
mAdfg = false;
return;
}

/* --Methode-- */
int PIBaseWdgGen::NbDrawers()
{
return(mDrwList.size());
}


/* --Methode-- */
PIDrawer* PIBaseWdgGen::GetDrawer(int n)
{
if ( (n < 0) || (n >= mDrwList.size()) ) return(NULL);
return(mDrwList[n].drw);
}

/* --Methode-- */
PIDrawer* PIBaseWdgGen::GetDrawerId(int id)
{
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id)  return((*it).drw);
return(NULL);
}


/* --Methode-- */
void PIBaseWdgGen::CallDrawers(PIGraphicGen* g, int x0, int y0, int dx, int dy)
{
float xmin,ymin, xmax, ymax;
PIGraphicUC* guc;
int drx0, dry0, drdx, drdy;
int ddrx0, ddry0, ddrdx, ddrdy;

if (mDrElastic) { 
  ddrx0 = (int)((float) mDrX1 * (float)XSize());
  ddry0 = (int)((float) mDrY1 * (float)YSize());
  ddrdx = (int)((float) mDrX2 * (float)XSize()) - ddrx0 ;
  ddrdy = (int)((float) mDrY2 * (float)YSize()) - ddry0 ;
  }
else {
  ddrx0 = (int)mDrX1;   ddry0 = (int)mDrY1;  
  ddrdx = (int)mDrX2-ddrx0;   ddrdy = (int)mDrY2-ddry0;  
  }

bool sxy = false;
if ((dx > 0) && (dy > 0))  sxy = true;

vector<BWDrwId>::iterator it;
bool fgc=false;
for(it = mDrwList.begin(); it != mDrwList.end(); it++) {
  g->SaveGraphicAtt();
  if ( (*it).autoszp )   // Taille/position  par defaut impose par PIBaseWdg 
    { drx0 = ddrx0;  dry0 = ddry0;   drdx = ddrdx;  drdy = ddrdy; } 
  else {
    if ( (*it).elastic  ) {   // Taille/position defin en fraction de la taille du PIBaseWdg
      drx0 = (int)((float)(*it).x1 * (float)XSize());
      dry0 = (int)((float)(*it).y1 * (float)YSize());
      drdx = (int)((float)(*it).x2 * (float)XSize()) - drx0 ;
      drdy = (int)((float)(*it).y2 * (float)YSize()) - dry0 ;
      }
    else {
      drx0 = (int)(*it).x1 ;  dry0 = (int)(*it).y1 ; 
      drdx = (int)(*it).x2-drx0 ;  drdy = (int)(*it).y2-dry0 ; 
      }
    }
// L'ordre des operations ici est importante 
  if ( (*it).autolim )  
     (*it).drw->SetLimits(mDrXmin, mDrXmax, mDrYmin, mDrYmax, mDXdir, mDYdir);     
  guc = (*it).drw->SetDrwWdg(this, drx0, dry0, drdx, drdy, g);
  if ((*it).clip)  { g->SetClipRectangle(drx0, dry0, drdx , drdy);  fgc = true; }
  (*it).drw->SelGraAtt(guc);
  if (sxy) {
    guc->GrC2UC(x0, y0, xmin, ymin);
    guc->GrC2UC(x0+dx, y0+dy, xmax, ymax);
    }
  else {
    guc->GrC2UC(0, 0, xmin, ymin);
    guc->GrC2UC(XSize(), YSize(), xmax, ymax);    
    } 
  if (xmin > xmax)  swap(xmin,xmax);
  if (ymin > ymax)  swap(ymin,ymax);
  (*it).drw->Draw(guc, xmin, ymin, xmax, ymax);
  g->RestoreGraphicAtt();
  }
if (fgc)  g->ClearClipRectangle();

return;
}

/* --Methode-- */
void PIBaseWdgGen::CallDrawer(int id)
{
float xmin,ymin, xmax, ymax;
PIGraphicUC* guc;
int drx0, dry0, drdx, drdy;
int ddrx0, ddry0, ddrdx, ddrdy;

PIGraphic* g = WindowGraphic();

if (mDrElastic) { 
  ddrx0 = (int)((float) mDrX1 * (float)XSize());
  ddry0 = (int)((float) mDrY1 * (float)YSize());
  ddrdx = (int)((float) mDrX2 * (float)XSize()) - ddrx0 ;
  ddrdy = (int)((float) mDrY2 * (float)YSize()) - ddry0 ;
  }
else {
  ddrx0 = (int)mDrX1;   ddry0 = (int)mDrY1;  
  ddrdx = (int)mDrX2-ddrx0;   ddrdy = (int)mDrY2-ddry0;  
  }
vector<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++) 
  if ((*it).id == id) {
    g->SaveGraphicAtt();
    if ( (*it).autoszp )   // Taille/position  par defaut impose par PIBaseWdg 
      { drx0 = ddrx0;  dry0 = ddry0;   drdx = ddrdx;  drdy = ddrdy; } 
    else {
      if ( (*it).elastic  ) {   // Taille/position defin en fraction de la taille du PIBaseWdg
        drx0 = (int)((float)(*it).x1 * (float)XSize());
        dry0 = (int)((float)(*it).y1 * (float)YSize());
        drdx = (int)((float)(*it).x2 * (float)XSize()) - drx0 ;
        drdy = (int)((float)(*it).y2 * (float)YSize()) - dry0 ;
        }
      else {
        drx0 = (int)(*it).x1 ;  dry0 = (int)(*it).y1 ; 
        drdx = (int)(*it).x2-drx0 ;  drdy = (int)(*it).y2-dry0 ; 
        }
      }
// L'ordre des operations ici est importante 
    if ( (*it).autolim ) 
       (*it).drw->SetLimits(mDrXmin, mDrXmax, mDrYmin, mDrYmax, mDXdir, mDYdir);
    guc = (*it).drw->SetDrwWdg(this, drx0, dry0, drdx, drdy, g);
    if ((*it).clip)  g->SetClipRectangle(drx0, dry0, drdx , drdy);
    (*it).drw->SelGraAtt(guc);
    guc->GrC2UC(0, 0, xmin, ymin);
    guc->GrC2UC(XSize(), YSize(), xmax, ymax);     
    if (xmin > xmax)  swap(xmin,xmax);
    if (ymin > ymax)  swap(ymin,ymax);
    (*it).drw->Draw(guc, xmin, ymin, xmax, ymax);
    g->RestoreGraphicAtt();    
    if ((*it).clip)  g->ClearClipRectangle();
    break;
  }
return;
}


/* --Methode-- */
PIGraphic* PIBaseWdgGen::WindowGraphic()
{
return(mWGrC);
}
