// Module PI : Peida Interactive PIDrawer3D PIDraw3DWdg
// Drawer et DrawWidget 3D       R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "pi3ddrw.h"
#include "pidrwtools.h"


// ......................................................................
// ........................  Classe PIDrawer3D ..........................
// ......................................................................


/* --Methode-- */
PIDrawer3D::PIDrawer3D()
        : PIDrawer()
{
  xO = yC = 0.; zO = -10.;
  xC = yC = zC = 0.;
  tO = fO = pO = 0.; 
  daxO = dayO = 0.25;
  lCO = 10.;  dlCO = 3.;  
  v3D_obs = false;
}

/* --Methode-- */
PIDrawer3D::~PIDrawer3D()
{
}

/* --Methode-- */
void PIDrawer3D::Set3DView_Obs(float xo, float yo, float zo, float teta, float phi, float psi, 
                               float dax, float day, float co, float dco)
{
  tO = teta;  fO = phi;  pO = psi;
  daxO = dax;  dayO = day;
  lCO = co;   dlCO = dco;
  v3D_obs = true;
}

/* --Methode-- */
void PIDrawer3D::Set3DView(float xc, float yc, float zc, float xo, float yo, float zo, 
                           float dax, float day, float dco, float psi)
{
  xC = xc;  yC = yc;  zC = zc;
  xO = xo;  yO = yo;  zO = zo;
  pO = psi;
  daxO = dax;  dayO = day;
  dlCO = dco;
  v3D_obs = false;
}

/* --Methode-- */
bool PIDrawer3D::Get3DView(float& xc, float& yc, float& zc, float& xo, float& yo, float& zo,
                           float& teta, float& phi, float& psi, float& dax, float& day, float& co, float& dco)
{
  xo = xO;  yo = yO;  zo = zO;
  xc = xC;  yc = yC;  zc = zC;
  teta = tO;  phi = fO;  psi = pO;
  dax = daxO;   day = dayO;
  co = lCO;     dco = dlCO;
  return(v3D_obs);
}

/* --Methode-- */
PIGraphicUC* PIDrawer3D::SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy, PIGraphicGen* g)
{
  mBWdg = drw;
  xW0 = x0;   yW0 = y0;
  xWd = dx;   yWd = dy;
  if (mGrUC)  delete mGrUC;
  PIGraphic3D* gr3d;
  gr3d = new PIGraphic3D(g, x0, y0, dx, dy);
  if (v3D_obs)  gr3d->Set3DCS_Obs(xO, yO, zO, tO, fO, pO, daxO, dayO, lCO, dlCO);
  else  gr3d->Set3DCS(xC,yC,zC, xO, yO, zO, daxO, dayO, dlCO, pO);
  mGrUC = gr3d;
  return(gr3d); 
}



// ......................................................................
// ........................  Classe PIDrawer3D ..........................
// ......................................................................


/* --Methode-- */
PIDraw3DWdg::PIDraw3DWdg(PIContainerGen *par, char *nom, int sx, int sy, int px, int py)
        : PIBaseWdg(par, nom, sx, sy, px, py)
{
  vfixed = false;
  SetDefaultDrawRectangle(0., 0., 1., 1., true);

  lPx = lPy = 0;
  lCol = PI_Black;
  cTeta = cPhi = 0.;  cUlen = 1.;

  ActivateButton(2);    //  Pour pouvoir tourner la camera
  ActivateMove(2);      
  ActivateButton(3);    //  Pour deplacer la camera le long de son axe
  ActivateMove(3);
  ActivateButton(1);    

  mGr3d = new PIGraphic3D(mWGrC, 0, 0, sx, sy);
}

/* --Methode-- */
PIDraw3DWdg::~PIDraw3DWdg()
{
  delete mGr3d;
}

/* --Methode-- */
void PIDraw3DWdg::Set3DView_Obs(float xo, float yo, float zo, float teta, float phi, float psi, 
                                float dax, float day, float co, float dco)
{
  mGr3d->Set3DCS_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  list<int>::iterator it;
  for(it = m3DrIl.begin(); it != m3DrIl.end(); it++)   
#if defined(__GNUC__) && !defined(GCCV28)
    ((PIDrawer3D*)(GetDrawerId(*it)))->Set3DView_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
#else
    (dynamic_cast<PIDrawer3D*>(GetDrawerId(*it)))->Set3DView_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
#endif
  vfixed = true;
}

/* --Methode-- */
void PIDraw3DWdg::Set3DView(float xc, float yc, float zc, float xo, float yo, float zo, 
                            float dax, float day, float dco, float psi)
{
  mGr3d->Set3DCS(xc, yc, zc, xo, yo, zo, dax, day, dco, psi);
  list<int>::iterator it;
  for(it = m3DrIl.begin(); it != m3DrIl.end(); it++)   
#if defined(__GNUC__) && !defined(GCCV28)
    ((PIDrawer3D*)(GetDrawerId(*it)))->Set3DView(xc, yc, zc, xo, yo, zo, dax, day, dco, psi);
#else
    (dynamic_cast<PIDrawer3D*>(GetDrawerId(*it)))->Set3DView(xc, yc, zc, xo, yo, zo, dax, day, dco, psi);
#endif
  vfixed = true;
}

/* --Methode-- */
bool PIDraw3DWdg::Get3DView(float& xc, float& yc, float& zc, float& xo, float& yo, float& zo, 
                            float& teta, float& phi, float& psi, float& dax, float& day, float& co, float& dco)
{
  return(mGr3d->Get3DCS(xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco));
}

/* --Methode-- */
void PIDraw3DWdg::Update3DView()
{
  float xc, yc, zc, xo, yo, zo;
  float teta, phi, psi;
  float dax, day, co, dco;
  bool vo;
  vo = mGr3d->Get3DCS( xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  list<int>::iterator it;
#if defined(__GNUC__) && !defined(GCCV28)
  if (vo)   for(it = m3DrIl.begin(); it != m3DrIl.end(); it++)   
    ((PIDrawer3D*)(GetDrawerId(*it)))->Set3DView_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  else   for(it = m3DrIl.begin(); it != m3DrIl.end(); it++)   
    ((PIDrawer3D*)(GetDrawerId(*it)))->Set3DView(xc, yc, zc, xo, yo, zo, dax, day, dco, psi);    
#else
  if (vo)   for(it = m3DrIl.begin(); it != m3DrIl.end(); it++)   
    (dynamic_cast<PIDrawer3D*>(GetDrawerId(*it)))->Set3DView_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  else   for(it = m3DrIl.begin(); it != m3DrIl.end(); it++)   
    (dynamic_cast<PIDrawer3D*>(GetDrawerId(*it)))->Set3DView(xc, yc, zc, xo, yo, zo, dax, day, dco, psi);    
#endif

}

/* --Methode-- */
int PIDraw3DWdg::AddDrawer3D(PIDrawer3D* dr3, bool ad)
{
if (!vfixed)  { 
  dr3->UpdateSize();
  float xo, yo, zo, xc, yc, zc, teta, phi, psi, dax, day, co, dco;
  bool vobs;
  vobs = dr3->Get3DView(xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  if (vobs) Set3DView_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  else Set3DView(xc, yc, zc, xo, yo, zo, dax, day, dco, psi);
  }
else { 
  float xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco;
  if ( Get3DView(xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco) ) 
      dr3->Set3DView_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  else  dr3->Set3DView(xc, yc, zc, xo, yo, zo, dax, day, co, psi);
  }
int id = AddDrawer(dr3, false, false, ad);
m3DrIl.push_back(id);
return(id);
}

/* --Methode-- */
void PIDraw3DWdg::RemoveDrawer(int id)
{
  list<int>::iterator it;
  for(it = m3DrIl.begin(); it != m3DrIl.end(); it++)   
    if ( (*it) == id )  { m3DrIl.erase(it);  break; }
  PIBaseWdg::RemoveDrawer(id);
}

/* --Methode-- */
void PIDraw3DWdg::DeleteDrawers()
{
  m3DrIl.erase(m3DrIl.begin(),  m3DrIl.end());
  PIBaseWdg::DeleteDrawers();
}

/* --Methode-- */
void PIDraw3DWdg::But2Press(int x, int y)
{
  mGr3d->SetBaseGraphic(mWGrC, 0, 0, XSize(), YSize());
  float xc, yc, zc, xo, yo, zo;
  float teta, phi, psi;
  float dax, day, co, dco;
  mGr3d->Get3DCS(xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco);
//   puts("\n PIDraw3DWdg::But2Press() ");
//   mGr3d->PrintCS();
  lPx = x;  lPy = y;    
  cUlen = 0.5*(dax+day)*co*0.3;    cDax = dax;   cDay = day;  clCO = co; 
  cTeta = teta;   cPhi = phi;
  SelPointerShape(PI_TDLRArrowPointer);
  lCol = mWGrC->GetForeground();
  //  mWGrC->SelForeground(GetBackgroundColor());
  mWGrC->SelForeground(PI_Magenta);
/*
  {
  char buff[256];
  sprintf(buff, "But2Press() C=%g %g %g  T,P=%g %g   ", xc, yc, zc, cTeta, cPhi); 
  mWGrC->DrawOpaqueString(0,20,buff);
  }
*/
  DrawXYZAxes();
  Send(Msg(), PIMsg_Active);
  PIDrwTools::SetCurrentBaseWdg(this);
}

/* --Methode-- */
void PIDraw3DWdg::Ptr2Move(int x, int y)
{
  DrawXYZAxes();
  float phi = M_PI+cPhi;
  float teta = M_PI-cTeta;
  phi += (M_PI*0.4*(float)(x-lPx)/XSize());
  teta -= (M_PI*0.4*(float)(y-lPy)/YSize());
  mGr3d->RotateObserver(teta, phi, 0., false);
/*  {
  char buff[256];
  sprintf(buff, "Ptr2Move() T,P=%g %g -> %g %g  ", cTeta, cPhi, teta, phi); 
  mWGrC->DrawOpaqueString(0,20,buff);
  }
*/
  DrawXYZAxes();
}


/* --Methode-- */
void PIDraw3DWdg::But2Release(int x, int y)
{
  DrawXYZAxes();
//  puts("\n PIDraw3DWdg::But2Release()");
//  mGr3d->PrintCS();
  SelPointerShape(PI_ArrowPointer);
  mWGrC->SelForeground(lCol);
  Update3DView();
  Refresh();
}


/* --Methode-- */
void PIDraw3DWdg::But3Press(int x, int y)
{
  float xc, yc, zc, xo, yo, zo;
  float teta, phi, psi;
  float dax, day, co, dco;
  mGr3d->Get3DCS(xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  mGr3d->SetBaseGraphic(mWGrC, 0, 0, XSize(), YSize());
  lPx = x;  lPy = y;  
  cUlen = 0.5*(dax+day)*co*0.3;    cDax = dax;   cDay = day;  clCO = co;
  cTeta = teta;   cPhi = phi;
  SelPointerShape(PI_TDLRArrowPointer);
  lCol = mWGrC->GetForeground();
  //  mWGrC->SelForeground(GetBackgroundColor());
  mWGrC->SelForeground(PI_Magenta);
/*
  {
  char buff[256];
  sprintf(buff, "But3Press() C=%g %g %g  O= %g %g %g  L= %g   ", xc, yc, zc, xo, yo, zo, co); 
  mWGrC->DrawOpaqueString(0,20,buff);
  }
*/
  DrawXYZAxes();
  Send(Msg(), PIMsg_Active);
  PIDrwTools::SetCurrentBaseWdg(this);
}

/* --Methode-- */
void PIDraw3DWdg::Ptr3Move(int x, int y)
{
  DrawXYZAxes();
  float rapx = (float)(x-lPx)/XSize();
  if (rapx > 0.) rapx = rapx*2.+1;
  else rapx += 1.;
  if (rapx < 0.3)  rapx = 0.3;
  if (rapx > 3.)  rapx = 3.;
  float rapy = (float)(y-lPy)/YSize();
  if (rapy > 0.) rapy = rapy*2.+1;
  else rapy += 1.;
  if (rapy < 0.3)  rapy = 0.3;
  if (rapy > 3.)  rapy = 3.;
/*
  {
  char buff[256];
  sprintf(buff, "Ptr3Move() Rap=%g %g -> %g %g %g     ", rapx, rapy, rapy*clCO, rapx*cDax, rapx*cDay);
  mWGrC->DrawOpaqueString(0,20,buff);
  }
*/
  mGr3d->ZoomInOut(rapy*clCO, rapx*cDax, rapx*cDay, false);
  DrawXYZAxes();
}

/* --Methode-- */
void PIDraw3DWdg::But3Release(int x, int y)
{
  DrawXYZAxes();
  SelPointerShape(PI_ArrowPointer);
  mWGrC->SelForeground(lCol);
  Update3DView();
  Refresh();
}


/* --Methode-- */
void PIDraw3DWdg::DrawXYZAxes()
{
  mWGrC->SelGOMode(PI_GOXOR);
  PIGrCoord x1,y1,z1,x2,y2,z2;
  float xc,yc,zc,xo,yo,zo,teta,phi,psi,dax,day,co,dco;
  mGr3d->Get3DCS(xc,yc,zc,xo,yo,zo,teta,phi,psi,dax,day,co,dco);
  float len = cUlen;
  x1 = xc;  y1 = yc;  z1 = zc;
  x2 = xc+len;   y2 = yc;   z2 = zc; 
  mGr3d->DrawLine3D(x1, y1, z1, x2, y2, z2);
  x2 = xc+len*1.1;
  mGr3d->DrawString3D(x2, y2, z2, "X");
  x2 = xc;   y2 = yc+len;   z2 = zc; 
  mGr3d->DrawLine3D(x1, y1, z1, x2, y2, z2);
  y2 = yc+len*1.1;
  mGr3d->DrawString3D(x2, y2, z2, "Y");   
  x2 = xc;   y2 = yc;   z2 = zc+len; 
  mGr3d->DrawLine3D(x1, y1, z1, x2, y2, z2);
  z2 = zc+len*1.1;
  mGr3d->DrawString3D(x2, y2, z2, "Z");   
//   mGr3d->DrawCircle(0., 0., daxO*0.30);
  char buff[256];
  sprintf(buff, " C: %g %g %g -> O: %g %g %g  (T/P0= %g %g)     ", xc,yc,zc, xo, yo, zo, cTeta, cPhi);
  mWGrC->DrawString(0,20,buff);
  sprintf(buff, " T,P= %g %g %g lCO= %g  dax= %g %g UL=%g    ", teta,phi,psi,co,dax,day,cUlen); 
  mWGrC->DrawString(0,40,buff);
  mWGrC->SelGOMode(PI_GOCopy);  

}


/* --Methode-- */
void PIDraw3DWdg::But1Press(int x, int y)
{
  Send(Msg(), PIMsg_Active);
  PIDrwTools::SetCurrentBaseWdg(this);
  if ( (x > 50) || ( y > 50) ) return; 
  list<int>::iterator it = m3DrIl.begin();
  if (it == m3DrIl.end())  return;
#if defined(__GNUC__) && !defined(GCCV28)
  PIDrawer3D* dr3 = (PIDrawer3D*)(GetDrawerId(*it));
#else
  PIDrawer3D* dr3 = dynamic_cast<PIDrawer3D*>(GetDrawerId(*it));
#endif
  if (dr3 == NULL)  return;
  dr3->UpdateSize();
  float xo, yo, zo, xc, yc, zc, teta, phi, psi, dax, day, co, dco;
  bool vobs;
  vobs = dr3->Get3DView(xc, yc, zc, xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  if (vobs) Set3DView_Obs(xo, yo, zo, teta, phi, psi, dax, day, co, dco);
  else Set3DView(xc, yc, zc, xo, yo, zo, dax, day, dco, psi);
  Refresh();
}

/*   Pour debugger sur bouton-3 
static int isw = 0;
void PIDraw3DWdg::But3Press(int x, int y)
x -= XSize()/2;
y -= YSize()/2;

float fx = (float)x/XSize(); 
float fy = (float)y/YSize(); 
if ( (fx<0.2) && (fx>-0.2) && (fy<0.2) && (fy>-0.2) ) {
  
  if ((isw%3) == 0) { 
    Set3DView(0., 0., 0., 0., 0., -3. , 0.3, 0.3, 2); 
    puts("\n Set3DView(0., 0., 0., 0., 0., -3. , 0.3, 0.3, 2)");
  }
  else if ((isw%3) == 1) { 
    Set3DView(0., 0., 0., 2., 1., 3. , 0.3, 0.3, 2);
    puts("\n Set3DView(0., 0., 0., 2., 1., 3. , 0.3, 0.3, 2)");
  }
  else if ((isw%3) == 2) { 
    Set3DView_Obs(0.,4.,0.,3.14159/2.,-3.14159/2.,0.,0.25,0.25,4.,2.);
    puts("\n Set3DView_Obs(0.,4.,0.,3.14159/2.,3.14159/2.,0.,0.25,0.25,4.,2.)");
  }
  isw++;
  mGr3d->PrintCS();
  float xc,yc,zc,xo,yo,zo,teta,phi,psi,dax,day,co,dco;
  mGr3d->Get3DCS(xc,yc,zc,xo,yo,zo,teta,phi,psi,dax,day,co,dco);
  mGr3d->Set3DCS(xc,yc,zc,xo,yo,zo,dax,day,dco,psi);
  mGr3d->PrintCS();
  mGr3d->Set3DCS_Obs(xo,yo,zo,teta,phi,psi,dax,day,co,dco);
  mGr3d->PrintCS();
  puts(" --------------------- \n");
  Refresh();
  return;
}
if ((x > 0) && (y > 0) )  { 
  puts(" But3Press()Set3DView(0., 0., 0., 5., 0., 0. , 0.3, 0.3, 2)");
  Set3DView(0., 0., 0., 5., 0., 0. , 0.3, 0.3, 2);
}
else if ((x < 0) && (y > 0) )  { 
  puts(" But3Press()Set3DView(0., 0., 0., 0., 5., 1. , 0.3, 0.3, 2) ");
  Set3DView(0., 0., 0., 0., 5., 1. , 0.3, 0.3, 2);
}
else  if ((x < 0) && (y < 0) ) {
  puts(" But3Press()Set3DView(0., 0., 0., 1., 1., 5. , 0.3, 0.3, 2)");
  Set3DView(0., 0., 0., 1., 1., 5. , 0.3, 0.3, 2);
}
else {
  puts(" But3Press()Set3DView(0., 0., 0., -3., -3., 3. , 0.3, 0.3, 2)");
  Set3DView(0., 0., 0., -3., -3., 3. , 0.3, 0.3, 2);
}

Refresh();
*/
