// This may look like C code, but it is really -*- C++ -*-
// Outils de manipulation des PIDrawer  R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdlib.h>

#include "pidrwtools.h"
#include "piscdrawwdg.h"


PIDrwTools* PIDrwTools::cwdrwt = NULL;
PIBaseWdgGen* PIDrwTools::mCurBW = NULL;

/* --Methode-- */
void PIDrwTools::ShowPIDrwTools() 
{
if (cwdrwt == NULL)  cwdrwt = new PIDrwTools(PIApplicationGetApp());
cwdrwt->Show();
}

/* --Methode-- */
void PIDrwTools::SetCurrentBaseWdg(PIBaseWdgGen* cbw)
{
mCurBW = cbw;
if (cwdrwt)  { 
  cwdrwt->mNlb->SetLabel("0");  
  cwdrwt->mNDr = 0; 
  }
}
/* --Methode-- */
PIBaseWdgGen* PIDrwTools::GetCurrentBaseWdg()
{
return(mCurBW);
}

/* --Methode-- */
PIDrwTools::PIDrwTools(PIApplication* par)
: PIWindow((PIMsgHandler*)par, "PIDrawerTools", PIWK_dialog, 240, 240, 150, 150)
{
int bsx, bsy, spx, spy;

// On definit la taille a partir de la taille par defaut des composantes 
// PIApplicationPrefCompSize(bsx, bsy);
par->PrefCompSz(bsx, bsy);
spx = bsx/10;
spy = bsy/4;

int wszx = 5*spx+3.5*bsx; 
int wszy = (6+3*0.85)*(spy+bsy);
SetSize(wszx, wszy);

int cpx = spx*2;
int cpy = spy*2;
int csx = cpx;
int csy = cpy;
mLab[0] = new PILabel(this, "X Min Max", 1.5*bsx, bsy, cpx, cpy);
cpy += spy+bsy; 
mLab[1] = new PILabel(this, "Y Min Max", 1.5*bsx, bsy, cpx, cpy);
mLab[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mLab[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

cpy = spy*2;
cpx += spx+1.5*bsx; 
mText[0] = new PIText(this, "x_min_max", 2.0*bsx, bsy, cpx, cpy);
mText[0]->SetText("-1.0  1.0");
cpy += spy+bsy; 
mText[1] = new PIText(this, "y_min_max", 2.0*bsx, bsy, cpx, cpy);
mText[1]->SetText("-1.0  1.0");
mText[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mText[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

cpx = 2*spx;
cpy += spy+bsy; 
mCkb[0] = new PICheckBox(this,"AxeX-RtoL", 2000, 1.5*bsx, bsy, cpx, cpy);
cpx += spx+1.5*bsx; 
mCkb[1] = new PICheckBox(this,"AxeY-UpDown", 2000, 1.5*bsx, bsy, cpx, cpy);
mCkb[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mCkb[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

cpy += spy+bsy; 
cpx = 4*spx;;
mBut[0] = new PIButton(this, "Apply", 2500, bsx*1.5, bsy, cpx, cpy);
cpx += bsx*1.5+2*spx;
mBut[1] = new PIButton(this, "Dismiss", 2600,  bsx*1.5, bsy, cpx, cpy);
mBut[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mBut[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

int offy = cpy+bsy+spy*2;

//  Option-Menu  Marker, Line, couleur, etc...
cpx = 2*spx;
cpy += 3*spy+bsy;

int bsyo = bsy;  
int spyo = spy; 
bsy = 0.85*bsy;   spy = 0.85*spy;

mOpt[0] = new PIOptMenu(this, "bwt-opt-0", bsx*1.75, bsy, cpx, cpy);
mOpt[0]->AppendItem("Black", 101);
mOpt[0]->AppendItem("White", 102);
mOpt[0]->AppendItem("Grey", 103);
mOpt[0]->AppendItem("Red", 104);
mOpt[0]->AppendItem("Blue", 105);
mOpt[0]->AppendItem("Green", 106);
mOpt[0]->AppendItem("Yellow", 107);
mOpt[0]->AppendItem("Magenta", 108);
mOpt[0]->SetValue(101);
mOpt[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += spx+1.75*bsx; 
mOpt[1] = new PIOptMenu(this, "bwt-opt-1", bsx*1.75, bsy, cpx, cpy);
mOpt[1]->AppendItem("NoColor", 200);
mOpt[1]->AppendItem("Grey32", 201);
mOpt[1]->AppendItem("GreyInv32", 202);
mOpt[1]->AppendItem("ColRJ32", 203);
mOpt[1]->AppendItem("ColBR32", 204);
mOpt[1]->AppendItem("ColRV32", 205);
mOpt[1]->AppendItem("Grey128", 206);
mOpt[1]->AppendItem("GreyInv128", 207);
mOpt[1]->AppendItem("ColRJ128", 208);
mOpt[1]->AppendItem("ColBR128", 209);
mOpt[1]->AppendItem("Col16", 210);
mOpt[1]->SetValue(200);
mOpt[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);


cpx = 2*spx;
cpy += spy+bsy;
mOpt[2] = new PIOptMenu(this, "bwt-opt-2", bsx*1.75, bsy, cpx, cpy);
mOpt[2]->AppendItem("Undef-Mrk", 300);
mOpt[2]->AppendItem("Mrk Dot(.)", 301);
mOpt[2]->AppendItem("Mrk Plus(+)", 302);
mOpt[2]->AppendItem("Mrk Cross(x)", 303);
mOpt[2]->AppendItem("Mrk Circle", 304);
mOpt[2]->AppendItem("Mrk FCircle", 305);
mOpt[2]->AppendItem("Mrk Box", 306);
mOpt[2]->AppendItem("Mrk FBox", 307);
mOpt[2]->AppendItem("Mrk Triangle", 308);
mOpt[2]->AppendItem("Mrk FTriangle", 309);
mOpt[2]->AppendItem("Mrk Star", 310);
mOpt[2]->AppendItem("Mrk FStar", 311);
mOpt[2]->SetValue(301);
mOpt[2]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += spx+1.75*bsx; 
mOpt[3] = new PIOptMenu(this, "bwt-opt-3", bsx*1.75, bsy, cpx, cpy);
mOpt[3]->AppendItem("Mrk 3 pt", 403);
mOpt[3]->AppendItem("Mrk 5 pt", 405);
mOpt[3]->AppendItem("Mrk 7 pt", 407);
mOpt[3]->AppendItem("Mrk 9 pt", 409);
mOpt[3]->AppendItem("Mrk 11 pt", 411);
mOpt[3]->AppendItem("Mrk 13 pt", 413);
mOpt[3]->AppendItem("Mrk 15 pt", 415);
mOpt[3]->SetValue(405);
mOpt[3]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx = 2*spx;
cpy += spy+bsy;
mOpt[4] = new PIOptMenu(this, "bwt-opt-4", bsx*1.75, bsy, cpx, cpy);
mOpt[4]->AppendItem("Normal-Font", 500);
mOpt[4]->AppendItem("Bold-Font", 501);
mOpt[4]->AppendItem("Ital-Font", 502);
mOpt[4]->AppendItem("Small-Font", 510);
mOpt[4]->AppendItem("Small-Bold-Font", 511);
mOpt[4]->AppendItem("Small-Ital-Font", 512);
mOpt[4]->AppendItem("Big-Font", 521);
mOpt[4]->AppendItem("Big-Bold-Font", 522);
mOpt[4]->AppendItem("Big-Ital-Font", 523);
mOpt[4]->SetValue(500);
mOpt[4]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += spx+1.75*bsx; 
mOpt[5] = new PIOptMenu(this, "bwt-opt-5", bsx*1.75, bsy, cpx, cpy);
mOpt[5]->AppendItem("Undef-Line", 600);
mOpt[5]->AppendItem("Thin-Line", 601);
mOpt[5]->AppendItem("Normal-Line", 602);
mOpt[5]->AppendItem("Thick-Line", 603);
mOpt[5]->SetValue(601);
mOpt[5]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx = 2*spx;
cpy += spy+bsyo;
bsy = bsyo; spy = spyo;
mButdr[0] = new PIButton(this, "Dr-", 3501, bsy, bsy, cpx, cpy, PIBtn_ArrowLeft);
cpx += bsy+0.25*spy;
mNlb = new PILabel(this,"NumDr", bsy, bsy, cpx, cpy);
mNlb->SetLabel("0");
mNDr = 0;
cpx += bsy+0.25*spy;
mButdr[1] = new PIButton(this, "Dr+", 3502, bsy, bsy, cpx, cpy, PIBtn_ArrowRight);
mButdr[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
mButdr[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
mNlb->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += bsy+3*spx;
mButcf[0] = new PIButton(this, "SetAtt", 2800, bsx*0.85, bsy, cpx, cpy);
cpx += 0.85*bsx+spx;
mButcf[1] = new PIButton(this, "Refresh", 2900, bsx*0.85, bsy, cpx, cpy);
mButcf[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
mButcf[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cwdrwt = this;

}

/* --Methode-- */
PIDrwTools::~PIDrwTools()
{
if (cwdrwt == this)  cwdrwt = NULL;
for(int i=0; i<2; i++)
  {
  delete mLab[i];
  delete mBut[i];
  delete mText[i];
  delete mButdr[i];
  delete mButcf[i];
  }
for(int i=0; i<6; i++)  delete mOpt[i];
delete mNlb;
}

/* --Methode-- */
void PIDrwTools::Show()
{
PIWindow::Show();
char buff[92]; 
mNDr = 0;
if ((mCurBW != NULL) && ( mCurBW->kind() == PIScDrawWdg::ClassId ) ) {
  PIScDrawWdg* scd = ( PIScDrawWdg*)mCurBW;
  sprintf(buff, "%g  %g", scd->XMin(), scd->XMax());
  mText[0]->SetText(buff);
  sprintf(buff, "%g  %g", scd->YMin(), scd->YMax());
  mText[1]->SetText(buff);
  if (scd->NbDrawers() > 1)  mNDr = 1;
  }
else {
  mText[0]->SetText("-1.0  1.0");
  mText[1]->SetText("-1.0  1.0");
  }
sprintf(buff, "%d", mNDr);
mNlb->SetLabel(buff);

mCkb[0]->SetState(false);
mCkb[1]->SetState(false);

mOpt[0]->SetValue(101);
mOpt[1]->SetValue(200);
mOpt[2]->SetValue(301);
mOpt[3]->SetValue(405);
mOpt[4]->SetValue(500);
mOpt[5]->SetValue(601);

return;
}


/* --Methode-- */
void PIDrwTools::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
PIColors cols[9] = { PI_NotDefColor, PI_Black, PI_White,  
                     PI_Grey, PI_Red, PI_Blue, 
                     PI_Green, PI_Yellow, PI_Magenta};

PIMarker mrk[11] = { PI_DotMarker, PI_PlusMarker, PI_CrossMarker,
                     PI_CircleMarker, PI_FCircleMarker,
                     PI_BoxMarker, PI_FBoxMarker,
                     PI_TriangleMarker, PI_FTriangleMarker,
                     PI_StarMarker, PI_FStarMarker };
PILineAtt line[4] = { PI_NotDefLineAtt, PI_ThinLine, PI_NormalLine, PI_ThickLine};

PIFontAtt fntatt[3] = { PI_RomanFont, PI_BoldFont, PI_ItalicFont };
PIFontSize fntsz[3] = { PI_NormalSizeFont, PI_SmallSizeFont, PI_BigSizeFont };
CMapId cmap[11] = {  CMAP_OTHER, CMAP_GREY32, CMAP_GREYINV32,
                     CMAP_COLRJ32, CMAP_COLBR32, CMAP_COLRV32,  
                     CMAP_GREY128, CMAP_GREYINV128, CMAP_COLRJ128, CMAP_COLBR128, CMAP_COL16 };

msg = UserMsg(msg);
if (msg == 2600)  { Hide(); return; }

if (mCurBW == NULL)   return;

char strg[64];
float xmin, xmax, ymin, ymax;
int axrl = kAxeDirLtoR;
int ayud = kAxeDirDownUp;
int k, kk;

switch (msg) {

  case 2500 :
    sscanf(mText[0]->GetText().c_str(), "%g %g" , &xmin, &xmax);
    sscanf(mText[1]->GetText().c_str(), "%g %g" , &ymin, &ymax);
    if (mCkb[0]->GetState())  axrl = kAxeDirRtoL ;
    if (mCkb[1]->GetState())  ayud = kAxeDirUpDown;
    printf("--DBG-- %g-%g , %g-%g , %d %d \n", xmin, xmax, ymin, ymax, axrl, ayud);
    if ( mCurBW->kind() == PIScDrawWdg::ClassId ) ((PIScDrawWdg*)mCurBW)-> SetLimits(xmin, xmax, ymin, ymax, axrl, ayud);
    else mCurBW->SetDefaultDrawerLimits(xmin, xmax, ymin, ymax, axrl, ayud);
    mCurBW->Refresh();
    break;

  case 2800 :
  case 2900 :
    {
    PIDrawer* drw = mCurBW->GetDrawer(mNDr);
    if (drw == NULL)  return;
    k = mOpt[0]->GetValue()-100;
    if ( (k < 0) || (k > 8) )  k = 0;
    drw->SetColAtt(cols[k]);
    k = mOpt[1]->GetValue()-200;
    if ( (k < 0) || (k > 10) )  k = 0;
    drw->SetColMapId(cmap[k]);
    k =  mOpt[2]->GetValue()-300;
    if ( (k < 0) || (k > 10) )  k = 0;
    kk =  mOpt[3]->GetValue()-400;
    if ( (kk < 1) || (kk > 27) )  kk = 1;
    drw->SetMarkerAtt(kk, mrk[k]);
    k =  ((mOpt[4]->GetValue()-500)/10)%3;
    kk = (mOpt[4]->GetValue()-500-10*k)%3;
    drw->SetFontAtt(fntsz[k], fntatt[kk]);
    k =  mOpt[5]->GetValue()-600;
    if ( (k < 0) || (k > 3) )  k = 0;
    drw->SetLineAtt(line[k]);
    if (msg == 2800) drw->Refresh();
    else mCurBW->Refresh();
    }
    break;        

  case 3501 :
    mNDr--;  
    if (mNDr < 0)  mNDr = 0;
    sprintf(strg, "%d", mNDr);
    mNlb->SetLabel(strg);
    break;
  case 3502 :
    mNDr++;  
    if (mNDr >= mCurBW->NbDrawers())  mNDr--;
    sprintf(strg, "%d", mNDr);
    mNlb->SetLabel(strg);
    break;

  default :
    break;
  }

return;
}

