#include "pipodrw.h"
#include "generalfit.h"

//================================================================
// PIFuncDrawer
//================================================================

PIFuncDrawer::PIFuncDrawer(PIFuncDrawer::FUNC f)
: mFunc(f)
{}

PIFuncDrawer::~PIFuncDrawer()
{
}

void
PIFuncDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float/*ymin*/, float/*xmax*/, float/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  float xMax = x2;
  float xMin = x1;
  float yMax = y2;
  float yMin = y1;
  float xStep = (xMax - xMin)/100;
  float xOld = xMin;
  float yOld = mFunc(xMin);
  for (float x = xMin+xStep; x<xMax; x+=xStep) {
    double y = mFunc(x);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

//================================================================
// PIGFFDrawer
//================================================================

PIGFFDrawer::PIGFFDrawer(GeneralFunction* f)
: mFunc(f), mNParms(f->NPar()), mParms(new double[mNParms])
{
  ASSERT(f->NVar() == 1);
}

PIGFFDrawer::~PIGFFDrawer()
{
  delete[] mParms;
}

void
PIGFFDrawer::SetParms(double const* p)
{
  for (int i=0; i<mNParms; i++)
    mParms[i] = p[i];
}


void
PIGFFDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float/*ymin*/, float/*xmax*/, float/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  float xMax = x2;
  float xMin = x1;
  float yMax = y2;
  float yMin = y1;
  float xStep = (xMax - xMin)/100;
  float xOld = xMin;
  float yOld = 0;
//  float yOld = f->Value(&xMin, mParms);
  for (float x = xMin+xStep; x<xMax; x+=xStep) {
   float y = 0; // $CHECK$
//    float y = f->Value(&x, mParms);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

