#ifndef LightPtSrcLevSInBand_H
#define LightPtSrcLevSInBand_H

#include <iostream>
#include <map>
//#include "levsptsrc.h"

#include "levelsplanckband.h"

struct LevSPtSrcData 
{ 	float flux30G;
	float flux44G;
	float flux70G;
	float flux100G;
	float flux143G;
	float flux217G;
	float flux352G;
	float flux545G;
	float flux857G;
	
	float getPower(LevSPanckBand band) const
	{	// Unit depend of context be carefull!
		switch (band)
		{	case Giga30: return flux30G;
			case Giga44: return flux44G;
			case Giga70: return flux70G;
			case Giga100: return flux100G;
			case Giga143: return flux143G;
			case Giga217: return flux217G;
			case Giga352: return flux352G;
			case Giga545: return flux545G;
			case Giga857: return flux857G;
			default:
			{	cerr<<"Erreur lecture de puissance dans LevSPtSrc::getPower. Exit(-1)"<<endl;
				exit(-1);
				return 0;
			}
		}
	 
	}
	
};

struct LevSPtSrcCmpUnitVec 
{ 	bool operator()(const UnitVector& coord1, const UnitVector& coord2) const
	{	if ( coord1.Theta() < coord2.Theta() )  return true;
		if (  coord1.Theta() == coord2.Theta() ) 
		{	if (  coord1.Phi() > coord2.Phi() ) return true;
		}	
		return false;
	}
};

class LightPtSrcLevSInBand
{
 public:
	LightPtSrcLevSInBand(char FileOfPtSrc[]);
	~LightPtSrcLevSInBand() {}
	//	double powSpec(double theta,double phi,LevSPanckBand Band);
	// Return power in band in Watt/m2
	multimap <UnitVector,LevSPtSrcData,LevSPtSrcCmpUnitVec> MapOfPtSrc;
	void print(ostream& out)
	{	out<< Name<<endl; }
	void DumpMap(LevSPanckBand band);
		// Write a Mollweide projection of the Point Sources Sky
		// power in the LevSPanckBand band
	
 protected:
	void readLevSPtSrc(char HFIfile[]);
	char Name[128];

};

#endif

