			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef SigCalcTools_H
#define SigCalcTools_H

#include "abslightsource.h"
#include "abscalctool.h"

#include "integ.h"

enum CalcOptions {NonSeparable,AllSeparable,IsLightMapPowerInband};

class SigCalcTool:public AbsCalcTool {
friend double SigCalGLFreqFunc1(double freq);
friend double SigCalGLFreqFunc2(double freq);

public:
  SigCalcTool(AbsLightSource* pLSrc, AbsLobeNoPolar* pLobe, SpectralResponse* pFilter);
  ~SigCalcTool() {	delete pIntegrale;}
  
 inline void SetLightScr(AbsLightSource* pLightScr) 
 	// require to rerun SigCalcToolInit
 {	pLSrc=pLightScr;
	delete pIntegrale;
	SigCalcToolInit();
 }
  
 double compPixel(UnitVector& VP, UnitVector& VY);
  	// Return power on detector (Watt/m2) for this Lobe and filter
    // Pointing at these ccordinates. with this telescope orientation
    // Exact
    
 virtual void print(ostream& ReadMe)
 {	ReadMe<<" La source physique: "<<endl;
	pLSrc->print(ReadMe);
	ReadMe<<" Le Lobe : "<<endl;
	pLobe->print(ReadMe);
	ReadMe<<" Le Filtre: "<<endl;
	pFilter->Print(ReadMe);	
	ReadMe<<endl;
 }

 double CalcLobeSize(double frequency= -10.);
 // Calcule l'extension spatiale du lobe de cet outil
 // par integration numerique, calquee sur 
 // L'integration spatiale de powerInteg();
 // VALEUR RETOUR EN STERADIAN
 // Doit EVOLUER SI powerInteg CHANGE;
 
 	
// Ces fonctions servent au hackingtools. elle palient le fait que je n'ai pas reussi
// A declarer friend la fonction (refu du compilo de donner acces aux variables protected.
// friend void addInInBandPowerMap(PixelMap<double>& Map, SigCalcTool& Tool);
// Ne pas utiliser! 	
 inline AbsLightSource* getpLSrc() const {return pLSrc;}
 inline AbsLobeNoPolar* getpLobe() const {return pLobe;}
 inline SpectralResponse* getpFilter() const {return pFilter;}
 inline CalcOptions getOption() const {return Option;}
 inline double getFreqMin() {return FreqMin;}
 inline double getFreqMax() {return FreqMax;}
 inline double getIntegSpectOverFreq() {return IntegSpectOverFreq;}
  

 
protected:
 AbsLightSource* pLSrc;
 CalcOptions Option;	// Used to drives computations optimisations
 GLInteg* pIntegrale;
 
 bool emptySignal;
 double IntegSpectOverFreq;

 UnitVector VPointe;	// Boresigth du telescope (axe "Z" in Ticra focal plan)
 UnitVector VY;  		// Axe "Y" of telescope ("horizontal") usefull when lobe are not symetrical
 UnitVector VX;			// By rotation around Z axis.
 UnitVector VCur;		// VCur, vecteur courant du calcul.
 void SigCalcToolInit();
 inline double AngResComp(double angle) const;
    // Return current angle resolution of lobe computation 
    // From map resolution lobe parameters. Unit: Radian 
    
 UnitVector VecOrigin(UnitVector VPointe);
    // Define where high resolution computations starts. 
    // Usually, it's where the horns point to
    // Usefull with QuasiPtSources. You then want to compute around the source.
    // Usefull when lobe as offsets in direction, 
    	// Because he is not in the central part of focal plane. (TTicra data)
 
 // Tools dealing with integration over space or frequency or both.  
 double calcPowerDens() const;
  	// compute the power integrated on frequency dependance, (Lobe and LightSource and filter)
   // on pourra en avoir plusieur versions
 
 double powerInteg();
 	// Compute the power recieved by a bolometer (Integration over space)
 	// Pointing towards XX
 	// From a source LSrc, with a lobe parametrised in Lobe, and an additionnal filter Filter
	// WeigthVsFreq
};


#endif